import("pathfinder.road", "RoadPathFinder", 3);


class DumbAI extends AIController
{
	
	coal = false;
	othercarg = false;
	done = false;
	failroad = 0;
	failroad1 = 0;
	myCarg = AIList();
	myMines = AIList();
	myProducers = AIList();
	myAccepters = AIList();
	myVeh = AIList();
	function Start();
	globaldist = 0;

}

function DumbAI::Start()
  {
  local cargoes = AICargoList();
	//set coal cargoID
  foreach (cargo, value in cargoes) {
    if( AICargo.GetCargoLabel(cargo) == "COAL") {
      coal = cargo;
	  othercarg = cargo;
	  myCarg.AddItem(coal, 0);
      break;
    }
  }
  
  
  
  while(true)
  {
  
	  
  while(done == false)
  {
	 local maxloan = AICompany.GetMaxLoanAmount();
	  local loan = AICompany.GetLoanAmount();
	  local bank = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	  local interval = AICompany.GetLoanInterval();
	  if(bank < 200000)
	  {
	  AICompany.SetLoanAmount(maxloan);
	  loan = AICompany.GetLoanAmount();
	  }
  //set CoalmineList and sort out ones that have stations nearby
	local coalmines = AIIndustryList_CargoProducing(coal);
	
	coalmines.Valuate(AIIndustry.GetLastMonthProduction, coal);
	local myMine  = coalmines.Begin();
	//if noone built at the mine
	
	foreach (mine, value in coalmines) {
		if(AIIndustry.GetAmountOfStationsAround(mine) == 0){
			myMine = mine;
			break;
			
		}
	}
	if(AIIndustry.GetAmountOfStationsAround(myMine) == 0)
	{
	myProducers.AddItem(myMine, 0);
	
	local signMine = AISign.BuildSign(AIIndustry.GetLocation(myMine), "origin");
	  
	//find nearest Powerplant to bring coal to
	local powerplants = AIIndustryList_CargoAccepting(coal);
  powerplants.Valuate(AIIndustry.GetDistanceManhattanToTile, AIIndustry.GetLocation(myMine));
  powerplants.Sort(AIList.SORT_BY_VALUE, true);
  local myPower = powerplants.Begin();
	local signPower = AISign.BuildSign(AIIndustry.GetLocation(myPower), "destination");
  
  //find Tile to build first Station  
  //Start and Endpoint of road
  
  local Endpoint = AIIndustry.GetLocation(myPower);
  
  local Startpoint = AIIndustry.GetLocation(myMine);

	local depots = AIDepotList(AITile.TRANSPORT_ROAD);
	
	local stationStart = this.BuildRoadStation(Startpoint);
	
	if(stationStart || stationStart == 0)
	{
		
	local stationEnd = this.BuildRoadStation(Endpoint);
	
	if(AIStation.IsValidStation(AIStation.GetStationID(stationEnd))){
	myAccepters.AddItem(stationEnd,0);
	}
	
	if(stationEnd || stationEnd == 0)
	{
	depots.Valuate(AITile.GetDistanceManhattanToTile, stationEnd);
	depots.Sort(AIList.SORT_BY_VALUE, true);
	local depot1 = depots.Begin();
	if(AITile.GetDistanceManhattanToTile(stationEnd, depots.Begin()) > 10 || AITile.GetDistanceManhattanToTile(stationEnd, depots.Begin()) == (-1))
	{
		
		depot1 = this.BuildDepot(stationEnd);
		
	}

	depots.Valuate(AITile.GetDistanceManhattanToTile, stationStart);
	depots.Sort(AIList.SORT_BY_VALUE, true);
	local depot = depots.Begin();
	
	if(AITile.GetDistanceManhattanToTile(stationStart, depots.Begin()) > 10 || AITile.GetDistanceManhattanToTile(stationEnd, depots.Begin()) == (-1))
	{
		depot = this.BuildDepot(stationStart);
		
	}
	
    myMines.AddItem(stationStart, 0);
  //build road
  
  
  if(depot != '0' || AIMap.IsValidTile(depot)){
	  this.BuildRoad(depot,stationStart);
	   while(failroad != 0){
		  this.BuildRoad(depot, failroad);
	  }
  }
  if(depot1 != '0' || AIMap.IsValidTile(depot1)){
  	this.BuildRoad(depot1,stationEnd);
	while(failroad != 0){
		  this.BuildRoad(depot1, failroad);
	  }
  }
  if(stationStart != '0' || AIMap.IsValidTile(stationStart)){
	  this.BuildRoad(stationStart,stationEnd);
	  while(failroad!=0)
	  {
		this.BuildRoad(failroad, stationStart);
	  }
  }
  
  globaldist = AITile.GetDistanceManhattanToTile(stationStart, stationEnd);
  local DistanceVeh = (globaldist / 15)-1;
  
  if(DistanceVeh < 0) {DistanceVeh = 0;}
  local productionInd = AIIndustry.GetLastMonthProduction(myMine, coal);
  local engines = AIEngineList(AIVehicle.VT_ROAD);
  engines.Valuate(AIEngine.CanRefitCargo, coal)
  engines.KeepValue(1); 
  if((AICargo.GetCargoLabel(othercarg) == "STEL" || AICargo.GetCargoLabel(othercarg) == "OIL_" || AICargo.GetCargoLabel(othercarg) == "WOOD" || AICargo.GetCargoLabel(othercarg) == "COAL" || AICargo.GetCargoLabel(othercarg) == "IORE") && (globaldist < 40))
  {
	  engines.Valuate(AIEngine.GetCapacity);
  }
  else{
  engines.Valuate(AIEngine.GetMaxSpeed);
  }
  
  local enginecap = AIEngine.GetCapacity(engines.Begin());
  local startVehs = (productionInd/enginecap)+DistanceVeh;
  if(startVehs==0){startVehs = 1;}
  AILog.Info("Building " + startVehs+ " vehicles because Ind. produces: " + productionInd+" and distanceVehicles= " + DistanceVeh);
	for(local i = 0; i<startVehs;i++)
	{
	  local truck = this.BuildTruck(depot, coal);
	  this.SetOrders(truck, stationStart,stationEnd);
	}
  
  
  
  bank = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	local payback  = loan-((bank/interval)*interval);
	if(payback < 0) {payback=0;}
	AICompany.SetLoanAmount(payback);
	
	AISign.RemoveSign(signMine);
	AISign.RemoveSign(signPower);
	}
	else
	{
		if(AITile.DemolishTile(stationStart)) 
		{
			AISign.RemoveSign(signMine);
			AISign.RemoveSign(signPower);
			done=true;
		}
	}
	}
	}
	else{
	
	local bank = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	local maxloan = AICompany.GetMaxLoanAmount();
	  local loan = AICompany.GetLoanAmount();
	  
	  local interval = AICompany.GetLoanInterval();
	  if(bank < 200000)
	  {
	  AICompany.SetLoanAmount(maxloan);
	  loan = AICompany.GetLoanAmount();
	  }

  //set producer and sort out ones that have stations nearby
	local producer = false;
	local production = 0;
	foreach (cargo, value in cargoes) {
		local industries = AIIndustryList_CargoProducing(cargo);
	
		foreach(industry, value in industries) {
			if(AICargo.GetCargoLabel(cargo) != "GOOD" && AICargo.GetCargoLabel(cargo) != "VALU")
			{
			if(AIIndustry.GetLastMonthProduction(industry, cargo) > production && !AIIndustry.IsBuiltOnWater(industry)) {
				if(AIIndustry.GetAmountOfStationsAround(industry) == 0)
				{
					production = AIIndustry.GetLastMonthProduction(industry, cargo);
					producer = industry;
					othercarg = cargo;
					myProducers.AddItem(industry, 0);
					myCarg.AddItem(othercarg, 0);
					break;
				}
				}
				Sleep(5);
			}
		}
		
		production = 0;
		if(producer==false && AICargo.GetCargoLabel(cargo) != "STEL")
		{
			foreach(industry, value in industries) 
			{
			if(AICargo.GetCargoLabel(cargo) != "GOOD" && AICargo.GetCargoLabel(cargo) != "VALU")
				{
			if(AIIndustry.GetLastMonthProduction(industry, cargo) > production && !AIIndustry.IsBuiltOnWater(industry)) {
				if(AIIndustry.GetLastMonthTransportedPercentage(industry, cargo) == 0)
						{
					production = AIIndustry.GetLastMonthProduction(industry, cargo);
					producer = industry;
					othercarg = cargo;
					myProducers.AddItem(industry, 0);
					myCarg.AddItem(othercarg, 0);
					break;
						}
					}
				}
			}
		}
    }
  
	if(producer != false)
	{
	AILog.Info("Next Producer will be: " + AIIndustry.GetName(producer) + " with the Cargo :" + AICargo.GetCargoLabel(othercarg));
	
	local Startpoint = AIIndustry.GetLocation(producer);
  
	local accepters = AIIndustryList_CargoAccepting(othercarg);
	accepters.Valuate(AIIndustry.GetDistanceManhattanToTile, AIIndustry.GetLocation(producer));
	accepters.Sort(AIList.SORT_BY_VALUE, true);
	local myaccepters = accepters.Begin();

    local Endpoint = AIIndustry.GetLocation(myaccepters);
  
	local signA = AISign.BuildSign(AIIndustry.GetLocation(myaccepters), "destination");
	local signP = AISign.BuildSign(AIIndustry.GetLocation(producer), "origin");
	
	local depots = AIDepotList(AITile.TRANSPORT_ROAD);
	
  
	local stationStart = this.BuildRoadStation(Startpoint);
	myMines.AddItem(stationStart, 0);
	if(stationStart || stationStart == 0)
	{
	local stationEnd = this.BuildRoadStation(Endpoint);
	myAccepters.AddItem(stationEnd,0);
	if(stationEnd || stationEnd == 0)
	{
	depots.Valuate(AITile.GetDistanceManhattanToTile, stationEnd);
	depots.Sort(AIList.SORT_BY_VALUE, true);
	local depot1 = depots.Begin();
	
	if(AITile.GetDistanceManhattanToTile(stationEnd, depots.Begin()) > 10)
	{
		depot1 = this.BuildDepot(stationEnd);
		
	}
	
	depots.Valuate(AITile.GetDistanceManhattanToTile, stationStart);
	depots.Sort(AIList.SORT_BY_VALUE, true);
	local depot = depots.Begin();
	
	if(AITile.GetDistanceManhattanToTile(stationStart, depots.Begin()) > 10)
	{
		depot = this.BuildDepot(stationStart);
		
	}
	myAccepters.AddItem(AIStation.GetStationID(stationEnd), 0);
	
  //build road
  if(depot != '0' || AIMap.IsValidTile(depot)){
	  this.BuildRoad(depot,stationStart);
	   while(failroad != 0){
		  this.BuildRoad(depot,failroad);
	  }
  }
  if(depot1 != '0' || AIMap.IsValidTile(depot1)){
  	this.BuildRoad(depot1,stationEnd);
	while(failroad != 0){
		  this.BuildRoad(depot1, failroad);
	  }
  }
  if(stationStart != '0' || AIMap.IsValidTile(stationStart)){
	  this.BuildRoad(stationStart, stationEnd);
	  while(failroad!=0)
	  {
		this.BuildRoad(failroad, stationStart);
	  }
  }
  
  globaldist = AITile.GetDistanceManhattanToTile(stationStart, stationEnd);
	local DistanceVeh = ( globaldist/ 15)-1;
	if(DistanceVeh<0){DistanceVeh=0;}
  local productionInd = AIIndustry.GetLastMonthProduction(producer, othercarg);
  local engines = AIEngineList(AIVehicle.VT_ROAD);
  engines.Valuate(AIEngine.CanRefitCargo, othercarg)
  engines.KeepValue(1); 
  if((AICargo.GetCargoLabel(othercarg) == "STEL" || AICargo.GetCargoLabel(othercarg) == "OIL_" || AICargo.GetCargoLabel(othercarg) == "WOOD" || AICargo.GetCargoLabel(othercarg) == "COAL" || AICargo.GetCargoLabel(othercarg) == "IORE") && (globaldist < 40))
  {   
	engines.Valuate(AIEngine.GetCapacity);
  }
  else{
	engines.Valuate(AIEngine.GetMaxSpeed);
  }
  
  local enginecap = AIEngine.GetCapacity(engines.Begin());
  local startVehs = (productionInd/enginecap)+DistanceVeh;
  if(startVehs==0){startVehs = 1;}
    AILog.Info("Building " + startVehs+ " vehicles because Ind. produces: " + productionInd+" and distanceVehicles= " + DistanceVeh);

	
	for(local i = 0; i<startVehs;i++)
	{
	local truck = this.BuildTruck(depot, othercarg);
	this.SetOrders(truck, stationStart,stationEnd);
	}
	bank = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	local payback  = loan-((bank/interval)*interval);
	if(payback < 0) {payback=0;}
	AICompany.SetLoanAmount(payback);
	
	AISign.RemoveSign(signA);
	AISign.RemoveSign(signP);
	}
	else
	{
		if(AITile.DemolishTile(stationStart)) 
		{
			AISign.RemoveSign(signMine);
			AISign.RemoveSign(signPower);
			done=true;
		}
	}
	}
	}
	
	else{
	
	AILog.Info("Nothing more to do");
	done=true;
	}
	}
 }
 
 while(done==true)
 {
 AILog.Info("Managing Fleet...");

	this.ManageFleet();
	Sleep(150);
	foreach(stationProd, value in myMines)
	{
		local vehstat = AIVehicleList_Station(AIStation.GetStationID(stationProd));
		if(vehstat.Count() < 1)
		{
			AITile.DemolishTile(stationProd);
		}
	}
	foreach(stationAcc, value in myAccepters)
	{
		local incoming = AIVehicleList_Station(AIStation.GetStationID(stationAcc));
		local incnr = incoming.Count();
		local StatTiles = AITileList();
		local StatCount = 0;
		local LocX = AIMap.GetTileX(stationAcc);
		local LocY = AIMap.GetTileY(stationAcc);
		local tile1 = AIMap.GetTileIndex(LocX-2,LocY-2);
		local tile2 = AIMap.GetTileIndex(LocX+2,LocY+2);
		local start = 0;
		StatTiles.AddRectangle(tile1,tile2);
		foreach(tile, value in StatTiles)
		{
			if(AITile.IsStationTile(tile) && AITile.GetOwner(tile)==(255-AICompany.COMPANY_SELF))
			{
				StatCount++;
				start = tile;
			}
		}
		
		if(incnr > (30*StatCount))
		{
			AILog.Info("Extending Station");
			local end = this.ExtendStation(stationAcc);
			if(end)	this.BuildRoad(start, end);
		}
		Sleep(10);
	}
	
	local loandiff = AICompany.GetMaxLoanAmount() - AICompany.GetLoanAmount();
	if((AICompany.GetBankBalance(AICompany.COMPANY_SELF)+loandiff) > 100000)
	{
		done=false;
	}
 }
  }
}

function DumbAI::ManageFleet() {
	local maxloan = AICompany.GetMaxLoanAmount();
	local bank = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	if (bank<200000)
	{
	AICompany.SetLoanAmount(maxloan);
	}
	foreach(carg, value in myCarg) {
		AILog.Info("Managing Fleet for cargo:"+AICargo.GetCargoLabel(carg));
	foreach (mine, value in myMines) {
	  
    if (AIStation.HasCargoRating(AIStation.GetStationID(mine), carg)) {
		
      // If a station rating falls below 60%, clone a truck
      if (AIStation.GetCargoRating(AIStation.GetStationID(mine), carg) < 59) {
		AILog.Info("Station rating low");
        this.CloneFleet(AIStation.GetStationID(mine));
      }
    }
  }
	}
	local a = 0;
  foreach (veh, value in myVeh)
	{
		if(AIVehicle.IsValidVehicle(veh))
		{
		 local age = AIVehicle.GetAge(veh);
		 local agemax = AIVehicle.GetMaxAge(veh);
		 age = age/365;
		 agemax = agemax/365;
		 
		 if(AIVehicle.IsValidVehicle(veh)&&AIVehicle.GetProfitLastYear(veh) < 0&&AIVehicle.GetProfitThisYear(veh) < 0 && age > 4)
		 {
			 AIVehicle.SendVehicleToDepot(veh);
			 while(!AIVehicle.IsStoppedInDepot(veh))
			 {
				 
				 AILog.Info("Waiting until negativ profit Vehicle is in Depot..." + AIVehicle.GetName(veh));
				 Sleep(50);
			 }
			 AIVehicle.SellVehicle(veh);
			 a++;
			 if(a==10)
		 {
			 break;
		 }
		 }
		 
		 if(age>(agemax-7))
		 {
			 othercarg=AIEngine.GetCargoType(veh);
			 this.renewVehicle(veh);
			 a++;
		 }
		 if(a==10)
		 {
			 break;
		 }
		 
		}
		if(a==10)
		 {
			 break;
		 }
	}
	local loan = AICompany.GetLoanAmount();
	local bank = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	local interval = AICompany.GetLoanInterval();
	local payback  = loan-((bank/interval)*interval);
	if(payback < 0) {payback=0;}
	AICompany.SetLoanAmount(payback);
}

function DumbAI::CloneFleet(station) {
  local vehicles = AIVehicleList_Station(station);
  local vehicle = vehicles.Begin();
  local stationLocation = AIStation.GetLocation(station);

  local depots = AIDepotList(AITile.TRANSPORT_ROAD);
  depots.Valuate(AITile.GetDistanceSquareToTile, stationLocation);
  depots.Sort(AIList.SORT_BY_VALUE, true);
  local depot = depots.Begin();
  local newTruck = AIVehicle.CloneVehicle(depot, vehicle, true);
  myVeh.AddItem(newTruck, 0);
  AIVehicle.StartStopVehicle(newTruck);
  Sleep(20);
}

function DumbAI::BuildAround(tile)
{
	local xLoc = AIMap.GetTileX(tile)+1;
	local yLoc = AIMap.GetTileY(tile);
	
	
	//while(tile != tile2) {
	for (local x = 0; x > 2; x++) {
		for (local y = 0; y > 2; y++) {
		local tile1 = AIMap.GetTileIndex(xLoc+(x), yLoc+(y));
		local tile2 = AIMap.GetTileIndex(xLoc+(x)+1, yLoc+(y));
		AIRoad.BuildRoad(tile1,tile2);
		}
	//}
	}
}



function DumbAI::renewVehicle(vehicle)
{
	if(AIVehicle.IsValidVehicle(vehicle))
	{
	if(AIVehicle.SendVehicleToDepot(vehicle))
	{
		local i = 0;
	while(!AIVehicle.IsStoppedInDepot(vehicle))
	{
	if(i==5)
		{		
			AILog.Info("Waiting for Vehicle to stop in Depot..."+AIVehicle.GetName(vehicle));
			i=0;
		}
		
		i++;
		Sleep(5);
	}
	local LocVeh = AIVehicle.GetLocation(vehicle);
	local depots = AIDepotList(AITile.TRANSPORT_ROAD);
	depots.Valuate(AITile.GetDistanceSquareToTile, LocVeh);
	depots.Sort(AIList.SORT_BY_VALUE, true);
	local depot = depots.Begin();
	
	local currEngine = AIVehicle.GetEngineType(vehicle);
	othercarg=AIEngine.GetCargoType(currEngine);
	local engines = AIEngineList(AIVehicle.VT_ROAD);
	
	engines.Valuate(AIEngine.GetCargoType)
  engines.KeepValue(othercarg); 
  
	engines.Valuate(AIEngine.GetMaxSpeed);
	local engine = engines.Begin();
	

	if(engine == currEngine)
	{
	local renewVeh = AIVehicle.CloneVehicle(depot, vehicle, true);
	AIVehicle.RefitVehicle(renewVeh, othercarg);
	if (AIVehicle.IsValidVehicle(renewVeh))
		{
				AIVehicle.SellVehicle(vehicle);
		}
	myVeh.AddItem(renewVeh, 0);
	AIVehicle.StartStopVehicle(renewVeh);
	}
	else
	{
	local renewVeh = AIVehicle.BuildVehicle(depot, engine);
	AIVehicle.RefitVehicle(renewVeh, othercarg);
	if (AIVehicle.IsValidVehicle(renewVeh))
		{
			AIOrder.CopyOrders(renewVeh,vehicle )
				AIVehicle.SellVehicle(vehicle);
		}
	AIVehicle.StartStopVehicle(renewVeh);
	myVeh.AddItem(renewVeh, 0);
	}
	}
	}
}


function DumbAI::BuildRoadStation(tile)
{
	
	local myStation = 0;

	AILog.Info("Build Station at:" + tile);
	local xLoc = AIMap.GetTileX(tile);
  local yLoc = AIMap.GetTileY(tile);
	local maxX = AIMap.GetMapSizeX();
	local maxY = AIMap.GetMapSizeY();
local Stat = 0;
	
  xLoc = xLoc + 4;
  yLoc = yLoc + 4;
  if (xLoc < 2) xLoc = 2;
  if (yLoc < 2) yLoc = 2;
  if (xLoc > (maxX-2)) xLoc = (maxX-2); 
  if (yLoc > (maxY-2)) yLoc = (maxY-2);
	
  for (local x=0; x > -8; x--) {
    for (local y=0; y > -8; y--) {
	  
      local tile1 = AIMap.GetTileIndex(xLoc+x, yLoc+y);
      local tile2 = AIMap.GetTileIndex(xLoc+x+1, yLoc+y);
	  local tile3 = AIMap.GetTileIndex(xLoc+x-1, yLoc+y);
	  if((((AITile.IsBuildable(tile1) || AIRoad.IsRoadTile(tile1)) && (AITile.IsBuildable(tile2) || AIRoad.IsRoadTile(tile2))) || ((AITile.IsBuildable(tile1) || AIRoad.IsRoadTile(tile1)) && (AITile.IsBuildable(tile3) || AIRoad.IsRoadTile(tile3))) && (AITile.GetSlope(tile1) == AITile.SLOPE_FLAT) && (AITile.GetCargoAcceptance(tile1,othercarg, 1, 1, 3) > 7 || AITile.GetCargoProduction(tile1,othercarg, 1, 1, 3) > 0)))
	  {
		  if(!AITile.IsBuildable(tile2) && !AIRoad.IsRoadTile(tile2) && !AIRoad.IsRoadDepotTile(tile2))
		  {
		  if(AITile.IsBuildableRectangle(tile3, 2, 1) || AITile.IsBuildableRectangle(tile3, -2, -1) || AIRoad.IsRoadTile(tile3))
		  {
		  local station = AIStationList(AIStation.STATION_TRUCK_STOP);
		  local distS = 10;
		  local stationtile = 0;
		  local Stat = 0;
		  
		  foreach(stat, value in station)
		  {
			local stationtilel = AITileList_StationType(stat,AIStation.STATION_TRUCK_STOP);
			if(AITile.GetDistanceManhattanToTile(tile1, stationtilel.Begin()) < distS)
			{
				distS = AITile.GetDistanceManhattanToTile(tile1, stationtilel.Begin());
				stationtile = stationtilel.Begin();
				Stat = stat;
			}
		  }
		 
		  
		  if(AIStation.IsValidStation(Stat) && (Stat != 0))
		  {  
	  
			  if(AITile.GetCargoAcceptance(stationtile, othercarg,1,1,3) >7)
			  {
				  
				  myStation = stationtile;
				  break;
			  }
		  }
		  if (AIRoad.BuildDriveThroughRoadStation(tile1, tile3, AIRoad.ROADVEHTYPE_TRUCK, AIStation.STATION_NEW)) {
			  if(AITile.GetSlope(tile2) != AITile.SLOPE_FLAT)
			  {
				  AITile.LevelTiles(tile1,tile3);
			  }
			myStation = tile1;
			break;
		  }
		  }
	  }
	  else if(!AITile.IsBuildable(tile3) && !AIRoad.IsRoadTile(tile3) && !AIRoad.IsRoadDepotTile(tile3))
	  {
		  if(AITile.IsBuildableRectangle(tile2, 2, 1) || AITile.IsBuildableRectangle(tile2, -2, 1))
		{
		  local station = AIStationList(AIStation.STATION_TRUCK_STOP);
		  local distS = 10;
		  local stationtile = 0;
		  local Stat = 0;
		  foreach(stat, value in station)
		  {
			local stationtilel = AITileList_StationType(stat,AIStation.STATION_TRUCK_STOP);
			if(AITile.GetDistanceManhattanToTile(tile1, stationtilel.Begin()) < distS)
			{
				distS = AITile.GetDistanceManhattanToTile(tile1, stationtilel.Begin());
				stationtile = stationtilel.Begin();
				Stat = stat;
			}
		  }
		  
		  if(AIStation.IsValidStation(Stat) && (Stat != 0))
		  {  
			  if(AITile.GetCargoAcceptance(stationtile, othercarg,1,1,3) >7)
			  {
				  myStation = stationtile;
				  break;
			  }
		  }
		  if (AIRoad.BuildDriveThroughRoadStation(tile1, tile2, AIRoad.ROADVEHTYPE_TRUCK, AIStation.STATION_NEW)) {
			  if(AITile.GetSlope(tile2) != AITile.SLOPE_FLAT)
			  {
				  AITile.LevelTiles(tile1,tile2);
			  }
			myStation = tile1;
			break;
		  }
		}
		  
		  
		  if(AIRoad.IsRoadTile(tile2))
		  {  
			if(AIRoad.BuildRoad(tile2,tile1))
			{				
			  local station = AIStationList(AIStation.STATION_TRUCK_STOP);
		  local distS = 10;
		  local stationtile = 0;
		  local Stat = 0;
		  foreach(stat, value in station)
			  {
				local stationtilel = AITileList_StationType(stat,AIStation.STATION_TRUCK_STOP);
				if(AITile.GetDistanceManhattanToTile(tile1, stationtilel.Begin()) < distS)
				{
					distS = AITile.GetDistanceManhattanToTile(tile1, stationtilel.Begin());
					stationtile = stationtilel.Begin();
					Stat = stat;
				}
			  }
		  
		  if(AIStation.IsValidStation(Stat) && (Stat != 0))
			  {  
				  if(AITile.GetCargoAcceptance(stationtile, othercarg,1,1,3) >7)
				  {
					  myStation = stationtile;
					  break;
				  }
			  }
		  if (AIRoad.BuildDriveThroughRoadStation(tile1, tile2, AIRoad.ROADVEHTYPE_TRUCK, AIStation.STATION_NEW)) 
			  {
				  if(AITile.GetSlope(tile2) != "AITile.SLOPE_FLAT")
				  {
					  AITile.LevelTiles(tile1,tile2);
				  }
				myStation = tile1;
				break;
			  }
		  }
		  }
	  }
	  }
	  
    }
    if (myStation != 0) {
      break;
    }
  
 }
	
  AILog.Info("built roadstation at " + myStation);
  return myStation;
}



function DumbAI::BuildRoad(Start, End)
{
local pathfinder = RoadPathFinder();
  AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
  pathfinder.cost.tile = 140;
  pathfinder.cost.slope = 50;
  pathfinder.cost.no_existing_road = 30;
  pathfinder.cost.bridge_per_tile = 50;
  pathfinder.cost.max_bridge_length = 15;
  pathfinder.InitializePath([Start], [End]);
	local timepath = 0;
	local time = 0;
	local path = false;
	while (path == false) {
	path = pathfinder.FindPath(300);
	time++;
	AILog.Info("Finding Path since "+time+" ticks...");
	if(time>1500)
	{
		failroad = End;
		break;
	}
	AIController.Sleep(1);
		}  
		
	while (path != null) {
		if(time>1500)
	{
		break;
	}
	
  local par = path.GetParent();
  local tryit = 0;
  
  if (par != null) {
    local last_node = path.GetTile();
    if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
		
		timepath++;
		
      if (!AIRoad.BuildRoad(path.GetTile(), par.GetTile())) {
		
		if(!AITile.IsBuildable(par.GetTile()) && !AITunnel.IsTunnelTile(par.GetTile()) && !AIRoad.IsRoadTile(par.GetTile()) && !AIBridge.IsBridgeTile(par.GetTile()) && !AIRoad.IsRoadDepotTile(par.GetTile()))
		{
			failroad = last_node;
			path = false;
			break;
		}
		local sign=AISign.BuildSign(path.GetTile(),"Error here");
		  while(!AIRoad.AreRoadTilesConnected(path.GetTile(), par.GetTile()))
		  {
			  if(AITunnel.IsTunnelTile(path.GetTile()))
			  {
				  break;
			  }
			  AIRoad.BuildRoad(path.GetTile(), par.GetTile());
			  AILog.Info("Error building road:" + path.GetTile() + " - " + par.GetTile());
			  if(!AIRoad.IsRoadTile(par.GetTile()))
			  {
			  AITile.DemolishTile(par.GetTile());
			  }
			  tryit++;
			  Sleep(50);
			  if(tryit > 40)
			  {
				failroad = last_node;
				path = false;
				break;
			  }
		  }
		  AISign.RemoveSign(sign);
		  if(tryit > 40)
		  {
			  break;
		  }
		  
      }
	  AILog.Info("building since " +timepath);
	  if(timepath == 20)
	  {
		local depots = AIDepotList(AITile.TRANSPORT_ROAD);
		depots.Valuate(AITile.GetDistanceManhattanToTile, path.GetTile());
		depots.Sort(AIList.SORT_BY_VALUE, true);
		local depot = depots.Begin();
			if(AITile.GetDistanceManhattanToTile(path.GetTile(), depots.Begin()) > 8 || AITile.GetDistanceManhattanToTile(path.GetTile(), depots.Begin()) == (-1))
			{
				
				depot = this.BuildDepot(path.GetTile());
				if(depot)
				{
				this.BuildRoad(depot,path.GetTile());	
				while(failroad != 0){
				this.BuildRoad(failroad, depot);
				}
				timepath =0;
				}
				else
				{
					timepath =10;
				}
			}
			else
			{
				if(AITile.GetDistanceManhattanToTile(path.GetTile(),Start)>8 && AITile.GetDistanceManhattanToTile(path.GetTile(),End)>8)
				{
				this.BuildRoad(depot,path.GetTile());
				while(failroad != 0)
					{
					this.BuildRoad(failroad, depot);
					}
				}
				timepath =0;
			}
			
	  }
    } else {
      /* Build a bridge or tunnel. */
      if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
        /* If it was a road tile, demolish it first. Do this to work around expended roadbits. */
        if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
        if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
          if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
			  AILog.Info("Can't build Tunnel");
			  Sleep(100);
            /* An error occured while building a tunnel. TODO: handle it. */
          }
        } else {
          local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1);
          bridge_list.Valuate(AIBridge.GetMaxSpeed);
          bridge_list.Sort(AIList.SORT_BY_VALUE, false);
          if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
            AILog.Info("Can't build Bridge");
			  Sleep(100);
          }
        }
      }
    }
  }
  
  path = par;
  failroad = 0;
  failroad1 = 0;
}

}


function DumbAI::ExtendStation(tile) {
  local xLoc = AIMap.GetTileX(tile);
  local yLoc = AIMap.GetTileY(tile);
  local ExtendStat = 0;
  local sign = AISign.BuildSign(tile,"ExtendStation");

  xLoc = xLoc - 1;
  yLoc = yLoc - 1;
  if (xLoc < 0) xLoc = 0;
  if (yLoc < 0) yLoc = 0;

	
  for (local x = 0; x < 4; x++) {
    for (local y = 0; y < 4; y++) {
		
      local tile1 = AIMap.GetTileIndex(xLoc+x, yLoc+y);
      local tile2 = AIMap.GetTileIndex(xLoc+x+1, yLoc+y);
	  local tile3 = AIMap.GetTileIndex(xLoc+x-1, yLoc+y);
	  local tile4 = AIMap.GetTileIndex(xLoc+x, yLoc+y-1);
	  local tile5 = AIMap.GetTileIndex(xLoc+x, yLoc+y+1);
	  
	  local tile6 = AIMap.GetTileIndex(xLoc+x+1, yLoc+y+1);
	  local tile7 = AIMap.GetTileIndex(xLoc+x-1, yLoc+y-1);
	  local tile8 = AIMap.GetTileIndex(xLoc+x+1, yLoc+y-1);
	  local tile9 = AIMap.GetTileIndex(xLoc+x-1, yLoc+y+1);

	  if((AITile.IsBuildable(tile1) || AIRoad.IsRoadTile(tile1)) && (AITile.IsBuildable(tile2) || AIRoad.IsRoadTile(tile2)))
	  {
		  if(AITile.IsStationTile(tile2) || AITile.IsStationTile(tile3) || AITile.IsStationTile(tile4) || AITile.IsStationTile(tile5) || AITile.IsStationTile(tile6) || AITile.IsStationTile(tile7) || AITile.IsStationTile(tile8) || AITile.IsStationTile(tile9))
		  {
			  if (AIRoad.BuildDriveThroughRoadStation(tile1, tile2, AIRoad.ROADVEHTYPE_TRUCK, AIStation.STATION_JOIN_ADJACENT)) {
				ExtendStat = tile1;
				break;
			  }
		  }
	  }
	  
    }
    if (ExtendStat > 0) {
       
        break;
    }
  }
	AISign.RemoveSign(sign);
  return ExtendStat;
}

	
function DumbAI::BuildDepot(tile) {
  local xLoc = AIMap.GetTileX(tile);
  local yLoc = AIMap.GetTileY(tile);
  local myDepot = 0;
  
AILog.Info("Build Depot");
  xLoc = xLoc - 1;
  yLoc = yLoc - 1;
  if (xLoc < 0) xLoc = 0;
  if (yLoc < 0) yLoc = 0;

	
  for (local x = 0; x < 8; x++) {
    for (local y = 0; y < 8; y++) {
		
      local tile1 = AIMap.GetTileIndex(xLoc+x, yLoc+y);
      local tile2 = AIMap.GetTileIndex(xLoc+x+1, yLoc+y);
	  local tile3 = AIMap.GetTileIndex(xLoc+x-1, yLoc+y);
	  local tile4 = AIMap.GetTileIndex(xLoc+x+2, yLoc+y);
	  if(AITile.IsBuildable(tile1) && (AITile.GetSlope(tile1) == AITile.SLOPE_FLAT) && (AITile.GetSlope(tile2) == AITile.SLOPE_FLAT))
	  {
		  if((AITile.IsBuildable(tile2) || AIRoad.IsRoadTile(tile2)) && (AITile.IsBuildable(tile4) || AIRoad.IsRoadTile(tile4)))
			{
				if(!AITile.IsStationTile(tile2) && !AITile.IsStationTile(tile3))
				{
					if (AIRoad.BuildRoadDepot(tile1, tile2)) 
						{
						myDepot = tile1;
						break;
						}
					
				}
				
			}
	  }
	  
    }
    if (myDepot > 0) {
       
        break;
    }
  }

  return myDepot;
}

function DumbAI::SetOrders(truck, myMine, myPower)
{
	
	AIOrder.InsertOrder(truck, 0, myMine, (AIOrder.OF_FULL_LOAD_ANY + AIOrder.OF_NON_STOP_INTERMEDIATE ));
	AIOrder.InsertOrder(truck, 1, myPower, (AIOrder.OF_NO_LOAD + AIOrder.OF_UNLOAD + AIOrder.OF_NON_STOP_INTERMEDIATE ));
	done = AIVehicle.StartStopVehicle(truck);
	
	return done;
}

function DumbAI::BuildTruck(depot, cargo) {
  local engines = AIEngineList(AIVehicle.VT_ROAD);

  engines.Valuate(AIEngine.CanRefitCargo, cargo)
  engines.KeepValue(1); 
if((AICargo.GetCargoLabel(cargo) == "STEL" || AICargo.GetCargoLabel(cargo) == "OIL_" || AICargo.GetCargoLabel(cargo) == "WOOD" || AICargo.GetCargoLabel(cargo) == "COAL" || AICargo.GetCargoLabel(cargo) == "IORE") && (globaldist < 40))
{
	engines.Valuate(AIEngine.GetCapacity);
}
else{
	engines.Valuate(AIEngine.GetMaxSpeed);
}
  local engine = engines.Begin();

  local truck = AIVehicle.BuildVehicle(depot, engine);
  AIVehicle.RefitVehicle(truck, cargo);
	myVeh.AddItem(truck, 0);
  return truck;
}
