/*
 * This file is part of RoadAI, which is an AI for OpenTTD
 *
 * RoadAI is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License
 *
 * RoadAI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with RoadAI; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

 class RoadAI extends AIInfo {
	function GetAuthor()      { return "11Runner"; }
	function GetName()        { return "RoadAI"; }
	function GetShortName()   { return "RDAI"; }
	function GetDescription() { return "RoadAI builds a massive, rapidly expanding road network."; }
	function GetAPIVersion()  { return "1.8"; }
	function GetVersion()     { return 5; }
	function GetDate()        { return "2016-10-07"; }
	function GetUrl()         { return "https://www.tt-forums.net/viewtopic.php?p=1176857"; }
	function CreateInstance() { return "RoadAI"; }

	function MinVersionToLoad() { return 1; }

	function GetSettings() {
		AddSetting({name = "log_level", description = "The amount of AI messages to display in the AI log", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, min_value = 1, max_value = 3, flags = AICONFIG_INGAME});
		AddSetting({name = "max_networks", description = "The maximum number of seprate tranport networks RoadAI may build", easy_value = 1, medium_value = 3, hard_value = 5, custom_value = 3, min_value = 1, max_value = 10, flags = AICONFIG_INGAME});
		/*AddSetting({name = "forbid_town_road_grid", description = "Forbid building bus stops and depots on town road grid", easy_value = 1, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});

		AddSetting({name = "use_conditional_orders", description = "Use conditional orders", easy_value = 0, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});
		AddSetting({name = "use_ap_pair_optimizer", description = "Run airport pair optimizer annually (experimental feature)", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});

		AddSetting({name = "debug_signs", description = "Enable building debug signs", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});
		AddSetting({name = "clear_signs", description = "Clear all debug signs (from time to time)", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});
		AddSetting({name = "quit_on_api_check_failure", description = "Quit if OpenTTD API check fails (highly recommended!)", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN});*/
	}

}

/* Tell the core we are an AI */
RegisterAI(RoadAI());
