/* -*- Mode: C++; tab-width: 6 -*- */
/*
 *
 * This file is part of GSToyHelper a gamescript implementing ToyLib
 * Copyright (C) 2014 Krinn <krinn@chez.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


import("Library.GSToyLib", "GSToyLib", 1); // Well, that's the lib we need
import("Library.SCPLib", "SCPLib", 45); // We won't use SCP but we need the library

class GSToyHelper extends GSController
{
	constructor()
	{
	}
}

function GSToyHelper::CheckSetting()
{
	local money = (GSController.GetSetting("GiveMoney") == 1);
	GSToyLib.MoneyHandling(money); // We can disable sending of money if we want, that's the only option of that script.
	money = (GSController.GetSetting("LibOutput") == 1);
	GSToyLib.LibPrintMessage(money); // Enable/disable library log output
}

function GSToyHelper::Start()
{
    local looper = 0;
    local dummy_init = GSToyLib(null);	// We init the lib there, as we don't use SCP, we just init with null parameter
									// If we handle SCP, we could pass it with a local dummy_init = GSToyLib(your_scp_handle);
	GSToyLib.SCPConfigChange(true, false, false); // We can alter SCP config with that function : event, log info, log error. That's just not need but given for example.
    GSLog.Info("This gamescript do nothing, it just gives money to eyes candy AIs script that need money to stay alive and keep going.");
	while (true)
		{
		looper++;
		if ((looper % 100) == 0)	{ GSToyLib.LogStats(); }
		GSToyLib.Check(); // GSToyLib_Check handle for us the SCP Check function for us
		this.Sleep(74);
		this.CheckSetting();
		}
}

function GSToyHelper::Load(version, data)
{
}

function GSToyHelper::Save()
{
}
