enum CatLabels
{
	PAXMAIL = 0,
	G_FOOD = 1,
	G_GOODS = 2,
	RAW_IND = 3,
	TR_IND = 4,
	G_IND = 5
}

/* Cargolist of supported industry set's cargos. Used to check if
 * initial ingame cargo list matches the defined setting. Needs to be
 * updated if industry set cargos change.
 */
function FillCargoIDList() {
	switch (GSController.GetSetting("industry_NewGRF")) {
	/* Baseset */
	case(1): // Temperate
		::CargoIDList <- ["PASS","COAL","MAIL","OIL_","LVST","GOOD",
				  "GRAI","WOOD","IORE","STEL","VALU"];
		break;
	case(2): // Arctic
		::CargoIDList <- ["PASS","COAL","MAIL","OIL_","LVST","GOOD",
				  "WHEA","WOOD",null,"PAPR","GOLD","FOOD"];
		break;
	case(3): // Tropical
		::CargoIDList <- ["PASS","RUBR","MAIL","OIL_","FRUT","GOOD",
				  "MAIZ","WOOD","CORE","WATR","DIAM","FOOD"];
		break;
	case(4): // Toyland
		::CargoIDList <- ["PASS","SUGR","MAIL","TOYS","BATT","SWET",
				  "TOFF","COLA","CTCD","BUBL","PLST","FZDR"];
		break;
	/* FIRS version 3.0.5 */
	case(5): // Firs economy
		::CargoIDList <- ["PASS","BEER","MAIL","RFPR","CLAY","GOOD","COAL","ENSP","FMSP","FISH","FRUT",
              "FOOD","IORE","LVST","MILK","SAND","SCMT","STEL"];
		break;
	case(6): // Temperate basic
		::CargoIDList <- ["PASS","COAL","MAIL",null,"LVST","GOOD",null,null,"IORE","STEL",
				  "MILK","FOOD",null,"FRUT",null,null,"CLAY","SAND","MNSP",null,
				  "SCMT","FMSP",null,"RFPR","ENSP",null,null,null,null,"BEER"];
		break;
	case(7): // Arctic basic
		::CargoIDList <- ["PASS",null,"MAIL","OIL_","LVST","GOOD","GRAI","WOOD",null,null,
				  null,"FOOD",null,null,"FISH",null,"CLAY",null,"MNSP",null,
				  null,"FMSP",null,"RFPR","ENSP","PETR",null,null,null,"BEER"];
		break;
	case(8): // Tropic basic
		::CargoIDList <- ["PASS",null,"MAIL","OIL_","LVST","GOOD",null,null,null,"STEL",
				  null,"FOOD","SGCN","FRUT","FISH","WOOL",null,null,"MNSP",null,
				  null,"FMSP",null,"RFPR","ENSP","PETR",null,"AORE"];
		break;
	case(9): // Hearth of Darkness
		::CargoIDList <- ["PASS","DIAM","MAIL","OIL_",null,"GOOD","GRAI","WOOD","CORE",null,
				  null,"FOOD","SGCN","FRUT","FISH","JAVA",null,null,"MNSP",null,
				  "SUGR","FMSP","FICR",null,"ENSP",null,null,"RUBR","BDMT","BEER"];
		break;
	/* ECS - Included vectors:
	 * ECS Town vector 1.1.2 (R144)
	 * ECS Houses 1.1.2 (R138)
	 * ECS Basic vector II 1.1.2 (R424)
	 * ECS Chemicals vector II 1.1.2 (R194)
	 * ECS Machinery Vector 1.1.2 (R55)
	 * ECS Wood vector 1.1.2 (R214)
	 * ECS Agricultural vector 1.1.2 (R660)
	 */
	case(10):
		::CargoIDList <- ["PASS","COAL","MAIL","OIL_","LVST","GOOD","CERE","WOOD","IORE","STEL",
				  "GOLD","FOOD","PAPR","FRUT","FISH","WOOL",null,"SAND","GLAS","WDPR",
				  "DYES","FERT","OLSD","RFPR","VEHI","PETR",null,"WATR",null,"FICR",
				  null,"TOUR"];
		break;
	/* YETI (v5350) */
	case(11):
		::CargoIDList <- [null,"GRVL",null,"WOOD","BDMT",null,"GRAI","FRUT","FOOD",null,
				  "OIL_",null,"STEL","RFPR","BATT","VEHI","YETI","CLAY","LVST","URAN",
				  "IORE"];
		break;
	default: break;
	}

	// This is used to add all null IDs after the end of active used cargos
	local missing_cargo = 32 - ::CargoIDList.len();
	for (local i = 0; i < missing_cargo; i++) {
		for (local i = 0; i < missing_cargo; i++) ::CargoIDList.append(null);
	}
}

/* Here are defined the cargo categories and other data for each
 * set. Follow explanations below to change category data.
 */
function DefineCargosBySettings()
{
	/* Setup global cargo variables, per cargo categories: (Cat 1:
	 * Passengers and mail, Cat 2: General food, Cat 3: General
	 * goods, Cat 4: Raw industrial materials, Cat 5: transformed
	 * indudstrial goods). For base sets, only 3 categories are
	 * defined (PaxMail, General goods (including food),
	 * industrial goods).
	 *
	 * For each industry set, we define:
	 * ::CargoCat: the base categories of cargo. For each
	 * category, an array of cargo types is created. For cargo Id
	 * references, enable debugging and watch at the AI/GameScript
	 * log.
	 * ::CargoCatList: a list of used cargo categories; see enum
	 * CargoCategories
	 * ::CargoMinPopDemand: minimal town population at which a
	 * cargo category is required
	 * ::CargoPermille: a factor defining the growth of cargo category
	 * requirements
	 * ::CargoDecay: defines the part of the stockpiled cargos
	 * which is lost each month
	 */
	local industry_setting = GSController.GetSetting("industry_NewGRF");
	switch (industry_setting) {
		case(1): // Base temperate
			::CargoCat <- [[0,2],
				       [5,10],
				       [1,3,4,6,7,8,9]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_GOODS,CatLabels.G_IND];
			::CargoMinPopDemand <- [0,1000,4000];
			::CargoPermille <- [60,45,25];
			::CargoDecay <- [0.4,0.2,0.1];
			break;
		case(2): //Base arctic
			::CargoCat <- [[0,2],
				       [5,10,11],
				       [1,3,4,6,7,9]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_GOODS,CatLabels.G_IND];
			::CargoMinPopDemand <- [0,1000,4000];
			::CargoPermille <- [60,45,25];
			::CargoDecay <- [0.4,0.2,0.1];
			break;
		case(3): //Base tropical
			::CargoCat <- [[0,2],
				       [5,9,10,11],
				       [1,3,4,6,7,8]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_GOODS,CatLabels.G_IND];
			::CargoMinPopDemand <- [0,1000,4000];
			::CargoPermille <- [60,45,25];
			::CargoDecay <- [0.4,0.2,0.1];
			break;
		case(4): //Base toyland
			::CargoCat <- [[0,2],
				       [3,5,11],
				       [1,4,6,7,8,9,10]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_GOODS,CatLabels.G_IND];
			::CargoMinPopDemand <- [0,1000,4000];
			::CargoPermille <- [60,45,25];
			::CargoDecay <- [0.4,0.2,0.1];
			break;
		case(5): // FIRS - Firs Economy
			::CargoCat <- [[0,2],
						[1,10,11],
						[5],
						[4,6,9,12,13,17,14,15],
						[3,7,8,16]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_FOOD,CatLabels.G_GOODS,
					   CatLabels.RAW_IND,CatLabels.TR_IND];
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			break;
		case(6): // FIRS - Temperate Basic
			::CargoCat <- [[0,2],
				       [11,29],
				       [5],
				       [1,4,8,10,13,16,17,20],
				       [9,18,21,23,24]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_FOOD,CatLabels.G_GOODS,
					   CatLabels.RAW_IND,CatLabels.TR_IND];
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			break;
		case(7): // FIRS - Arctic Basic
			::CargoCat <- [[0,2],
				       [11,29],
				       [5,25],
				       [3,4,6,7,14],
				       [16,18,21,23,24]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_FOOD,CatLabels.G_GOODS,
					   CatLabels.RAW_IND,CatLabels.TR_IND];
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			break;
		case(8): // FIRS - Tropic Basic
			::CargoCat <- [[0,2],
				       [11],
				       [5,25],
				       [3,4,12,13,14,15,27],
				       [9,18,21,23,24]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_FOOD,CatLabels.G_GOODS,
					   CatLabels.RAW_IND,CatLabels.TR_IND];
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			break;
		case(9): // FIRS - Hearth of the Darkness
			::CargoCat <- [[0,2],
				       [11,29],
				       [5,28],
				       [1,3,7,8,12,13,14,15,22,27],
				       [6,18,20,21,24]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_FOOD,CatLabels.G_GOODS,
					   CatLabels.RAW_IND,CatLabels.TR_IND];
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			break;
		case(10): //ECS
			::CargoCat <- [[0,2,31],
				       [11,27],
				       [5,10,25],
				       [1,3,4,6,7,8,13,14,15,17,29],
				       [9,12,18,19,20,21,22,23,24]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_FOOD,CatLabels.G_GOODS,
					   CatLabels.RAW_IND,CatLabels.TR_IND];
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			break;
		case(11): //YETI (v5350)
			::CargoCat <- [[16],
				       [8],
				       [4],
				       [1,3,6,7,10,17,18,19,20],
				       [12,13,14,15]];
			::CargoCatList <- [CatLabels.PAXMAIL,CatLabels.G_FOOD,CatLabels.G_GOODS,
					   CatLabels.RAW_IND,CatLabels.TR_IND];
			::CargoMinPopDemand <- [0,500,1000,4000,8000];
			::CargoPermille <- [60,25,20,15,10];
			::CargoDecay <- [0.4,0.2,0.2,0.1,0.1];
			break;
		default:
			break;
	}

	ConfigureCategories();
}

/* Merge categories if required by settings. */
function ConfigureCategories()
{
	local merge_2_3 = GSController.GetSetting("merge_cat_2_3");
	local merge_4_5 = GSController.GetSetting("merge_cat_4_5");
	local first_idx = null;

	if (merge_2_3) {
		first_idx = 1;
		::CargoCat[first_idx].extend(::CargoCat[first_idx+1]);
		::CargoCat[first_idx].sort();
		::CargoCat.remove(first_idx+1);
		::CargoCatList.remove(first_idx);
		::CargoPermille[first_idx] += ::CargoPermille[first_idx+1];
		::CargoPermille.remove(first_idx+1);
		::CargoMinPopDemand.remove(first_idx+1);
		::CargoDecay.remove(first_idx+1);
	}
	if (merge_4_5) {
		merge_2_3 ? first_idx = 2 : first_idx = 3;
		::CargoCat[first_idx].extend(::CargoCat[first_idx+1]);
		::CargoCat[first_idx].sort();
		::CargoCat.remove(first_idx+1);
		::CargoCatList.remove(first_idx);
		::CargoCatList[first_idx] = CatLabels.G_IND;
		::CargoPermille[first_idx] += ::CargoPermille[first_idx+1];
		::CargoPermille.remove(first_idx+1);
		::CargoMinPopDemand.remove(first_idx+1);
		::CargoDecay.remove(first_idx+1);
	}
}

/* This function compares the ingame initial cargo list to the
 * industry sets and cargoscheme supported by the script. Return false
 * if they don't match.
 */
function CheckInitialCargoList() {
	local cargo_list = [];
	for(local i = 0; i < 32; ++i) {
		cargo_list.append(GSCargo.GetCargoLabel(i));
	}
	FillCargoIDList();

	// Comparing actual list to original list
	for (local i = 0; i < 32; i++) {
		if (cargo_list[i] != ::CargoIDList[i]) {
			::CargoIDList = false;
			Log.Info("Warning: game's cargo list differ from settings.", Log.LVL_INFO);
			return;
		}
	}
}

/* Initialization of cargo data. */
function InitCargoLists()
{
	DebugCargoLabels();       // Debug info: print cargo labels

	CheckInitialCargoList()   // Check if cargo list matches the settings

	DefineCargosBySettings(); // Define cargo data accordingly to industry set

	// Building a general list of all cargos, ordered by categories.
	::CargoList <- [];
	for (local i = 0; i < ::CargoCat.len(); i++) {
		for (local j = 0; j < ::CargoCat[i].len(); j++) {
			::CargoList.append(CargoCat[i][j]);
		}
	}

	// Initializing some useful and often used variables
	::CargoTypeNum <- ::CargoList.len();
	::CargoCatNum <- ::CargoCat.len();
}
