/* Function which builds town texts.
 * Town text will look like below:
 * Cargocat label: required/last supplied/stockpiled
 */
function GoalTown::TownBoxText(growth_enabled)
{
	// If the function is called with false, town is not growing. Give a help message.
	if (!growth_enabled) return GSText(GSText.STR_TOWNBOX_NOGROWTH, 1 << ::CargoCat[0][0]);

	// Building an array of substrings. Labels depend on categories number.
	local text_townbox_cargocat = [];
	local max_cat = 0;

	while (max_cat < (::CargoCatNum-1)) {
		if (this.town_goals_cat[max_cat+1] == 0) break;
		max_cat++;
	}

	for (local i = 0; i <= max_cat; i++) {
		text_townbox_cargocat.append(GSText(GSText["STR_TOWNBOX_CAT_"+::CargoCatList[i]]));
	}

	// Adding numeric parameters and building the final string
	local text_townbox = GSText(GSText["STR_TOWNBOX_"+max_cat]);
	for (local i = 0; i <= max_cat; i++) {
		text_townbox_cargocat[i].AddParam(this.town_goals_cat[i]);
		text_townbox_cargocat[i].AddParam(this.town_supplied_cat[i]);
		text_townbox_cargocat[i].AddParam(this.town_stockpiled_cat[i]);
		text_townbox.AddParam(text_townbox_cargocat[i]);
	}

	return text_townbox;
}

/* Building the text for towns' signtexts. */
function GoalTown::TownSignText()
{
	local text_townsign = GSText(GSText.STR_TOWNSIGN_GROWTHRATE, GSTown.GetGrowthRate(this.id));
	return text_townsign;
}

/* Helper function: get a list of currently used cargo labels/ID. */
function DebugCargoLabels()
{
	local list = GSCargoList();
	for(local i = 0; i < 32; ++i) {
		Log.Info(i + " = " + GSCargo.GetCargoLabel(i), Log.LVL_DEBUG);
	}
}

/* Debug function: print supplied cargo. */
function GoalTown::DebugCargoSupplied(i)
{
	Log.Info(GSTown.GetName(this.id)+": supplied "+GSCargo.GetCargoLabel(CargoList[i])+"="
		 +town_supplied[i], Log.LVL_DEBUG);
}

/* Debug function: print stockpiled/supplied/goal per cargo category. */
function GoalTown::DebugCargoCatInfo(i)
{
	Log.Info(GSTown.GetName(this.id)+": Cat. "+(i+1)
		 +" - Goal="+this.town_goals_cat[i]
		 +" Supplied="+this.town_supplied_cat[i]
		 +" Stockpiled="+this.town_stockpiled_cat[i], Log.LVL_DEBUG);
}

/* Debug function: print the general goals achievement before calculating the new TGR. */
function GoalTown::DebugGoalsResult(sum_goals, goal_diff, goal_diff_percent)
{
	Log.Info(GSTown.GetName(this.id)+": sum_goals="+sum_goals+" goal_diff="+goal_diff+" goal_diff_percent="
		 +goal_diff_percent, Log.LVL_DEBUG);
}

/* Debug function: print the content of the TGR array. */
function GoalTown::DebugTgrArray()
{
	local array_text = " ";
	foreach (i, val in this.tgr_array) {
		array_text = array_text+"i"+i+"="+val+" ";
	}
	Log.Info(GSTown.GetName(this.id)+": "+array_text+"Average="+this.tgr_average, Log.LVL_DEBUG);
}
