/*
 * This file is part of NoCarGoal, which is a GameScript for OpenTTD
 * Copyright (C) 2012  Leif Linse
 *
 * NoCarGoal is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * NoCarGoal is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NoCarGoal; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

require("version.nut");


class FMainClass extends GSInfo {
	function GetAuthor()		{ return "Zuu"; }
	function GetName()			{ return "NoCarGoal"; }
	function GetDescription() 	{ return "Goal: Transport at least X units of cargo A, B and C by the end of year YYYY. 1 cargo = Bronze, 2 cargoes = Silver, 3 cargoes = Gold"; }
	function GetVersion()		{ return SELF_VERSION; }
	function GetDate()			{ return "2013-07-21"; }
	function CreateInstance()	{ return "MainClass"; }
	// WARNING: the short name is also declared in version.nut
	function GetShortName()		{ return "CAGO"; }
	function GetAPIVersion()	{ return "1.3"; }
	function GetURL()			{ return "http://www.tt-forums.net/viewtopic.php?f=65&t=62212"; }
	function MinVersionToLoad() { return 9; }

	function GetSettings() {
		AddSetting({name = "transport_target", 
				description = "Target transport amount (per cargo)", 
				easy_value = 7500, 
				medium_value = 12500, 
				hard_value = 25000, 
				custom_value = 12500, 
				flags = 0, min_value = 1, max_value = 1000000000});

		AddSetting({name = "play_years", 
				description = "How many game years should the challenge cover?", 
				easy_value = 7, 
				medium_value = 7, 
				hard_value = 7, 
				custom_value = 7, 
				flags = 0, min_value = 1, max_value = 10000});

		AddSetting({name = "monthly_progress", 
				description = "Frequency of progress reports (news messages)", 
				easy_value = 1, 
				medium_value = 1, 
				hard_value = 1, 
				custom_value = 1, 
				flags = CONFIG_INGAME, min_value = 0, max_value = 2});
		AddLabels("monthly_progress", {_0 = "every year (January)", _1 = "every month", _2 = "off" } );

		AddSetting({name = "scp_enabled", 
				description = "AI-GS communication (support for NoCarGoal)", 
				easy_value = 1, 
				medium_value = 1, 
				hard_value = 1, 
				custom_value = 1, 
				flags = CONFIG_BOOLEAN});

		AddSetting({name = "pause_at_game_end", 
				description = "Pause game when time is up", 
				easy_value = 1, 
				medium_value = 1, 
				hard_value = 1, 
				custom_value = 1, 
				flags = CONFIG_BOOLEAN | CONFIG_INGAME});

		AddSetting({name = "log_level", description = "Debug: Log level (higher = print more)", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = CONFIG_INGAME, min_value = 1, max_value = 3});
		AddLabels("log_level", {_1 = "1: Info", _2 = "2: Verbose", _3 = "3: Debug" } );
	}
}

RegisterGS(FMainClass());
