class GSToyHelper extends GSInfo
{
	function GetAuthor()		{ return "James+McZapkie"; }
	function GetName()			{ return "Think globally, act locally"; }
	function GetDescription() 	{ return "This controls both town and industry growth by requiring other industries and towns to be served. See readme.txt for more info."; }
	function GetVersion()		{ return 14; }
	function GetDate()			{ return "2017-11-22"; }
	function CreateInstance()	{ return "GSToyHelper"; }
	function GetShortName()		{ return "TGAL"; }
	function GetAPIVersion()	{ return "1.4"; }
	function MinVersionToLoad()	{ return 14; }

	function GetSettings()
	{
		AddSetting({name = "passmail",
		description = "Passengers+mail transport percentange required",
		min_value = 0
		max_value = 100
		easy_value = 20,
		medium_value = 40,
		hard_value = 80,
		custom_value = 30,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "consumer",
		description = "Consumer goods percentange delivery required",
		min_value = 0
		max_value = 100
		easy_value = 10,
		medium_value = 10,
		hard_value = 20,
		custom_value = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "industrial",
		description = "Industry resources percentange delivery required",
		min_value = 0
		max_value = 100
		easy_value = 5,
		medium_value = 10,
		hard_value = 20,
		custom_value = 10
		flags = CONFIG_INGAME
		});
	
		AddSetting({name = "minprct",
		description = "Percent of industries required to be served",
		min_value = 0
		max_value = 99
		easy_value = 15,
		medium_value = 35,
		hard_value = 55,
		custom_value = 50,
		step_size = 5,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "mintrans",
		description = "Percent of cargo to transport from an industry",
		min_value = 0
		max_value = 99
		easy_value = 25,
		medium_value = 50,
		hard_value = 75,
		custom_value = 50,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "economypoints",
		description = "Points threshold needed to change global economy mood",
		min_value = 0
		max_value = 99
		easy_value = 25,
		medium_value = 50,
		hard_value = 75,
		custom_value = 50,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "goodeconomy",
		description = "Economy index threshold indicating global wealth",
		min_value = 5
		max_value = 50
		easy_value = 5,
		medium_value = 10,
		hard_value = 20,
		custom_value = 10,
		step_size = 5,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "keepind",
		description = "Industry: Try to keep the number of industries on map",
		easy_value = 0,
		medium_value = 0,
		hard_value = 0,
		custom_value = 0,
		flags = CONFIG_INGAME|CONFIG_BOOLEAN
		});

		AddSetting({name = "refreshrate",
		description = "Script refresh rate (days)",
		min_value = 7
		max_value = 56
		easy_value = 7,
		medium_value = 14,
		hard_value = 28,
		custom_value = 7,
		step_size = 7,
		flags = CONFIG_NONE
		});

		AddSetting({name = "smoothgrowth",
		description = "Average weight (higher make town growth more smoothly depend on delivery amounts)",
		min_value = 0
		max_value = 5
		easy_value = 1,
		medium_value = 2,
		hard_value = 3,
		custom_value = 1,
		step_size = 1,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "nosubsidies",
		description = "Do not generate passengers subsidies for served towns",
		easy_value = 0,
		medium_value = 0,
		hard_value = 0,
		custom_value = 0,
		flags = CONFIG_INGAME|CONFIG_BOOLEAN
		});

	}

}

RegisterGS(GSToyHelper());
