require("town.nut");

class GSToyHelper extends GSController
{
	towns = null;
	constructor() {
		this.towns = null;
		::TownDataTable <- {};
	}

	firsttime_start = true
	system = 0
	x = 0
	y = 0

	town = 0
	towns_served = 0
	pass_amt = 0
	cg_amt = 0
	ig_amt = 0
//mail_mult = 0

	industry = 0
	industry_count = 0
	industries_served = 0
	ind_density = 0
	industry_pts = 0
	min_industry_pts = 0
	cargo = 0

	min_ind_served = 0
	min_ind_transport = 0

//MC addon:
	economy_mood = 0
	economy_points = 0
	global_town_count = 0
	gamestart_year = 0
	game_duration = 0
	industry_goal_reached = 0
	weight_average = 0
	week_count = 0;
	average_pop = 0;
	refreshrate = 7;
	story = [];
	storyElement = []; 
	function StoryStart();
//function Story();


}

function GSToyHelper::StoryStart(){
	this.story.append(GSStoryPage.New(GSCompany.COMPANY_INVALID, GSText(GSText.STR_STORY_TITLE, 10))); 
	GSStoryPage.NewElement(this.story[0], GSStoryPage.SPET_TEXT, 0, GSText(GSText.STR_STORY_BOOK));

}


function GSToyHelper::CheckIndustries() {
	// A is the first system
	min_ind_served = GetSetting("minprct")
	min_ind_transport = GetSetting("mintrans")
	industry_count = 0;
	local cargo_transported = 0;
	local c = 0;
	y = 0
	local list = GSIndustryList()
	industries_served = 0;
	for (local v = list.Begin (); !list.IsEnd (); v = 	list.Next ()) {
		y++
		industry_count ++;
		local ind_type = GSIndustry.GetIndustryType(v)
		local produced_cargoes = GSIndustryType.GetProducedCargo(ind_type)
		local num_cargoes = produced_cargoes.Count()
		local transport_percent = 0
		foreach (c, _ in produced_cargoes) {
			transport_percent += GSIndustry.GetLastMonthTransportedPercentage(v,c)
		}
		if (GSIndustryType.GetProducedCargo(ind_type).Count() == 0) {
			if (GSIndustry.GetAmountOfStationsAround(v)>0) {
				industries_served ++
			}
		} else if (num_cargoes == 0) {
			industry_count --
		} else if (transport_percent/num_cargoes>min_ind_transport){
			industries_served ++
		} 
	}

	industries_served *= 1;
	if (industries_served*100/industry_count + economy_mood-GetSetting("goodeconomy") >= min_ind_served) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_MET, industries_served, industry_count))
		industry_goal_reached = 1
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_NMET, industries_served, industry_count))
		industry_goal_reached = 0
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, max(0, industries_served*100/industry_count + economy_mood-GetSetting("goodeconomy"))))
}

function GSToyHelper::CheckIndustriesB() {
	// B is the second system
	industry_count = GSIndustry.GetIndustryCount()
	industry_pts = 0

	local c = 0
	
	local list = GSIndustryList()

	for (local v = list.Begin (); !list.IsEnd (); v = 	list.Next ()) {
		industry = v;
		industry_count ++;
		GSLog.Info(industry_count)
		local ind_type = GSIndustry.GetIndustryType(v)
		local produced_cargoes = GSIndustryType.GetProducedCargo(ind_type)
		local num_cargoes = produced_cargoes.Count()
		if (num_cargoes == 0) {
			industry_count --
		} else {
			foreach (c, _ in produced_cargoes) {
				industry_pts += GSIndustry.GetLastMonthTransportedPercentage(v,c)/num_cargoes
			}
		}
	}
	if (industry_pts/industry_count >= min_industry_pts) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_MET, industry_pts, industry_count*min_industry_pts))
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_NMET, industry_pts, industry_count*min_industry_pts))
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industry_pts/industry_count))

}

function GSToyHelper::CheckIndustryClose() {
	local event = null
	local eventtype = null
	local event2 = null
	if (economy_mood>0) {
		while (GSEventController.IsEventWaiting()) {
			event = GSEventController.GetNextEvent()
			eventtype = event.GetEventType()
			switch (eventtype) {
				case GSEvent.ET_INDUSTRY_CLOSE: 
					event = GSEventIndustryClose.Convert(event)
					local industry = event.GetIndustryID()
					if (!GSIndustry.IsValidIndustry(industry)) break;			
				
					local indtype = GSIndustry.GetIndustryType(industry)
					GSIndustryType.ProspectIndustry(indtype)
			}
		}
	}
}

function GSToyHelper::CreateTownList()
{
	local towns_list = GSTownList();
	local towns_array = [];

	foreach (t, _ in towns_list) {
		towns_array.append(TownManagement(t,false));
	}
	return towns_array;
}

function GSToyHelper::UpdateTownList(town_id)
{
	this.towns.append(TownManagement(town_id, false));
}

function GSToyHelper::HandleEvents()
{
	while (GSEventController.IsEventWaiting()) {
		local event = GSEventController.GetNextEvent();
		switch (event.GetEventType()) {
		case GSEvent.ET_TOWN_FOUNDED:
			event = GSEventTownFounded.Convert(event);
			local town_id = event.GetTownID();
			if (GSTown.IsValidTown(town_id)) this.UpdateTownList(town_id);
			break;
		default: break;
		}
	}
}

function GSToyHelper::ManageTowns() {
	foreach (t in this.towns) {
			TownManagement.CheckTownPASS(t);
		}
}


function GSToyHelper::Start() {

	// Create the towns list
	this.towns = this.CreateTownList();

	::TownDataTable = null;

	refreshrate = GetSetting("refreshrate");
	GSLog.Info("Listing cargoes...")
	for (local x = 0; x < 32; x++) {
		GSLog.Info(x+": "+GSCargo.GetCargoLabel(x))
	}
	GSLog.Info("Initializing goals...")
	if (true) {
		for (local i = 0; i < 10; i++) {GSGoal.Remove(i)}
		GSGoal.New(-1, "System ? - Initializing",0,0);
		GSGoal.New(-1, "Towns served: ? / ?",0,0);
		GSGoal.New(-1, "Time elapsed: ? Economy mood: ? ",0,0);
		this.StoryStart();
	}
	GSLog.Info("Initializing game start year...")
	this.gamestart_year = GSDate.GetYear(GSDate.GetCurrentDate());

	GSLog.Info("Initializing...")
	ind_density = GSGameSettings.GetValue("difficulty.industry_density")
	industry_count = GSIndustry.GetIndustryCount()
     firsttime_start = false
	while (true) {
		this.HandleEvents();	
		if (!GSGame.IsPaused()) {
			x++
			towns_served = 0
			global_town_count = GSTown.GetTownCount();
			if (week_count == 0) {
				average_pop = 0;
				for (town = 0; town < global_town_count; town += 1) {
					average_pop += GSTown.GetPopulation(town);
				}	
				average_pop /= global_town_count;		
			}
			this.ManageTowns();
			GSGoal.SetText(1, GSText(GSText.STR_TOWN_GOAL, towns_served, global_town_count))
			GSGoal.SetProgress(1, GSText(GSText.STR_PROGRESS2, towns_served*100/global_town_count))

			if (industry_count) {
				GSToyHelper.CheckIndustries()
			} else {
				GSGoal.SetText(0, "No industry control is taking place")
			}
			economy_points = GetSetting("economypoints");
			game_duration = max(0, GSDate.GetYear(GSDate.GetCurrentDate()) - gamestart_year);
			economy_mood = (1 + economy_mood + (50 * towns_served / global_town_count) + (50 * industries_served / (1 + GSIndustry.GetIndustryCount())) - economy_points * (20 - 20/(1+game_duration/10))/(industry_goal_reached + 20)) / 2;
			if (economy_mood>GetSetting("goodeconomy")) {
              GSGoal.SetText(2, GSText(GSText.STR_GOOD_ECONOMY_GOAL_REACHED, game_duration, economy_mood))
			} else if (economy_mood>=0) {		
              		GSGoal.SetText(2, GSText(GSText.STR_AVERAGE_ECONOMY_GOAL_REACHED, game_duration, economy_mood))	
	            } else {
	            	   GSGoal.SetText(2, GSText(GSText.STR_ECONOMY_WEAK, game_duration, economy_mood))
			}
			if (GetSetting("keepind")) {
			GSToyHelper.CheckIndustryClose()
			}
			week_count ++
			if (week_count>4) {
				week_count = 0;
		 	}
		}
		this.Sleep(74 * refreshrate) // sleep for a week (default) at a time
	}	
	GSLog.Info("Ready")
}

function GSToyHelper::Load(version, saved_data)
{
//	Log.Info("Loading data...", Log.LVL_INFO);
	firsttime_start = false;
	foreach (townid, town_data in saved_data.town_data_table) {
		::TownDataTable[townid] <- town_data;
	}
	this.gamestart_year = saved_data.gamestart_year;
}

function GSToyHelper::Save() {
	local save_table = {};
	save_table.town_data_table <- {};
	if (firsttime_start) {
		save_table.town_data_table <- ::TownDataTable;
	} else {
		foreach (i, town in this.towns)
			{
				save_table.town_data_table[town.id] <- town.SavingTownData();
			}
	}
	save_table.gamestart_year <- this.gamestart_year;
	return save_table;
}

//percentage to amount

function GSToyHelper::p_cg2a(p, pop) {
	return p*(10000+pop)/10000
}

function GSToyHelper::p_ig2a(p, pop) {
	return p*(20000+pop)/20000
}

//amount to percentage
function GSToyHelper::a_cg2p(a, pop) {
	return 10000 * a/(10000+pop);
}

function GSToyHelper::a_ig2p(a, pop) {
	return 20000 * a/(20000+pop);
}

