class TownManagement
{
	id = null;                  
	sign_id = null;                   
	town_stockpiled_raw = null; 
	town_stockpiled_ind = null; 


	constructor(town_id, load_town_data) {
		this.id = town_id;
		/* If there isn't saved data for the towns, we
		 * initialize them. Otherwise, we load saved data.
		 */
		if (!load_town_data) {
			this.sign_id = -1;
			town_stockpiled_raw = 0;
			town_stockpiled_ind = 0;
			GSTown.SetGrowthRate(this.id, GSTown.TOWN_GROWTH_NORMAL);
//			GSTown.SetText(this.id, TownBoxText(false));
		} else {
			this.sign_id = ::TownDataTable[this.id].sign_id;
			this.town_stockpiled_raw = ::TownDataTable[this.id].town_stockpiled_raw;
			this.town_stockpiled_ind = ::TownDataTable[this.id].town_stockpiled_ind;
		}
	}
}

function TownManagement::CheckDeliveredCargo(t_id, lab1) {
	local cargo_transported = 0
	foreach(cargo,_ in GSCargoList())
		{
			if (GSCargo.GetCargoLabel(cargo) == lab1) {
				for(local company_id = GSCompany.COMPANY_FIRST; company_id < GSCompany.COMPANY_LAST; company_id++)
				{
					cargo_transported +=  max(0,GSCargoMonitor.GetTownDeliveryAmount(company_id, cargo, t_id, true));
				} 
			}
		}
	return cargo_transported;
}

function TownManagement::CountConsumerGoods(t_id) {
	local total_cargo = 0;
	total_cargo = 	 TownManagement.CheckDeliveredCargo(t_id, "FOOD") 
				+TownManagement.CheckDeliveredCargo(t_id, "GOOD")
				+TownManagement.CheckDeliveredCargo(t_id, "BEER")
				+TownManagement.CheckDeliveredCargo(t_id, "WATR")
				+TownManagement.CheckDeliveredCargo(t_id, "PETR")
				+TownManagement.CheckDeliveredCargo(t_id, "BDMT")
        			+TownManagement.CheckDeliveredCargo(t_id, "BRCK")
				+TownManagement.CheckDeliveredCargo(t_id, "GOLD")
				+TownManagement.CheckDeliveredCargo(t_id, "VALU")
				+TownManagement.CheckDeliveredCargo(t_id, "SUGR")
				+TownManagement.CheckDeliveredCargo(t_id, "DIAM");
GSLog.Info(total_cargo);
	return total_cargo;
}

function TownManagement::CountIndustryGoods(town) {
	local total_cargo = 0;
	total_cargo = 	 	 
				TownManagement.CheckDeliveredCargo(town, "ENSP")
				+TownManagement.CheckDeliveredCargo(town, "MNSP")
				+TownManagement.CheckDeliveredCargo(town, "FMSP")
				+TownManagement.CheckDeliveredCargo(town, "VEHI")
				+TownManagement.CheckDeliveredCargo(town, "PAPR")
				+TownManagement.CheckDeliveredCargo(town, "STEL")
				+TownManagement.CheckDeliveredCargo(town, "METL")
				+TownManagement.CheckDeliveredCargo(town, "COPR")
				+TownManagement.CheckDeliveredCargo(town, "RFPR")
				+TownManagement.CheckDeliveredCargo(town, "COKE")
				+TownManagement.CheckDeliveredCargo(town, "ACID")
				+TownManagement.CheckDeliveredCargo(town, "QLME")
				+TownManagement.CheckDeliveredCargo(town, "POWR")
				+TownManagement.CheckDeliveredCargo(town, "PIPE")
				+TownManagement.CheckDeliveredCargo(town, "YETI");
	return total_cargo;
}

function TownManagement::CountEnergyGoods(town) {
	local total_cargo = 0;
	total_cargo = 	 	 TownManagement.CheckDeliveredCargo(town, "COAL") 
				+TownManagement.CheckDeliveredCargo(town, "OIL_")
				+TownManagement.CheckDeliveredCargo(town, "PEAT")
				+TownManagement.CheckDeliveredCargo(town, "WOOD")
				+TownManagement.CheckDeliveredCargo(town, "BATT")
				+TownManagement.CheckDeliveredCargo(town, "URAN")
				+TownManagement.CheckDeliveredCargo(town, "GRAI")
				+TownManagement.CheckDeliveredCargo(town, "CERE")
				+TownManagement.CheckDeliveredCargo(town, "WHEA")
				+TownManagement.CheckDeliveredCargo(town, "MAIZ")
				+TownManagement.CheckDeliveredCargo(town, "LVST")
				+TownManagement.CheckDeliveredCargo(town, "FISH")
				+TownManagement.CheckDeliveredCargo(town, "BEAN")
				+TownManagement.CheckDeliveredCargo(town, "CASS")
				+TownManagement.CheckDeliveredCargo(town, "JAVA")
				+TownManagement.CheckDeliveredCargo(town, "SGBT")
				+TownManagement.CheckDeliveredCargo(town, "FRUT");
	return total_cargo;
}

function TownManagement::CheckSubsidies(Town1, Town2) {
	local subsidygenerated = false;
	local sublist = GSSubsidyList()
	for (local s = sublist.Begin (); !sublist.IsEnd (); s = sublist.Next ()) {
		if (GSSubsidy.GetSourceType(s)==GSSubsidy.SPT_TOWN) {
			if ((GSSubsidy.GetSourceIndex(s)==Town1) || (GSSubsidy.GetSourceIndex(s)==Town2)) {
				subsidygenerated = true;
			}
		}
	}
	return subsidygenerated;
}


function TownManagement::CheckTownPASS(_town) {
	local TownId = _town.id;
	local growth_speed = max(20, 50 + 4 * economy_mood);
	local town_population = GSTown.GetPopulation(TownId);
	local town_growth_mode = 0;
	local town_growth_speed = GSTown.TOWN_GROWTH_NORMAL;
	local town_expansion = 0;
	local previous_growth = GSTown.GetGrowthRate(TownId);		 
	local pass_transport = GSTown.GetLastMonthTransportedPercentage(TownId, 0)+GSTown.GetLastMonthTransportedPercentage(TownId, 2);
	pass_transport += 100 * TownManagement.CheckDeliveredCargo(TownId, "TOUR")/(5000+town_population);
	local cg_transport = 0;
	local en_transport = 0;
	local cg_percent = 0;
	local en_percent = 0;
	local ig_transport = 0;
	local ig_percent = 0;
	local capital_city = 0;
	if (GSTown.IsCity(TownId))
		capital_city = 1;
	pass_amt = GetSetting("passmail");
	cg_amt = GetSetting("consumer");
	ig_amt = GetSetting("industrial");
	weight_average = GetSetting("smoothgrowth");
	local en_storage = _town.town_stockpiled_raw;
	local ig_storage = _town.town_stockpiled_ind;

	if (pass_transport>=pass_amt) {
		towns_served ++
		if (!GetSetting("nosubsidies")) {
		   if  ((week_count == 1) && (GSBase.RandRange(365) < refreshrate*(economy_points+economy_mood))) {
		      local Town2 = GSBase.RandRange(global_town_count);
		      local dist2 = GSTown.GetDistanceManhattanToTile(TownId, GSTown.GetLocation(Town2));
		      if ((Town2 != TownId) && (dist2>25) && (GSBase.RandRange(GSMap.GetMapSizeX()+GSMap.GetMapSizeY()) /2 > dist2) && (GSTown.GetPopulation(TownId) > average_pop / 2)) {
				if (!TownManagement.CheckSubsidies(TownId, Town2)) {
					GSSubsidy.Create(0, GSSubsidy.SPT_TOWN, TownId, GSSubsidy.SPT_TOWN, Town2);
				}
			}
		  }
		  if ((week_count == 2) && (GSBase.RandRange(365) < refreshrate*economy_mood) && (town_population > average_pop / 3)) {
		        local Town2 = GSBase.RandRange(global_town_count);
		        local dist2 = GSTown.GetDistanceManhattanToTile(TownId, GSTown.GetLocation(Town2));
		      if ((Town2 != TownId) && (dist2>50) && ((GSMap.GetMapSizeX()+GSMap.GetMapSizeY()) / 4> dist2) && (GSTown.GetPopulation(TownId) > average_pop / 2)) {
				if (!TownManagement.CheckSubsidies(TownId, Town2)) {
					GSSubsidy.Create(2, GSSubsidy.SPT_TOWN, TownId, GSSubsidy.SPT_TOWN, Town2);
				}
			}
		  }

		}
	}

	if (town_population <= 25) {
 //regrowth
  		town_growth_mode = -2;
 	        town_growth_speed = 50+town_population;
	} else if (town_population <= 250)  {
 //normal growth
  		town_growth_mode = -1;
		town_growth_speed = GSTown.TOWN_GROWTH_NORMAL;
	} else if (town_population <= 2000)  {
 //growth depend on pass+mail
  		town_growth_mode = 1;
		town_expansion = growth_speed * (3 * pass_transport - (1 - capital_city) * pass_amt);
	} else {
 //growth depend on pass+mail, 2 * pass and mail goal + food if arctic or tropic regardless of location
  		town_growth_mode = 1;
		if (week_count == 0) {
			GSTown.SetCargoGoal(TownId, GSCargo.TE_PASSENGERS, 
						1 + pass_amt * town_population/2000);
			GSTown.SetCargoGoal(TownId, GSCargo.TE_MAIL, 1 + pass_amt * town_population/10000); 
		}
		if (town_population <= 5000)  {
			town_expansion = growth_speed * (2 * pass_transport - (1 - capital_city) * pass_amt);
		} else if (town_population <= 10000)  {
 //growth depend on pass+mail and consumer goods transport
  			town_growth_mode = 2;
			if (week_count == 0) {
				if (town_population > 7000) {
					if ((GSGame.GetLandscape() == GSGame.LT_ARCTIC) ||
				 	(GSGame.GetLandscape() == GSGame.LT_TROPIC)) {
						GSTown.SetCargoGoal(TownId, GSCargo.TE_FOOD, 1 + cg_amt * town_population/5000)				
					} else {
						GSTown.SetCargoGoal(TownId, GSCargo.TE_GOOD, 1 + cg_amt * town_population/20000)
					}
				}
			}
			cg_transport = TownManagement.CountConsumerGoods(TownId);
			cg_percent = GSToyHelper.a_cg2p(cg_transport, town_population);
			town_expansion = growth_speed * ((2 * pass_transport - (1 - capital_city) * pass_amt) 
							+ (7 + capital_city) * cg_transport);
			if (cg_percent<cg_amt) {
				town_expansion /= 2;
			}
		} else if (town_population <= 20000) {
 //growth depend on pass+mail, consumer and raw resources
  			town_growth_mode = 3;
			cg_transport = TownManagement.CountConsumerGoods(TownId);
			cg_percent = GSToyHelper.a_cg2p(cg_transport, town_population);
			en_transport = 0;
			if (week_count == 0) {
				en_transport = TownManagement.CountEnergyGoods(TownId);
				_town.MonthlyManageTown()
			}
			en_percent = GSToyHelper.a_ig2p(en_transport, town_population);
			if (en_percent<ig_amt) {
				local draw_storage = GSToyHelper.p_ig2a(ig_amt - en_percent, town_population); //use storage
				draw_storage = min(en_storage, draw_storage);
				if (draw_storage>0) {
					en_transport = en_transport + draw_storage;
					en_percent = GSToyHelper.a_ig2p(en_transport, town_population);
					en_storage = max(0, en_storage - draw_storage)
				}					
			} else {
				en_storage = en_storage + GSToyHelper.a_ig2p(en_percent - ig_amt, town_population) //resupply storage
			}				
			_town.town_stockpiled_raw = en_storage;
			town_expansion = growth_speed * 
					(pass_transport - (1 - capital_city) * pass_amt + (2 + capital_city) * cg_transport 
					+ (7 + 2 * capital_city) * en_transport);
			if (en_percent<ig_amt) {
				town_expansion /= 2;
			}
			if ((previous_growth==GSTown.TOWN_GROWTH_NONE) || 
 				(previous_growth==GSTown.TOWN_GROWTH_NORMAL)) {
					town_expansion /= 2;
				} else {
					town_expansion = (4 * 1000000 / previous_growth 
					+ town_expansion) / 5;
			}
/*			}
 
			else {
				town_expansion = growth_speed * (pass_transport - pass_amt);
				if ((previous_growth==GSTown.TOWN_GROWTH_NONE) || 
 				(previous_growth==GSTown.TOWN_GROWTH_NORMAL)) {
					town_expansion = 0;
				} else {
					town_expansion = growth_speed * ((pass_transport - pass_amt) 
							+ 3 * cg_transport);
					town_expansion = (4 * 1000000 / previous_growth 
					+ town_expansion) / 5;
				}
			}
*/
			if (cg_percent<cg_amt) {
				town_expansion /= 4;
			}
		} else { //town_population > 20000
 //growth depend on pass+mail, consumer, industry and energy resources + town effect goods
  			town_growth_mode = 4;
			cg_transport = TownManagement.CountConsumerGoods(TownId);
			cg_percent = GSToyHelper.a_cg2p(cg_transport, town_population);
			if (week_count == 0) {
				GSTown.SetCargoGoal(TownId, GSCargo.TE_GOODS, 1 + cg_amt * town_population/20000)
				en_transport = TownManagement.CountEnergyGoods(TownId);
				ig_transport = TownManagement.CountIndustryGoods(TownId);
				_town.MonthlyManageTown()
			}

			en_percent = GSToyHelper.a_ig2p(en_transport, town_population);
			if (en_percent<ig_amt) {
				local draw_storage = GSToyHelper.p_ig2a(ig_amt - en_percent, town_population); //use storage
				draw_storage = min(en_storage, draw_storage);
				if (draw_storage>0) {
					en_transport = en_transport + draw_storage;
					en_percent = GSToyHelper.a_ig2p(en_transport, town_population);
					en_storage = max(0, en_storage - draw_storage)
				}					
			} else {
				en_storage = en_storage + GSToyHelper.a_ig2p(en_percent - ig_amt, town_population) //resupply storage
			}				
			_town.town_stockpiled_raw = en_storage;

			ig_percent = GSToyHelper.a_ig2p(ig_transport, town_population);
			if (ig_percent<ig_amt) {
				local draw_storage = GSToyHelper.p_ig2a(ig_amt - ig_percent, town_population); //use storage
				draw_storage = min(ig_storage, draw_storage);
				if (draw_storage>0) {
					ig_transport = ig_transport + draw_storage;
					ig_percent = GSToyHelper.a_ig2p(ig_transport, town_population);
					ig_storage = max(0, ig_storage - draw_storage)
				}					
			} else {
				ig_storage = ig_storage + GSToyHelper.a_ig2p(ig_percent - ig_amt, town_population) //resupply storage
			}				
			_town.town_stockpiled_ind = ig_storage;

			town_expansion = growth_speed * 
					(pass_transport - (1 - capital_city) * pass_amt + (1 + capital_city) * cg_transport 
					+ (3 + capital_city) * en_transport + (4 + 3 * capital_city) * ig_transport);
			if (en_percent<ig_amt) {
					town_expansion /= 4;
				}
			if (ig_percent<ig_amt/(1+capital_city)) {
					town_expansion /= 2;
				}
			if (cg_percent<cg_amt) {
				town_expansion /= 8;
			}
			if ((previous_growth==GSTown.TOWN_GROWTH_NONE) || 
 				(previous_growth==GSTown.TOWN_GROWTH_NORMAL)) {
					town_expansion /= 2;
				} else {
					town_expansion = (4 * 1000000 / previous_growth 
					+ town_expansion) / 5;
			}
		}
	}
	if (town_growth_mode > 0) {
			if ((previous_growth==GSTown.TOWN_GROWTH_NONE) || 
 			(previous_growth==GSTown.TOWN_GROWTH_NORMAL)) {
				town_expansion /= (1 + weight_average);
			} else {
				town_expansion = (weight_average * 1000000 / previous_growth 
				+ town_expansion) / (1 + weight_average);
			}
			if ( (town_expansion<1) || 
		( (GSTile.GetTerrainType(GSTown.GetLocation(TownId)) == GSTile.TERRAIN_SNOW) && 
		(GSTown.GetLastMonthReceived(TownId, GSCargo.TE_FOOD)==0) ) ) {        
				town_growth_speed = GSTown.TOWN_GROWTH_NONE;
			} else {
				town_growth_speed = 1 + 1000000 / (1 + town_expansion);
				if (town_growth_speed > 999) {
					town_growth_speed = GSTown.TOWN_GROWTH_NONE;
				}
			}
			if (pass_transport<pass_amt) {
  				town_growth_mode = 0;
				town_growth_speed = GSTown.TOWN_GROWTH_NONE;
			}
	}	
	GSTown.SetGrowthRate(TownId, town_growth_speed);
	if (town_growth_mode == 0) {
		GSTown.SetText(TownId, GSText(GSText.STR_TOWN_PASS_NMET, pass_transport, pass_amt))
	}
	if (town_growth_mode == 1) {
		GSTown.SetText(TownId, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt))
	}
	if (town_growth_mode == 2) {
		GSTown.SetText(TownId, GSText(GSText.STR_TOWN_STAGE2, cg_transport, GSToyHelper.p_cg2a(cg_amt, town_population), refreshrate))
	}
	if (town_growth_mode == 3) {
		GSTown.SetText(TownId, GSText(GSText.STR_TOWN_STAGE3, cg_transport, GSToyHelper.p_cg2a(cg_amt, town_population), refreshrate, en_transport, GSToyHelper.p_ig2a(ig_amt, town_population), 4 * refreshrate, en_storage))
	}
	if (town_growth_mode == 4) {
		GSTown.SetText(TownId, GSText(GSText.STR_TOWN_STAGE4, cg_transport, GSToyHelper.p_cg2a(cg_amt, town_population), refreshrate, en_transport, GSToyHelper.p_ig2a(ig_amt, town_population), en_storage, ig_transport, ig_amt*(20000+town_population)/20000, 4 * refreshrate, ig_storage))
	}
	if (town_growth_mode < 0) {
		GSTown.SetText(TownId, GSText(GSText.STR_TOWN_EMPTY));
	}
}




/* Function called when saving the game. */
function TownManagement::SavingTownData()
{
	local town_data = {};
	town_data.sign_id <- this.sign_id;
	town_data.town_stockpiled_raw <- this.town_stockpiled_raw;
	town_data.town_stockpiled_ind <- this.town_stockpiled_ind;
	return town_data;
}

/* Main town management function. Called each month. */
function TownManagement::MonthlyManageTown()
{
	this.town_stockpiled_raw = this.town_stockpiled_raw /2;
	this.town_stockpiled_ind = this.town_stockpiled_ind /3;

//	this.UpdateTownText();
}

function TownManagement::UpdateTownText()
{
	// Add a sign by the town to display the current growth
		local sign_text = TownSignText();
		if (GSSign.IsValidSign(this.sign_id)) {
			GSSign.SetName(this.sign_id, sign_text);
		} else {
			this.sign_id = GSSign.BuildSign(GSTown.GetLocation(this.id), sign_text);
		}
	// Set the towns text box
//	GSTown.SetText(this.id, this.TownBoxText(true));
}

function TownManagement::RemoveTownText()
{
	// Cleaning signs on the map
	if (GSSign.IsValidSign(this.sign_id)) {
		GSSign.RemoveSign(this.sign_id);
		this.sign_id = -1;
	}

	// Cleaning town's info box
	GSTown.SetText(this.id, this.TownBoxText(false));
}
