/* $Id: settings_func.h 16554 2009-06-10 18:53:43Z smatz $ */

/** @file settings_func.h Functions related to setting/changing the settings. */

#ifndef SETTINGS_FUNC_H
#define SETTINGS_FUNC_H

#include "core/smallvec_type.hpp"

void IConsoleSetSetting(const char *name, const char *value);
void IConsoleSetSetting(const char *name, int32 value);
void IConsoleGetSetting(const char *name);
void IConsoleListSettings(const char *prefilter);

void LoadFromConfig();
void SaveToConfig();
void CheckConfig();

/* Functions to load and save NewGRF settings to a separate
 * configuration file, used for presets. */
typedef AutoFreeSmallVector<char *, 4> GRFPresetList;

void GetGRFPresetList(GRFPresetList *list);
struct GRFConfig *LoadGRFPresetFromConfig(const char *config_name);
void SaveGRFPresetToConfig(const char *config_name, struct GRFConfig *config);
void DeleteGRFPresetFromConfig(const char *config_name);

uint GetCompanySettingIndex(const char *name);
void SetDefaultCompanySettings(CompanyID cid);

#if defined(ENABLE_NETWORK)
void SyncCompanySettings();
#else /* ENABLE_NETWORK */
static inline void SyncCompanySettings() {}
#endif /* ENABLE_NETWORK */

#endif /* SETTINGS_FUNC_H */
