/* $Id: town_land.h 8129 2007-01-14 19:59:25Z peter1138 $ */

/** @file town_land.h */

enum {
	HOUSE_TEMP_CHURCH    = 0x03,
	HOUSE_STADIUM        = 0x14,
	HOUSE_MODERN_STADIUM = 0x20,
	HOUSE_ARCT_CHURCH    = 0x3c,
	HOUSE_SNOW_CHURCH    = 0x3d,
	HOUSE_TROP_CHURCH    = 0x53,
	HOUSE_TOY_CHURCH     = 0x5b,

	HOUSE_MAX            = 110
};

/** Writes the data into the Town Tile Drawing Struct
 * @param s1 The first sprite of the building, mostly the ground sprite
 * @param s2 The second sprite of the building.
 * @param sx The x-position of the sprite within the tile
 * @param xy the y-position of the sprite within the tile
 * @param w the width of the sprite
 * @param h the height of the sprite
 * @param dz the virtual height of the sprite
 * @param p set to 1 if a lift is present
 * @see DrawTownTileStruct
 */
#define M(s1, p1, s2, p2, sx, sy, w, h, dz, p) { { s1, p1 }, { s2, p2 }, sx, sy, w - 1, h - 1, dz, p}

static const DrawBuildingsTileStruct _town_draw_tile_data[] = {
	M( 0xf54, PAL_NONE,  0x58d, PAL_NONE,  0,  0, 14, 14,   8, 0),
	M( 0xf54, PAL_NONE,  0x58e, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x58f, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0x590, PAL_NONE,  0x58f, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x58d, PAL_NONE,  0,  0, 14, 14,   8, 0),
	M( 0xf54, PAL_NONE,  0x58e, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x591, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0x590, PAL_NONE,  0x591, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x58d, PALETTE_TO_STRUCT_WHITE,  0,  0, 14, 14,   8, 0),
	M( 0xf54, PAL_NONE,  0x58e, PALETTE_TO_STRUCT_WHITE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x591, PALETTE_TO_STRUCT_WHITE,  0,  0, 14, 14,  60, 0),
	M( 0x590, PAL_NONE,  0x591, PALETTE_TO_STRUCT_WHITE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x58d, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 14, 14,   8, 0),
	M( 0xf54, PAL_NONE,  0x58e, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x591, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 14, 14,  60, 0),
	M( 0x590, PAL_NONE,  0x591, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x592, PAL_NONE,  0,  0, 14, 16,  11, 0),
	M( 0xf54, PAL_NONE,  0x593, PAL_NONE,  0,  0, 14, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x594, PAL_NONE,  0,  0, 14, 16,  33, 0),
	M( 0x595, PAL_NONE,  0x594, PAL_NONE,  0,  0, 14, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x592, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  11, 0),
	M( 0xf54, PAL_NONE,  0x593, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x594, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  33, 0),
	M( 0x595, PAL_NONE,  0x594, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x592, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  11, 0),
	M( 0xf54, PAL_NONE,  0x593, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x594, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  33, 0),
	M( 0x595, PAL_NONE,  0x594, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x592, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  11, 0),
	M( 0xf54, PAL_NONE,  0x593, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x594, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  33, 0),
	M( 0x595, PAL_NONE,  0x594, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x596, PAL_NONE,  0,  0, 12, 12,   6, 0),
	M( 0xf54, PAL_NONE,  0x597, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0x599, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x596, PAL_NONE,  0,  0, 12, 12,   6, 0),
	M( 0xf54, PAL_NONE,  0x597, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0x599, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x596, PAL_NONE,  0,  0, 12, 12,   6, 0),
	M( 0xf54, PAL_NONE,  0x597, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0x599, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x596, PAL_NONE,  0,  0, 12, 12,   6, 0),
	M( 0xf54, PAL_NONE,  0x597, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0x599, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x59a, PAL_NONE,  0,  0, 14, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x59b, PAL_NONE,  0,  0, 14, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x59c, PAL_NONE,  0,  0, 14, 16,  35, 0),
	M( 0x59d, PAL_NONE,  0x59c, PAL_NONE,  0,  0, 14, 16,  35, 0),
	M( 0xf54, PAL_NONE,  0x59a, PALETTE_59E,  0,  0, 14, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x59b, PALETTE_59E,  0,  0, 14, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x59c, PALETTE_59E,  0,  0, 14, 16,  35, 0),
	M( 0x59d, PAL_NONE,  0x59c, PALETTE_59E,  0,  0, 14, 16,  35, 0),
	M( 0xf54, PAL_NONE,  0x59a, PALETTE_59F,  0,  0, 14, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x59b, PALETTE_59F,  0,  0, 14, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x59c, PALETTE_59F,  0,  0, 14, 16,  35, 0),
	M( 0x59d, PAL_NONE,  0x59c, PALETTE_59F,  0,  0, 14, 16,  35, 0),
	M( 0xf54, PAL_NONE,  0x59a, PALETTE_59F,  0,  0, 14, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x59b, PALETTE_59F,  0,  0, 14, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x59c, PALETTE_59F,  0,  0, 14, 16,  35, 0),
	M( 0x59d, PAL_NONE,  0x59c, PALETTE_59F,  0,  0, 14, 16,  35, 0),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a4, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a5, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a6, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5a7, PAL_NONE,  0x5a6, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a4, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a5, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a6, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5a7, PAL_NONE,  0x5a6, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5dd, PAL_NONE,  0x5de, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5df, PAL_NONE,  0x5e0, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5e1, PAL_NONE,  0x5e2, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5e1, PAL_NONE,  0x5e2, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5dd, PAL_NONE,  0x5de, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5df, PAL_NONE,  0x5e0, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5e1, PAL_NONE,  0x5e2, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5e1, PAL_NONE,  0x5e2, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a8, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5a9, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5a8, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5a9, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5a8, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5a9, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5a8, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5a9, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5ab, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5ac, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5ab, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5ac, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5ab, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5ac, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5ab, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5ac, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5b2, PAL_NONE,  0,  0, 16, 16,   8, 0),
	M( 0xf54, PAL_NONE,  0x5b3, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b4, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0x58c, PAL_NONE,  0x5b4, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b2, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,   8, 0),
	M( 0xf54, PAL_NONE,  0x5b3, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  42, 0),
	M( 0x58c, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b2, PALETTE_TO_STRUCT_RED,  0,  0, 16, 16,   8, 0),
	M( 0xf54, PAL_NONE,  0x5b3, PALETTE_TO_STRUCT_RED,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_RED,  0,  0, 16, 16,  42, 0),
	M( 0x58c, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_RED,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b2, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,   8, 0),
	M( 0xf54, PAL_NONE,  0x5b3, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  42, 0),
	M( 0x58c, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b5, PAL_NONE,  1,  3, 14, 11,   7, 0),
	M( 0xf54, PAL_NONE,  0x5b6, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0x58c, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b5, PAL_NONE,  1,  3, 14, 11,   7, 0),
	M( 0xf54, PAL_NONE,  0x5b6, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0x58c, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b5, PAL_NONE,  1,  3, 14, 11,   7, 0),
	M( 0xf54, PAL_NONE,  0x5b6, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0x58c, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b5, PAL_NONE,  1,  3, 14, 11,   7, 0),
	M( 0xf54, PAL_NONE,  0x5b6, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0x58c, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b8, PAL_NONE,  3,  1, 11, 14,   6, 0),
	M( 0xf54, PAL_NONE,  0x5b9, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0x58c, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5b8, PAL_NONE,  3,  1, 11, 14,   6, 0),
	M( 0xf54, PAL_NONE,  0x5b9, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0x58c, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5b8, PAL_NONE,  3,  1, 11, 14,   6, 0),
	M( 0xf54, PAL_NONE,  0x5b9, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0x58c, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5b8, PAL_NONE,  3,  1, 11, 14,   6, 0),
	M( 0xf54, PAL_NONE,  0x5b9, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0x58c, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5bb, PAL_NONE,  2,  0, 13, 16,   6, 0),
	M( 0xf54, PAL_NONE,  0x5bc, PAL_NONE,  2,  0, 13, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5bd, PAL_NONE,  2,  0, 13, 16,  46, 0),
	M( 0x58c, PAL_NONE,  0x5bd, PAL_NONE,  2,  0, 13, 16,  46, 0),
	M( 0xf54, PAL_NONE,  0x5bb, PAL_NONE,  2,  0, 13, 16,   6, 0),
	M( 0xf54, PAL_NONE,  0x5bc, PAL_NONE,  2,  0, 13, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5bd, PAL_NONE,  2,  0, 13, 16,  46, 0),
	M( 0x58c, PAL_NONE,  0x5bd, PAL_NONE,  2,  0, 13, 16,  46, 0),
	M( 0xf54, PAL_NONE,  0x5bb, PALETTE_TO_STRUCT_BLUE,  2,  0, 13, 16,   6, 0),
	M( 0xf54, PAL_NONE,  0x5bc, PALETTE_TO_STRUCT_BLUE,  2,  0, 13, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5bd, PALETTE_TO_STRUCT_BLUE,  2,  0, 13, 16,  46, 0),
	M( 0x58c, PAL_NONE,  0x5bd, PALETTE_TO_STRUCT_BLUE,  2,  0, 13, 16,  46, 0),
	M( 0xf54, PAL_NONE,  0x5bb, PALETTE_TO_STRUCT_WHITE,  2,  0, 13, 16,   6, 0),
	M( 0xf54, PAL_NONE,  0x5bc, PALETTE_TO_STRUCT_WHITE,  2,  0, 13, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5bd, PALETTE_TO_STRUCT_WHITE,  2,  0, 13, 16,  46, 0),
	M( 0x58c, PAL_NONE,  0x5bd, PALETTE_TO_STRUCT_WHITE,  2,  0, 13, 16,  46, 0),
	M( 0xf54, PAL_NONE,  0x5be, PALETTE_TO_RED,  2,  0, 13, 16,  13, 0),
	M( 0xf54, PAL_NONE,  0x5bf, PALETTE_TO_RED,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c0, PALETTE_TO_RED,  2,  0, 13, 16, 110, 0),
	M( 0x58c, PAL_NONE,  0x5c0, PALETTE_TO_RED,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5be, PALETTE_TO_BLUE,  2,  0, 13, 16,  13, 0),
	M( 0xf54, PAL_NONE,  0x5bf, PALETTE_TO_BLUE,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c0, PALETTE_TO_BLUE,  2,  0, 13, 16, 110, 0),
	M( 0x58c, PAL_NONE,  0x5c0, PALETTE_TO_BLUE,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5be, PALETTE_TO_ORANGE,  2,  0, 13, 16,  13, 0),
	M( 0xf54, PAL_NONE,  0x5bf, PALETTE_TO_ORANGE,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c0, PALETTE_TO_ORANGE,  2,  0, 13, 16, 110, 0),
	M( 0x58c, PAL_NONE,  0x5c0, PALETTE_TO_ORANGE,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5be, PALETTE_TO_GREEN,  2,  0, 13, 16,  13, 0),
	M( 0xf54, PAL_NONE,  0x5bf, PALETTE_TO_GREEN,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c0, PALETTE_TO_GREEN,  2,  0, 13, 16, 110, 0),
	M( 0x58c, PAL_NONE,  0x5c0, PALETTE_TO_GREEN,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c1, PAL_NONE,  1,  2, 15, 12,   4, 0),
	M( 0xf54, PAL_NONE,  0x5c2, PAL_NONE,  1,  2, 15, 12,  24, 0),
	M( 0xf54, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0x58c, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0xf54, PAL_NONE,  0x5c1, PAL_NONE,  1,  2, 15, 12,   4, 0),
	M( 0xf54, PAL_NONE,  0x5c2, PAL_NONE,  1,  2, 15, 12,  24, 0),
	M( 0xf54, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0x58c, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0xf54, PAL_NONE,  0x5c1, PAL_NONE,  1,  2, 15, 12,   4, 0),
	M( 0xf54, PAL_NONE,  0x5c2, PAL_NONE,  1,  2, 15, 12,  24, 0),
	M( 0xf54, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0x58c, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0xf54, PAL_NONE,  0x5c1, PAL_NONE,  1,  2, 15, 12,   4, 0),
	M( 0xf54, PAL_NONE,  0x5c2, PAL_NONE,  1,  2, 15, 12,  24, 0),
	M( 0xf54, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0x58c, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0xf54, PAL_NONE,  0x5c4, PAL_NONE,  1,  0, 14, 15,  20, 0),
	M( 0xf54, PAL_NONE,  0x5c5, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x58c, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c4, PAL_NONE,  1,  0, 14, 15,  20, 0),
	M( 0xf54, PAL_NONE,  0x5c5, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x58c, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c4, PAL_NONE,  1,  0, 14, 15,  20, 0),
	M( 0xf54, PAL_NONE,  0x5c5, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x58c, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c4, PAL_NONE,  1,  0, 14, 15,  20, 0),
	M( 0xf54, PAL_NONE,  0x5c5, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x58c, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x5c7, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,  0x5d4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d3, PAL_NONE,  0x5d4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d3, PAL_NONE,  0x5d4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d3, PAL_NONE,  0x5d4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x5d6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d5, PAL_NONE,  0x5d6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d5, PAL_NONE,  0x5d6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d5, PAL_NONE,  0x5d6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x5d0, PAL_NONE,  0,  0, 16, 16,  21, 0),
	M( 0x5cf, PAL_NONE,  0x5d0, PAL_NONE,  0,  0, 16, 16,  21, 0),
	M( 0x5cf, PAL_NONE,  0x5d0, PAL_NONE,  0,  0, 16, 16,  21, 0),
	M( 0x5cf, PAL_NONE,  0x5d0, PAL_NONE,  0,  0, 16, 16,  21, 0),
	M( 0xf54, PAL_NONE,  0x5d2, PAL_NONE,  0,  0, 16, 16,  11, 0),
	M( 0x5d1, PAL_NONE,  0x5d2, PAL_NONE,  0,  0, 16, 16,  11, 0),
	M( 0x5d1, PAL_NONE,  0x5d2, PAL_NONE,  0,  0, 16, 16,  11, 0),
	M( 0x5d1, PAL_NONE,  0x5d2, PAL_NONE,  0,  0, 16, 16,  11, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5da, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5db, PAL_NONE,  0x5dc, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5db, PAL_NONE,  0x5dc, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x622, PAL_NONE,  0x623, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x624, PAL_NONE,  0x625, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x626, PAL_NONE,  0x627, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x626, PAL_NONE,  0x627, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e3, PAL_NONE,  0x5e4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e5, PAL_NONE,  0x5e6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e7, PAL_NONE,  0x5e8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e7, PAL_NONE,  0x5e8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e9, PAL_NONE,  0x5ea, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5eb, PAL_NONE,  0x5ec, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5ed, PAL_NONE,  0x5ee, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5ed, PAL_NONE,  0x5ee, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5ef, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f0, PAL_NONE,  0x5f1, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f2, PAL_NONE,  0x5f3, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f2, PAL_NONE,  0x5f3, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5ef, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f0, PAL_NONE,  0x5f1, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f2, PAL_NONE,  0x5f3, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f2, PAL_NONE,  0x5f3, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f4, PAL_NONE,  0x5f5, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f6, PAL_NONE,  0x5f7, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f8, PAL_NONE,  0x5f9, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f8, PAL_NONE,  0x5f9, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f4, PAL_NONE,  0x5f5, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f6, PAL_NONE,  0x5f7, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f8, PAL_NONE,  0x5f9, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f8, PAL_NONE,  0x5f9, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5fa, PAL_NONE,  0x5fb, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fc, PAL_NONE,  0x5fd, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fe, PAL_NONE,  0x5ff, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fe, PAL_NONE,  0x5ff, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fa, PAL_NONE,  0x5fb, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fc, PAL_NONE,  0x5fd, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fe, PAL_NONE,  0x5ff, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fe, PAL_NONE,  0x5ff, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x60a, PAL_NONE,  0x60b, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60c, PAL_NONE,  0x60d, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60e, PAL_NONE,  0x60f, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60e, PAL_NONE,  0x60f, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60a, PAL_NONE,  0x60b, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60c, PAL_NONE,  0x60d, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60e, PAL_NONE,  0x60f, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60e, PAL_NONE,  0x60f, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x600, PAL_NONE,  0x601, PAL_NONE,  0,  0, 16, 16,  55, 0),
	M( 0x600, PAL_NONE,  0x601, PAL_NONE,  0,  0, 16, 16,  55, 0),
	M( 0x600, PAL_NONE,  0x601, PAL_NONE,  0,  0, 16, 16,  55, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x600, PALETTE_TO_STRUCT_WHITE,  0x601, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  55, 0),
	M( 0x600, PALETTE_TO_STRUCT_WHITE,  0x601, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  55, 0),
	M( 0x600, PALETTE_TO_STRUCT_WHITE,  0x601, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  55, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x602, PAL_NONE,  0x603, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0x602, PAL_NONE,  0x603, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0x602, PAL_NONE,  0x603, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x602, PALETTE_TO_STRUCT_CONCRETE,  0x603, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  42, 0),
	M( 0x602, PALETTE_TO_STRUCT_CONCRETE,  0x603, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  42, 0),
	M( 0x602, PALETTE_TO_STRUCT_CONCRETE,  0x603, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  42, 0),
	M( 0x604, PAL_NONE,  0x605, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x606, PAL_NONE,  0x607, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x604, PAL_NONE,  0x605, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x606, PAL_NONE,  0x607, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x604, PAL_NONE,  0x605, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x606, PAL_NONE,  0x607, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x604, PAL_NONE,  0x605, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x606, PAL_NONE,  0x607, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x612, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61c, PAL_NONE,  0x61d, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61c, PAL_NONE,  0x61d, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61c, PAL_NONE,  0x61d, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61c, PAL_NONE,  0x61d, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61e, PAL_NONE,  0x61f, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0x61e, PAL_NONE,  0x61f, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0x61e, PAL_NONE,  0x61f, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61e, PALETTE_TO_STRUCT_WHITE,  0x61f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M( 0x61e, PALETTE_TO_STRUCT_WHITE,  0x61f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M( 0x61e, PALETTE_TO_STRUCT_WHITE,  0x61f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x620, PAL_NONE,  0x621, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0x620, PAL_NONE,  0x621, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0x620, PAL_NONE,  0x621, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x620, PALETTE_TO_CREAM,  0x621, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M( 0x620, PALETTE_TO_CREAM,  0x621, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M( 0x620, PALETTE_TO_CREAM,  0x621, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x11da, PAL_NONE, 0x11db, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(0x11da, PAL_NONE, 0x11db, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(0x11da, PAL_NONE, 0x11db, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x11da, PALETTE_TO_STRUCT_WHITE, 0x11db, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M(0x11da, PALETTE_TO_STRUCT_WHITE, 0x11db, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M(0x11da, PALETTE_TO_STRUCT_WHITE, 0x11db, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x11dc, PAL_NONE, 0x11dd, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(0x11dc, PAL_NONE, 0x11dd, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(0x11dc, PAL_NONE, 0x11dd, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x11dc, PALETTE_TO_CREAM, 0x11dd, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M(0x11dc, PALETTE_TO_CREAM, 0x11dd, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M(0x11dc, PALETTE_TO_CREAM, 0x11dd, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x1147, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x1147, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x1147, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x1147, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x114b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x114b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x114b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x114b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x114c, PAL_NONE, 0x1150, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M(0x114c, PAL_NONE, 0x1150, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M(0x114c, PAL_NONE, 0x1150, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M(0x114c, PAL_NONE, 0x1150, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x114d, PAL_NONE, 0x1151, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M(0x114d, PAL_NONE, 0x1151, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M(0x114d, PAL_NONE, 0x1151, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M(0x114d, PAL_NONE, 0x1151, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1153, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1155, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x1155, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1155, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x1155, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1155, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x1155, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1155, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x1155, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11de, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x11de, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11de, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x11de, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11de, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x11de, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11de, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x11de, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1159, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x1159, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1159, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x1159, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1159, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x1159, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1159, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x1159, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11df, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x11df, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11df, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x11df, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11df, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x11df, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11df, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x11df, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x115d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115d, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x115d, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115d, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x115d, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115d, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x115d, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e0, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x11e0, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e0, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x11e0, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e0, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x11e0, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e0, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x11e0, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1160, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1161, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x115e, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1160, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1161, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x115e, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1166, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1167, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1164, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1166, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1167, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1164, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1160, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1161, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x115f, PAL_NONE, 0x1163, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1160, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1161, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x115f, PAL_NONE, 0x1163, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1166, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1167, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1165, PAL_NONE, 0x1169, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1166, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1167, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1165, PAL_NONE, 0x1169, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1172, PAL_NONE, 0x1175, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M(0x1172, PAL_NONE, 0x1175, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M(0x1172, PAL_NONE, 0x1175, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M(0x1172, PAL_NONE, 0x1175, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x11e4, PAL_NONE, 0x11e5, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M(0x11e4, PAL_NONE, 0x11e5, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M(0x11e4, PAL_NONE, 0x11e5, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M(0x11e4, PAL_NONE, 0x11e5, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x117f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x117f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117f, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x117f, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x117f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x11e1, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x11e1, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x11e1, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x11e1, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x11e1, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x11e3, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x11e1, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x11e1, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1184, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1184, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1184, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1184, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x11e9, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x11e9, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x11e9, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x11e9, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x118b, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x118b, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x118b, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x118b, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118c, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118c, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118c, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118c, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x11ea, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x11ea, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x11ea, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x11ea, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x11eb, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x11eb, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x11eb, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x11eb, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M( 0xf54, PAL_NONE, 0x11ec, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ee, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ec, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ee, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ec, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ee, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ec, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ee, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ef, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f1, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ef, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f1, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ef, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f1, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ef, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f1, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f4, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f4, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f4, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f4, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f5, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f5, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f5, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f6, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f6, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f6, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f7, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f7, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f7, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f8, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f8, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f8, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f9, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fb, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11f9, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fb, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11f9, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fb, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11f9, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fb, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fd, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ff, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fd, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ff, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fd, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ff, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fd, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ff, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1200, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1202, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1200, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1202, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1200, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1202, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1200, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1202, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1203, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1205, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1203, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1205, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1203, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1205, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1203, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1205, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1206, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120a, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1206, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120a, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1206, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120a, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1206, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120a, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1207, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120b, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1207, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120b, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1207, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120b, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1207, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120b, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120e, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120e, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120e, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120e, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1211, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x120f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1211, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x120f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1211, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x120f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1211, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1213, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1214, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1214, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1215, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1213, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1214, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1214, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1215, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1213, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1214, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1214, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1215, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1213, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1214, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1214, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1215, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1216, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1218, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1216, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1218, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1216, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1218, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1216, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1218, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1219, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1219, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1219, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1219, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1220, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1220, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1221, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121f, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1220, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1220, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1221, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121f, PALETTE_TO_MAUVE, 0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1220, PALETTE_TO_MAUVE, 0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1220, PALETTE_TO_MAUVE, 0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1221, PALETTE_TO_MAUVE, 0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121f, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1220, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1220, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1221, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1222, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1223, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1223, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1224, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1222, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1223, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1223, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1224, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1222, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1223, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1223, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1224, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1222, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1223, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1223, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1224, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1225, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1226, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1226, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1227, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1225, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1226, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1226, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1227, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1225, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1226, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1226, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1227, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1225, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1226, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1226, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1227, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1228, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1228, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1228, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1228, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1230, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1230, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1230, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1230, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1231, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1233, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1231, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1233, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1231, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1233, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1231, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1233, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1234, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1236, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1234, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1236, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1234, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1236, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1234, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1236, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1237, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1239, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1237, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1239, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1237, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1239, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1237, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1239, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1240, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1242, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1240, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1242, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1240, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1242, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1240, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1242, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1257, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1259, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1257, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1259, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1257, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1259, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1257, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1259, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
};
#undef M
// 4 variants * 4 build stages
assert_compile(lengthof(_town_draw_tile_data) == HOUSE_MAX * 4 * 4);


static const StringID _town_tile_names[] = {
	STR_200F_TALL_OFFICE_BLOCK,
	STR_2010_OFFICE_BLOCK,
	STR_2011_SMALL_BLOCK_OF_FLATS,
	STR_2012_CHURCH,
	STR_2013_LARGE_OFFICE_BLOCK,
	STR_2013_LARGE_OFFICE_BLOCK,
	STR_2014_TOWN_HOUSES,
	STR_2015_HOTEL,
	STR_2015_HOTEL,
	STR_2016_STATUE,
	STR_2017_FOUNTAIN,
	STR_2018_PARK,
	STR_2018_PARK,
	STR_2019_OFFICE_BLOCK,
	STR_201A_SHOPS_AND_OFFICES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_201B_MODERN_OFFICE_BUILDING,
	STR_201C_WAREHOUSE,
	STR_201D_OFFICE_BLOCK,
	STR_201E_STADIUM,
	STR_201E_STADIUM,
	STR_201E_STADIUM,
	STR_201E_STADIUM,
	STR_201F_OLD_HOUSES,
	STR_2036_COTTAGES,
	STR_2037_HOUSES,
	STR_2038_FLATS,
	STR_2039_TALL_OFFICE_BLOCK,
	STR_203A_SHOPS_AND_OFFICES,
	STR_203B_SHOPS_AND_OFFICES,
	STR_203C_THEATER,
	STR_203D_STADIUM,
	STR_203D_STADIUM,
	STR_203D_STADIUM,
	STR_203D_STADIUM,
	STR_203E_OFFICES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_2040_CINEMA,
	STR_2041_SHOPPING_MALL,
	STR_2041_SHOPPING_MALL,
	STR_2041_SHOPPING_MALL,
	STR_2041_SHOPPING_MALL,
	STR_2038_FLATS,
	STR_2038_FLATS,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_2012_CHURCH,
	STR_2012_CHURCH,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_2015_HOTEL,
	STR_2015_HOTEL,
	STR_2015_HOTEL,
	STR_2015_HOTEL,
	STR_201A_SHOPS_AND_OFFICES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_2038_FLATS,
	STR_2012_CHURCH,
	STR_203F_HOUSES,
	STR_2038_FLATS,
	STR_2038_FLATS,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_2038_FLATS,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_2012_CHURCH,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_203F_HOUSES,
	STR_203F_HOUSES,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_2059_IGLOO,
	STR_205A_TEPEES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_201A_SHOPS_AND_OFFICES,
	STR_200F_TALL_OFFICE_BLOCK,
	STR_2016_STATUE,
	STR_205B_TEAPOT_HOUSE,
	STR_205C_PIGGY_BANK,
};
assert_compile(lengthof(_town_tile_names) == HOUSE_MAX);

static const uint16 _housetype_flags[] = {
	0x1010, 0x1018, 0x100E, 0x100F, 0x7010, 0x0810, 0x100F, 0x1014,
	0x0000, 0x7018, 0x7010, 0x1004, 0x1008, 0x1018, 0x101C, 0x101C,
	0x101C, 0x7010, 0x1010, 0x1010, 0x100F, 0x0000, 0x0000, 0x0000,
	0x1003, 0x1001, 0x100F, 0x101C, 0x101C, 0x101C, 0x5014, 0x1018,
	0x700F, 0x0000, 0x0000, 0x0000, 0x7018, 0x2003, 0x0803, 0x101C,
	0x101E, 0x0000, 0x0000, 0x0000, 0x201C, 0x081C, 0x200F, 0x080F,
	0x2007, 0x0807, 0x6018, 0x0818, 0x2018, 0x0818, 0x6018, 0x0818,
	0x2001, 0x0801, 0x201E, 0x081E, 0x200F, 0x080F, 0x2007, 0x0807,
	0x201C, 0x081C, 0x201C, 0x0000, 0x081C, 0x0000, 0x601C, 0x081C,
	0x2018, 0x0818, 0x201C, 0x0000, 0x081C, 0x0000, 0x401E, 0x401E,
	0x401E, 0x4001, 0x401C, 0x400E, 0x401E, 0x401C, 0x401C, 0x4018,
	0x4000, 0x401C, 0x4018, 0x801F, 0x801F, 0x8003, 0x800F, 0x800F,
	0x800F, 0x800F, 0x801C, 0x801F, 0x0000, 0x801C, 0x8001, 0x8001,
	0x801C, 0x801C, 0x801C, 0x801C, 0x801F, 0x801F,
};
assert_compile(lengthof(_housetype_flags) == HOUSE_MAX);

static const byte _housetype_extra_flags[] = {
	 0,  0,  0,  0, 32, 32,  0,  8,
	 0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0, 16,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,
	16,  0,  0,  0,  0,  0,  0,  0,
	16,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  8,  0,  8,  0,  0,  0,
	 0,  0,  4,  0,  4,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  4,
	 0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  8,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,
};
assert_compile(lengthof(_housetype_extra_flags) == HOUSE_MAX);

static const byte _housetype_population[] = {
	187,  85,  40,   5, 220, 220,  30, 140,
	  0,   0,   0,   0,   0, 150,  95,  95,
	 95, 130,   6, 110,  65,   0,   0,   0,
	 15,  12,  13, 100, 170, 100, 180,  35,
	 65,   0,   0,   0, 140,  15,  15,  35,
	180,   0,   0,   0,  80,  80,  16,  16,
	 14,  14, 135, 135, 170, 170, 210, 210,
	 10,  10,  25,  25,   6,   6,  17,  17,
	 90,  90, 140,   0, 140,   0, 105, 105,
	190, 190, 250,   0, 250,   0,  16,  16,
	 16,   7,  45,   8,  18,  90, 120, 250,
	  0,  80, 180,   8,  18,   7,  15,  17,
	 19,  21,  75,  35,   0,  85,  11,  10,
	 67,  86,  95,  30,  25,  18,
};
assert_compile(lengthof(_housetype_population) == HOUSE_MAX);

static const byte _housetype_mailamount[] = {
	70, 55, 20,  2, 85, 85, 12, 22,
	22,  0,  0,  0,  0, 65, 48, 48,
	48, 50, 10, 55,  5,  5,  5,  5,
	 6,  7,  8, 35, 50, 40, 64, 23,
	 5,  5,  5,  5, 65,  6,  6, 23,
	 5,  5,  5,  5, 20, 20,  6,  6,
	 6,  6, 60, 60, 70, 70, 80, 80,
	 5,  5, 20, 20,  2,  2,  7,  7,
	45, 45, 25, 25, 25, 25, 50, 50,
	75, 75, 60, 60, 60, 60,  6,  6,
	 5,  4, 15,  3,  7, 24, 25, 80,
	80, 23, 90,  3,  5,  3,  6,  6,
	 6,  6, 20,  9,  0, 18,  3,  3,
	22, 23, 28, 10,  8,  7,
};
assert_compile(lengthof(_housetype_mailamount) == HOUSE_MAX);

static const byte _housetype_remove_cost[] = {
	 150, 140, 100,  90, 160, 160,  80, 180,
	 180,  65,  65,  60,  60, 130, 110, 105,
	 107, 200, 145, 155, 250, 250, 250, 250,
	  70,  75,  71, 135, 145, 132, 155, 220,
	 250, 250, 250, 250, 170,  70,  70, 210,
	 250, 250, 250, 250, 100, 100,  70,  70,
	  80,  80, 150, 150, 170, 170, 200, 200,
	  60,  60, 100, 100,  85,  85,  80,  80,
	 140, 140, 160, 160, 160, 160, 130, 130,
	 190, 190, 140, 140, 140, 140,  80,  80,
	  80,  30, 130,  90,  80, 110, 120, 190,
	 190, 110, 180,  90,  90,  70,  80,  80,
	  80,  80, 160,  90,  90, 150,  60,  60,
	 140, 145, 165,  90,  75,  85,
};
assert_compile(lengthof(_housetype_remove_cost) == HOUSE_MAX);

static const uint16 _housetype_remove_ratingmod[] = {
	 140, 130,  90, 230, 160, 160,  80, 150,
	 150,  40,  40,  75,  75, 110, 100, 100,
	 100, 150, 110, 110, 300, 300, 300, 300,
	  75,  75,  75, 100, 170, 135, 180, 230,
	 300, 300, 300, 300, 250,  75,  75, 230,
	 300, 300, 300, 300,  90,  90,  70,  70,
	  70,  70, 120, 120, 130, 130, 140, 140,
	  60,  60,  80,  80, 230, 230,  80,  80,
	 110, 110, 160, 160, 160, 160, 105, 105,
	 135, 135, 200, 200, 200, 200,  80,  80,
	  80,  30,  95, 200,  80,  95,  95, 140,
	 140,  95, 150, 200,  90,  50,  75,  75,
	  75,  75, 130,  80,  80, 130,  45,  45,
	 130, 130, 130,  70,  65,  95,
};
assert_compile(lengthof(_housetype_remove_ratingmod) == HOUSE_MAX);


typedef struct {
	Year min, max;
} HousetypeYear;

static const HousetypeYear _housetype_years[] = {
	{ 1963, MAX_YEAR },
	{ 1957, MAX_YEAR },
	{ 1968, MAX_YEAR },
	{    0, MAX_YEAR },
	{ 1975, MAX_YEAR },
	{ 1975, MAX_YEAR },
	{    0, MAX_YEAR },
	{ 1959, MAX_YEAR },
	{ 1959, MAX_YEAR },
	{ 1945, MAX_YEAR },
	{ 1945, MAX_YEAR },
	{    0, MAX_YEAR },
	{ 1935, MAX_YEAR },
	{ 1951, MAX_YEAR },
	{ 1930,     1960 },
	{ 1930,     1960 },
	{ 1930,     1960 },
	{ 1977, MAX_YEAR },
	{ 1983, MAX_YEAR },
	{ 1985, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0,     1951 },
	{    0,     1952 },
	{ 1931, MAX_YEAR },
	{ 1935, MAX_YEAR },
	{ 1963, MAX_YEAR },
	{    0,     1955 },
	{ 1973, MAX_YEAR },
	{    0, MAX_YEAR },
	{ 1958, MAX_YEAR },
	{ 1958, MAX_YEAR },
	{ 1958, MAX_YEAR },
	{ 1958, MAX_YEAR },
	{ 2000, MAX_YEAR },
	{    0,     1960 },
	{    0,     1960 },
	{ 1945, MAX_YEAR },
	{ 1983, MAX_YEAR },
	{ 1983, MAX_YEAR },
	{ 1983, MAX_YEAR },
	{ 1983, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0,     1963 },
	{    0,     1963 },
	{ 1966, MAX_YEAR },
	{ 1966, MAX_YEAR },
	{ 1970, MAX_YEAR },
	{ 1970, MAX_YEAR },
	{ 1974, MAX_YEAR },
	{ 1974, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0,     1960 },
	{    0,     1960 },
	{ 1972, MAX_YEAR },
	{ 1972, MAX_YEAR },
	{ 1972, MAX_YEAR },
	{ 1972, MAX_YEAR },
	{ 1963, MAX_YEAR },
	{ 1963, MAX_YEAR },
	{ 1978, MAX_YEAR },
	{ 1978, MAX_YEAR },
	{ 1967, MAX_YEAR },
	{ 1967, MAX_YEAR },
	{ 1967, MAX_YEAR },
	{ 1967, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{ 1973, MAX_YEAR },
	{ 1962, MAX_YEAR },
	{ 1984, MAX_YEAR },
	{ 1984, MAX_YEAR },
	{    0, MAX_YEAR },
	{ 1993, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
	{    0, MAX_YEAR },
};
assert_compile(lengthof(_housetype_years) == HOUSE_MAX);

static const byte _housetype_cargo_passengers[] = {
	8,  8,  8,  2, 10, 10,  4,  6,
	6,  2,  2,  2,  2,  8,  6,  6,
	6, 10,  6,  6,  4,  4,  4,  4,
	3,  3,  3,  7,  8,  6,  8,  8,
	4,  4,  4,  4,  8,  3,  3,  8,
	8,  8,  8,  8,  5,  5,  3,  3,
	3,  3,  8,  8,  9,  9, 10, 10,
	2,  2,  3,  3,  2,  2,  3,  3,
	6,  6,  6,  6,  6,  6,  7,  7,
	9,  9,  7,  7,  7,  7,  3,  3,
	3,  3,  6,  2,  3,  6,  6,  8,
	8,  6,  8,  2,  6,  3,  3,  3,
	3,  3,  8,  4,  4,  8,  3,  3,
	8,  8,  8,  4,  3,  3,
};
assert_compile(lengthof(_housetype_cargo_passengers) == HOUSE_MAX);

static const byte _housetype_cargo_mail[] = {
	 3, 3, 3, 0, 4, 4, 1, 1,
	 1, 0, 0, 0, 0, 2, 2, 2,
	 2, 3, 3, 2, 0, 0, 0, 0,
	 1, 1, 1, 2, 3, 2, 3, 2,
	 0, 0, 0, 0, 3, 1, 1, 2,
	 2, 2, 2, 2, 2, 2, 1, 1,
	 1, 1, 3, 3, 3, 3, 3, 3,
	 1, 1, 1, 1, 0, 0, 1, 1,
	 2, 2, 1, 1, 1, 1, 2, 2,
	 3, 3, 2, 2, 2, 2, 1, 1,
	 1, 1, 2, 0, 1, 2, 2, 3,
	 3, 2, 3, 0, 2, 1, 1, 1,
	 1, 1, 4, 1, 1, 4, 1, 1,
	 4, 4, 4, 1, 1, 2,
};
assert_compile(lengthof(_housetype_cargo_mail) == HOUSE_MAX);

static const byte _housetype_cargo_goods[] = {
	 4, 4, 1, 0, 6, 6, 0, 2,
	 2, 0, 0, 0, 0, 4, 3, 3,
	 3, 6, 8, 6, 0, 0, 0, 0,
	 0, 0, 0, 2, 3, 3, 3, 2,
	 0, 0, 0, 0, 2, 0, 0, 2,
	 3, 3, 3, 3, 0, 0, 0, 0,
	 0, 0, 4, 4, 4, 4, 5, 5,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 3, 3, 0, 2, 0, 2, 3, 3,
	 4, 4, 2, 2, 2, 2, 0, 0,
	 0, 0, 1, 0, 0, 1, 1, 4,
	 4, 1, 4, 0, 2, 1, 2, 2,
	 2, 2, 2, 2, 2, 2, 1, 1,
	 0, 0, 2, 2, 2, 0
};
assert_compile(lengthof(_housetype_cargo_goods) == HOUSE_MAX);

static const byte _housetype_cargo_food[] = {
	 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 1, 1, 0,
	 0, 0, 0, 0, 2, 2, 2, 2,
	 2, 2, 0, 0, 0, 0, 0, 0,
	 1, 1, 1, 1, 0, 0, 1, 1,
	 0, 0, 3, 0, 3, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 2, 2,
	 2, 1, 0, 0, 2, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 4, 4, 0, 0, 0, 4
};
assert_compile(lengthof(_housetype_cargo_food) == HOUSE_MAX);

static const byte _house_more_flags[] = {
	  8,  8,  8,  8,  8,  8,  8, 12,
	  0,  8,  8,  8,  8,  8,  8,  8,
	  8,  8,  8,  8, 15,  0,  0,  0,
	  8,  8,  8,  8,  8,  8,  8,  8,
	 15,  0,  0,  0,  8,  8,  8,  8,
	 15,  0,  0,  0,  8,  8,  8,  8,
	  8,  8,  8,  8,  8,  8,  8,  8,
	  8,  8,  8,  8,  8,  8,  8,  8,
	  8,  8, 12,  0, 12,  0,  8,  8,
	  8,  8, 10,  0, 10,  0,  8,  8,
	  8,  8,  8,  8,  8,  8,  8, 10,
	  0,  8,  8,  8,  8,  8,  8,  8,
	  8,  8,  8, 12,  0,  8,  8,  8,
	  8,  8,  8,  8,  8,  8,
};
assert_compile(lengthof(_house_more_flags) == HOUSE_MAX);
