# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Optional
from typing_extensions import Literal

from ..._models import BaseModel

__all__ = ["ResponseApplyPatchToolCallOutput"]


class ResponseApplyPatchToolCallOutput(BaseModel):
    id: str
    """The unique ID of the apply patch tool call output.

    Populated when this item is returned via API.
    """

    call_id: str
    """The unique ID of the apply patch tool call generated by the model."""

    status: Literal["completed", "failed"]
    """The status of the apply patch tool call output. One of `completed` or `failed`."""

    type: Literal["apply_patch_call_output"]
    """The type of the item. Always `apply_patch_call_output`."""

    created_by: Optional[str] = None
    """The ID of the entity that created this tool call output."""

    output: Optional[str] = None
    """Optional textual output returned by the apply patch tool."""
