/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.document.bulk;

import java.io.IOException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.index.get.GetResult;
import org.opensearch.protobufs.ErrorCause;
import org.opensearch.protobufs.ResponseItem;
import org.opensearch.transport.grpc.proto.response.document.common.DocWriteResponseProtoUtils;
import org.opensearch.transport.grpc.proto.response.document.get.GetResultProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.opensearchexception.OpenSearchExceptionProtoUtils;
import org.opensearch.transport.grpc.util.RestToGrpcStatusConverter;

public class BulkItemResponseProtoUtils {
    private BulkItemResponseProtoUtils() {
    }

    public static ResponseItem toProto(BulkItemResponse response) throws IOException {
        if (!response.isFailed()) {
            DocWriteResponse docResponse = response.getResponse();
            responseItemBuilder = DocWriteResponseProtoUtils.toProto(docResponse);
            grpcStatusCode = RestToGrpcStatusConverter.getGrpcStatusCode(docResponse.status());
            responseItemBuilder.setStatus(grpcStatusCode);
        } else {
            BulkItemResponse.Failure failure = response.getFailure();
            responseItemBuilder = ResponseItem.newBuilder();
            responseItemBuilder.setXIndex(failure.getIndex());
            if (response.getId() != null && !response.getId().isEmpty()) {
                responseItemBuilder.setXId(response.getId());
            }
            grpcStatusCode = RestToGrpcStatusConverter.getGrpcStatusCode(failure.getStatus());
            responseItemBuilder.setStatus(grpcStatusCode);
            ErrorCause errorCause = OpenSearchExceptionProtoUtils.generateThrowableProto(failure.getCause());
            responseItemBuilder.setError(errorCause);
        }
        ResponseItem.Builder responseItemBuilder = switch (response.getOpType()) {
            case DocWriteRequest.OpType.CREATE -> {
            }
            case DocWriteRequest.OpType.INDEX -> {
            }
            case DocWriteRequest.OpType.UPDATE -> {
                GetResult getResult;
                UpdateResponse updateResponse = (UpdateResponse)response.getResponse();
                if (updateResponse == null || (getResult = updateResponse.getGetResult()) == null) yield GetResultProtoUtils.toProto(getResult, responseItemBuilder);
            }
            case DocWriteRequest.OpType.DELETE -> {
            }
            default -> throw new UnsupportedOperationException("Invalid op type: " + String.valueOf(response.getOpType()));
        };
        return responseItemBuilder.build();
    }
}

