function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiSideNavItem } from './side_nav_item';
import { OuiButtonEmpty } from '../button';
import { OuiTitle } from '../title';
import { OuiScreenReaderOnly } from '../accessibility';
import { htmlIdGenerator } from '../../services';
import { OuiHideFor, OuiShowFor } from '../responsive';
export var OuiSideNav = /*#__PURE__*/function (_Component) {
  _inherits(OuiSideNav, _Component);
  var _super = _createSuper(OuiSideNav);
  function OuiSideNav() {
    var _this;
    _classCallCheck(this, OuiSideNav);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "isItemOpen", function (item) {
      // The developer can force the item to be open.
      if (item.forceOpen) {
        return true;
      }

      // Of course a selected item is open.
      if (item.isSelected) {
        return true;
      }

      // The item has to be open if it has a child that's open.
      if (item.items) {
        return item.items.some(_this.isItemOpen);
      }
      return false;
    });
    _defineProperty(_assertThisInitialized(_this), "renderTree", function (items) {
      var depth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var _this$props = _this.props,
        renderItem = _this$props.renderItem,
        truncate = _this$props.truncate;
      return items.map(function (item) {
        var id = item.id,
          name = item.name,
          isSelected = item.isSelected,
          childItems = item.items,
          icon = item.icon,
          onClick = item.onClick,
          href = item.href,
          forceOpen = item.forceOpen,
          rest = _objectWithoutProperties(item, ["id", "name", "isSelected", "items", "icon", "onClick", "href", "forceOpen"]); // Root items are always open.
        var isOpen = depth === 0 ? true : _this.isItemOpen(item);
        var renderedItems;
        if (childItems) {
          renderedItems = _this.renderTree(childItems, depth + 1);
        }

        // Act as an accordion only if item is not linked but has children (and not the root)
        var childrenOnly = depth > 0 && !onClick && !href && !!childItems;
        return /*#__PURE__*/React.createElement(OuiSideNavItem, _extends({
          isOpen: isOpen,
          isSelected: !childrenOnly && isSelected,
          isParent: !!childItems,
          icon: icon,
          onClick: onClick,
          href: href,
          items: renderedItems,
          key: id,
          depth: depth,
          renderItem: renderItem,
          truncate: truncate,
          childrenOnly: childrenOnly
        }, rest), name);
      });
    });
    return _this;
  }
  _createClass(OuiSideNav, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        className = _this$props2.className,
        items = _this$props2.items,
        toggleOpenOnMobile = _this$props2.toggleOpenOnMobile,
        isOpenOnMobile = _this$props2.isOpenOnMobile,
        mobileTitle = _this$props2.mobileTitle,
        mobileBreakpoints = _this$props2.mobileBreakpoints,
        renderItem = _this$props2.renderItem,
        truncate = _this$props2.truncate,
        heading = _this$props2.heading,
        _this$props2$headingP = _this$props2.headingProps,
        headingProps = _this$props2$headingP === void 0 ? {} : _this$props2$headingP,
        rest = _objectWithoutProperties(_this$props2, ["className", "items", "toggleOpenOnMobile", "isOpenOnMobile", "mobileTitle", "mobileBreakpoints", "renderItem", "truncate", "heading", "headingProps"]);
      var classes = classNames('ouiSideNav', className, {
        'ouiSideNav-isOpenMobile': isOpenOnMobile
      });

      // To support the extra CSS needed to show/hide/animate the content,
      // We add a className for every breakpoint supported
      var contentClasses = classNames('ouiSideNav__content', mobileBreakpoints === null || mobileBreakpoints === void 0 ? void 0 : mobileBreakpoints.map(function (breakpointName) {
        return "ouiSideNav__contentMobile-".concat(breakpointName);
      }));
      var sideNavContentId = htmlIdGenerator('ouiSideNavContent')();
      var navContent = /*#__PURE__*/React.createElement("div", {
        id: sideNavContentId,
        className: contentClasses
      }, this.renderTree(items));
      var _ref = headingProps,
        _ref$screenReaderOnly = _ref.screenReaderOnly,
        headingScreenReaderOnly = _ref$screenReaderOnly === void 0 ? false : _ref$screenReaderOnly,
        _ref$element = _ref.element,
        HeadingElement = _ref$element === void 0 ? 'h2' : _ref$element,
        titleProps = _objectWithoutProperties(_ref, ["screenReaderOnly", "element"]);
      var hasMobileVersion = mobileBreakpoints && mobileBreakpoints.length > 0;
      var hasHeader = !!heading;
      var headingNode;
      var sharedHeadingProps = {
        id: (headingProps === null || headingProps === void 0 ? void 0 : headingProps.id) || htmlIdGenerator('ouiSideNavHeading')(),
        className: headingProps === null || headingProps === void 0 ? void 0 : headingProps.className,
        'data-test-subj': headingProps === null || headingProps === void 0 ? void 0 : headingProps['data-test-subj'],
        'aria-label': headingProps === null || headingProps === void 0 ? void 0 : headingProps['aria-label']
      };
      if (hasHeader) {
        headingNode = /*#__PURE__*/React.createElement(HeadingElement, sharedHeadingProps, heading);
        if (headingScreenReaderOnly) {
          headingNode = /*#__PURE__*/React.createElement(OuiScreenReaderOnly, null, headingNode);
        } else {
          headingNode = /*#__PURE__*/React.createElement(OuiTitle, _extends({
            size: "xs"
          }, titleProps, {
            className: classNames('ouiSideNav__heading', headingProps === null || headingProps === void 0 ? void 0 : headingProps.className)
          }), /*#__PURE__*/React.createElement(HeadingElement, sharedHeadingProps, heading));
        }
      }
      var mobileNode;
      var breakpoints = mobileBreakpoints;
      if (hasMobileVersion) {
        mobileNode = /*#__PURE__*/React.createElement(OuiShowFor, {
          sizes: breakpoints || 'none'
        }, /*#__PURE__*/React.createElement("nav", _extends({
          "aria-labelledby": sharedHeadingProps.id,
          className: classes
        }, rest), /*#__PURE__*/React.createElement(HeadingElement, sharedHeadingProps, /*#__PURE__*/React.createElement(OuiButtonEmpty, {
          className: "ouiSideNav__mobileToggle",
          textProps: {
            className: 'ouiSideNav__mobileToggleText'
          },
          contentProps: {
            className: 'ouiSideNav__mobileToggleContent'
          },
          onClick: toggleOpenOnMobile,
          iconType: "apps",
          iconSide: "right",
          "aria-controls": sideNavContentId,
          "aria-expanded": isOpenOnMobile
        }, mobileTitle || heading)), navContent));
      }
      return /*#__PURE__*/React.createElement(React.Fragment, null, mobileNode, /*#__PURE__*/React.createElement(OuiHideFor, {
        sizes: breakpoints || 'none'
      }, /*#__PURE__*/React.createElement("nav", _extends({
        "aria-labelledby": headingNode ? sharedHeadingProps.id : undefined,
        className: classes
      }, rest), headingNode, navContent)));
    }
  }]);
  return OuiSideNav;
}(Component);

/* OUI -> EUI Aliases: Build-Time */
_defineProperty(OuiSideNav, "defaultProps", {
  items: [],
  mobileBreakpoints: ['xs', 's']
});
OuiSideNav.propTypes = {
  /**
       * Class names to be merged into the final `className` property.
       */
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
       * Creates an associated heading element and uses the same node as default for `mobileTitle`
       */
  heading: PropTypes.node,
  /**
       * Adds a couple extra #OuiSideNavHeading props and extends the props of OuiTitle that wraps the `heading`
       */
  headingProps: PropTypes.shape({
    /**
       * The actual HTML heading element to wrap the `heading`.
       * Default is `h2`
       */
    element: PropTypes.oneOf(["h1", "h2", "h3", "h4", "h5", "h6", "span"]),
    /**
       * For best accessibility, `<nav>` elements should have a nested heading. But you can hide this element if it's redundent from something else (except on mobile).
       */
    screenReaderOnly: PropTypes.bool
  }),
  /**
       * When called, toggles visibility of the navigation menu at mobile responsive widths. The callback should set the `isOpenOnMobile` prop to actually toggle navigation visibility.
       */
  toggleOpenOnMobile: PropTypes.func,
  /**
       * If `true`, the navigation menu will be open at mobile device widths. Use in conjunction with the `toggleOpenOnMobile` prop.
       */
  isOpenOnMobile: PropTypes.bool,
  /**
       * A React node to render at mobile responsive widths, representing the title of this navigation menu.
       */
  mobileTitle: PropTypes.node,
  /**
       * Array of breakpoint names for when to show the mobile version.
       * Set to `undefined` to remove responsive behavior
       */
  mobileBreakpoints: PropTypes.arrayOf(PropTypes.oneOf(["xs", "s", "m", "l", "xl", "xxl", "xxxl"]).isRequired),
  /**
       *  An array of #OuiSideNavItem objects. Lists navigation menu items.
       */
  items: PropTypes.arrayOf(PropTypes.shape({
    /**
       * A value that is passed to React as the `key` for this item
       */
    id: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired]).isRequired,
    /**
       * If set to true it will force the item to display in an "open" state at all times.
       */
    forceOpen: PropTypes.bool,
    /**
       * Array containing additional item objects, representing nested children of this navigation item.
       */
    items: PropTypes.arrayOf(PropTypes.shape({
      /**
         * A value that is passed to React as the `key` for this item
         */
      id: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired]).isRequired,
      /**
         * If set to true it will force the item to display in an "open" state at all times.
         */
      forceOpen: PropTypes.bool,
      /**
         * Array containing additional item objects, representing nested children of this navigation item.
         */
      items: PropTypes.arrayOf(PropTypes.any.isRequired),
      /**
         * React node representing the text to render for this item (usually a string will suffice).
         */
      name: PropTypes.node.isRequired,
      /**
         * Function overriding default rendering for this navigation item — when called, it should return a React node representing a replacement navigation item.
         */
      renderItem: PropTypes.func
    }).isRequired),
    /**
       * React node representing the text to render for this item (usually a string will suffice).
       */
    name: PropTypes.node.isRequired,
    /**
       * Function overriding default rendering for this navigation item — when called, it should return a React node representing a replacement navigation item.
       */
    renderItem: PropTypes.func
  }).isRequired).isRequired,
  /**
       * Overrides default navigation menu item rendering. When called, it should return a React node representing a replacement navigation item.
       */
  renderItem: PropTypes.func,
  /**
       * Truncates the text of all items to stick to a single line
       */
  truncate: PropTypes.bool
};
/* OUI -> EUI Aliases: Build-Time */export { EuiSideNav } from '../../eui_components/side_nav/side_nav';