/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.memoryoptsearch.optimistic;

import java.util.List;
import lombok.Generated;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.hnsw.FloatHeap;
import org.opensearch.knn.index.query.PerLeafResult;

public final class OptimisticSearchStrategyUtils {
    public static float findKthLargestScore(List<PerLeafResult> results, int k, int totalResults) {
        if (totalResults <= 0) {
            throw new IllegalArgumentException("Total results must be greater than zero, got=" + totalResults);
        }
        if (k <= 0) {
            throw new IllegalArgumentException("K must be greater than zero, got=" + k);
        }
        if (totalResults <= k) {
            float min = Float.MAX_VALUE;
            for (PerLeafResult result : results) {
                for (ScoreDoc scoreDoc : result.getResult().scoreDocs) {
                    if (!(scoreDoc.score < min)) continue;
                    min = scoreDoc.score;
                }
            }
            return min;
        }
        FloatHeap floatHeap = new FloatHeap(k);
        int[] indices = new int[results.size()];
        int visited = 0;
        int maxI = totalResults * results.size();
        for (int i = 0; visited < totalResults && i < maxI; ++i) {
            int resultIndex = i % indices.length;
            int scoreIndex = indices[resultIndex];
            ScoreDoc[] scoreDocs = results.get((int)resultIndex).getResult().scoreDocs;
            if (scoreIndex >= scoreDocs.length) continue;
            floatHeap.offer(scoreDocs[scoreIndex].score);
            ++visited;
            indices[resultIndex] = scoreIndex + 1;
        }
        return floatHeap.peek();
    }

    @Generated
    private OptimisticSearchStrategyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

