﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/OrganizationScanEc2InstanceWithFindings.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Organization-wide Malware Protection configurations.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/OrganizationMalwareProtectionConfiguration">AWS
 * API Reference</a></p>
 */
class OrganizationMalwareProtectionConfiguration {
 public:
  AWS_GUARDDUTY_API OrganizationMalwareProtectionConfiguration() = default;
  AWS_GUARDDUTY_API OrganizationMalwareProtectionConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API OrganizationMalwareProtectionConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Whether Malware Protection for EC2 instances with findings should be
   * auto-enabled for new members joining the organization.</p>
   */
  inline const OrganizationScanEc2InstanceWithFindings& GetScanEc2InstanceWithFindings() const { return m_scanEc2InstanceWithFindings; }
  inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }
  template <typename ScanEc2InstanceWithFindingsT = OrganizationScanEc2InstanceWithFindings>
  void SetScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsT&& value) {
    m_scanEc2InstanceWithFindingsHasBeenSet = true;
    m_scanEc2InstanceWithFindings = std::forward<ScanEc2InstanceWithFindingsT>(value);
  }
  template <typename ScanEc2InstanceWithFindingsT = OrganizationScanEc2InstanceWithFindings>
  OrganizationMalwareProtectionConfiguration& WithScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsT&& value) {
    SetScanEc2InstanceWithFindings(std::forward<ScanEc2InstanceWithFindingsT>(value));
    return *this;
  }
  ///@}
 private:
  OrganizationScanEc2InstanceWithFindings m_scanEc2InstanceWithFindings;
  bool m_scanEc2InstanceWithFindingsHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
