﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/network-firewall/NetworkFirewall_EXPORTS.h>
#include <aws/network-firewall/model/RuleGroupType.h>
#include <aws/network-firewall/model/StatefulRuleOptions.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace NetworkFirewall {
namespace Model {
class DescribeRuleGroupMetadataResult {
 public:
  AWS_NETWORKFIREWALL_API DescribeRuleGroupMetadataResult() = default;
  AWS_NETWORKFIREWALL_API DescribeRuleGroupMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_NETWORKFIREWALL_API DescribeRuleGroupMetadataResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The descriptive name of the rule group. You can't change the name of a rule
   * group after you create it.</p> <p>You must specify the ARN or the name, and you
   * can specify both. </p>
   */
  inline const Aws::String& GetRuleGroupArn() const { return m_ruleGroupArn; }
  template <typename RuleGroupArnT = Aws::String>
  void SetRuleGroupArn(RuleGroupArnT&& value) {
    m_ruleGroupArnHasBeenSet = true;
    m_ruleGroupArn = std::forward<RuleGroupArnT>(value);
  }
  template <typename RuleGroupArnT = Aws::String>
  DescribeRuleGroupMetadataResult& WithRuleGroupArn(RuleGroupArnT&& value) {
    SetRuleGroupArn(std::forward<RuleGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The descriptive name of the rule group. You can't change the name of a rule
   * group after you create it.</p> <p>You must specify the ARN or the name, and you
   * can specify both. </p>
   */
  inline const Aws::String& GetRuleGroupName() const { return m_ruleGroupName; }
  template <typename RuleGroupNameT = Aws::String>
  void SetRuleGroupName(RuleGroupNameT&& value) {
    m_ruleGroupNameHasBeenSet = true;
    m_ruleGroupName = std::forward<RuleGroupNameT>(value);
  }
  template <typename RuleGroupNameT = Aws::String>
  DescribeRuleGroupMetadataResult& WithRuleGroupName(RuleGroupNameT&& value) {
    SetRuleGroupName(std::forward<RuleGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Returns the metadata objects for the specified rule group. </p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeRuleGroupMetadataResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether the rule group is stateless or stateful. If the rule group
   * is stateless, it contains stateless rules. If it is stateful, it contains
   * stateful rules. </p>  <p>This setting is required for requests that do not
   * include the <code>RuleGroupARN</code>.</p>
   */
  inline RuleGroupType GetType() const { return m_type; }
  inline void SetType(RuleGroupType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline DescribeRuleGroupMetadataResult& WithType(RuleGroupType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum operating resources that this rule group can use. Rule group
   * capacity is fixed at creation. When you update a rule group, you are limited to
   * this capacity. When you reference a rule group from a firewall policy, Network
   * Firewall reserves this capacity for the rule group. </p> <p>You can retrieve the
   * capacity that would be required for a rule group before you create the rule
   * group by calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to
   * <code>TRUE</code>. </p>
   */
  inline int GetCapacity() const { return m_capacity; }
  inline void SetCapacity(int value) {
    m_capacityHasBeenSet = true;
    m_capacity = value;
  }
  inline DescribeRuleGroupMetadataResult& WithCapacity(int value) {
    SetCapacity(value);
    return *this;
  }
  ///@}

  ///@{

  inline const StatefulRuleOptions& GetStatefulRuleOptions() const { return m_statefulRuleOptions; }
  template <typename StatefulRuleOptionsT = StatefulRuleOptions>
  void SetStatefulRuleOptions(StatefulRuleOptionsT&& value) {
    m_statefulRuleOptionsHasBeenSet = true;
    m_statefulRuleOptions = std::forward<StatefulRuleOptionsT>(value);
  }
  template <typename StatefulRuleOptionsT = StatefulRuleOptions>
  DescribeRuleGroupMetadataResult& WithStatefulRuleOptions(StatefulRuleOptionsT&& value) {
    SetStatefulRuleOptions(std::forward<StatefulRuleOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A timestamp indicating when the rule group was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  DescribeRuleGroupMetadataResult& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeRuleGroupMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_ruleGroupArn;
  bool m_ruleGroupArnHasBeenSet = false;

  Aws::String m_ruleGroupName;
  bool m_ruleGroupNameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  RuleGroupType m_type{RuleGroupType::NOT_SET};
  bool m_typeHasBeenSet = false;

  int m_capacity{0};
  bool m_capacityHasBeenSet = false;

  StatefulRuleOptions m_statefulRuleOptions;
  bool m_statefulRuleOptionsHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace NetworkFirewall
}  // namespace Aws
