﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/client/GenericClientConfiguration.h>
#include <aws/core/endpoint/DefaultEndpointProvider.h>
#include <aws/core/endpoint/EndpointParameter.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/RedshiftEndpointRules.h>
#include <aws/redshift/Redshift_EXPORTS.h>

namespace Aws {
namespace Redshift {
namespace Endpoint {
using EndpointParameters = Aws::Endpoint::EndpointParameters;
using Aws::Endpoint::DefaultEndpointProvider;
using Aws::Endpoint::EndpointProviderBase;

using RedshiftClientContextParameters = Aws::Endpoint::ClientContextParameters;

using RedshiftClientConfiguration = Aws::Client::GenericClientConfiguration;
using RedshiftBuiltInParameters = Aws::Endpoint::BuiltInParameters;

/**
 * The type for the Redshift Client Endpoint Provider.
 * Inherit from this Base class / "Interface" should you want to provide a custom endpoint provider.
 * The SDK must use service-specific type for each service per specification.
 */
using RedshiftEndpointProviderBase =
    EndpointProviderBase<RedshiftClientConfiguration, RedshiftBuiltInParameters, RedshiftClientContextParameters>;

using RedshiftDefaultEpProviderBase =
    DefaultEndpointProvider<RedshiftClientConfiguration, RedshiftBuiltInParameters, RedshiftClientContextParameters>;

/**
 * Default endpoint provider used for this service
 */
class AWS_REDSHIFT_API RedshiftEndpointProvider : public RedshiftDefaultEpProviderBase {
 public:
  using RedshiftResolveEndpointOutcome = Aws::Endpoint::ResolveEndpointOutcome;

  RedshiftEndpointProvider()
      : RedshiftDefaultEpProviderBase(Aws::Redshift::RedshiftEndpointRules::GetRulesBlob(),
                                      Aws::Redshift::RedshiftEndpointRules::RulesBlobSize) {}

  ~RedshiftEndpointProvider() {}
};
}  // namespace Endpoint
}  // namespace Redshift
}  // namespace Aws
