﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker-featurestore-runtime/SageMakerFeatureStoreRuntime_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMakerFeatureStoreRuntime {
namespace Model {

/**
 * <p>The error that has occurred when attempting to retrieve a batch of
 * Records.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/BatchGetRecordError">AWS
 * API Reference</a></p>
 */
class BatchGetRecordError {
 public:
  AWS_SAGEMAKERFEATURESTORERUNTIME_API BatchGetRecordError() = default;
  AWS_SAGEMAKERFEATURESTORERUNTIME_API BatchGetRecordError(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKERFEATURESTORERUNTIME_API BatchGetRecordError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKERFEATURESTORERUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the feature group that the record belongs to.</p>
   */
  inline const Aws::String& GetFeatureGroupName() const { return m_featureGroupName; }
  inline bool FeatureGroupNameHasBeenSet() const { return m_featureGroupNameHasBeenSet; }
  template <typename FeatureGroupNameT = Aws::String>
  void SetFeatureGroupName(FeatureGroupNameT&& value) {
    m_featureGroupNameHasBeenSet = true;
    m_featureGroupName = std::forward<FeatureGroupNameT>(value);
  }
  template <typename FeatureGroupNameT = Aws::String>
  BatchGetRecordError& WithFeatureGroupName(FeatureGroupNameT&& value) {
    SetFeatureGroupName(std::forward<FeatureGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value for the <code>RecordIdentifier</code> in string format of a Record
   * from a <code>FeatureGroup</code> that is causing an error when attempting to be
   * retrieved.</p>
   */
  inline const Aws::String& GetRecordIdentifierValueAsString() const { return m_recordIdentifierValueAsString; }
  inline bool RecordIdentifierValueAsStringHasBeenSet() const { return m_recordIdentifierValueAsStringHasBeenSet; }
  template <typename RecordIdentifierValueAsStringT = Aws::String>
  void SetRecordIdentifierValueAsString(RecordIdentifierValueAsStringT&& value) {
    m_recordIdentifierValueAsStringHasBeenSet = true;
    m_recordIdentifierValueAsString = std::forward<RecordIdentifierValueAsStringT>(value);
  }
  template <typename RecordIdentifierValueAsStringT = Aws::String>
  BatchGetRecordError& WithRecordIdentifierValueAsString(RecordIdentifierValueAsStringT&& value) {
    SetRecordIdentifierValueAsString(std::forward<RecordIdentifierValueAsStringT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error code of an error that has occurred when attempting to retrieve a
   * batch of Records. For more information on errors, see <a
   * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_GetRecord.html#API_feature_store_GetRecord_Errors">Errors</a>.</p>
   */
  inline const Aws::String& GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  template <typename ErrorCodeT = Aws::String>
  void SetErrorCode(ErrorCodeT&& value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = std::forward<ErrorCodeT>(value);
  }
  template <typename ErrorCodeT = Aws::String>
  BatchGetRecordError& WithErrorCode(ErrorCodeT&& value) {
    SetErrorCode(std::forward<ErrorCodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error message of an error that has occurred when attempting to retrieve a
   * record in the batch.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  BatchGetRecordError& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_featureGroupName;
  bool m_featureGroupNameHasBeenSet = false;

  Aws::String m_recordIdentifierValueAsString;
  bool m_recordIdentifierValueAsStringHasBeenSet = false;

  Aws::String m_errorCode;
  bool m_errorCodeHasBeenSet = false;

  Aws::String m_errorMessage;
  bool m_errorMessageHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMakerFeatureStoreRuntime
}  // namespace Aws
