/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ocient;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.ext.ocient.model.OcientDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OcientDataSourceProvider
extends GenericDataSourceProvider {
    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new OcientDataSource(monitor, container);
    }

    @NotNull
    public String getConnectionURL(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:ocient://").append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append("/").append(connectionInfo.getDatabaseName());
        }
        return url.toString();
    }
}

