/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.internal.registry;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.navigator.INavigatorNodeActionHandler;
import org.jkiss.utils.CommonUtils;

public class NavigatorNodeActionDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.navigator.nodeAction";
    private final AbstractDescriptor.ObjectType implType;
    private final int order;
    private final Expression enablementExpression;
    private INavigatorNodeActionHandler instance;

    NavigatorNodeActionDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        this.enablementExpression = NavigatorNodeActionDescriptor.getEnablementExpression((IConfigurationElement)config);
    }

    @NotNull
    public INavigatorNodeActionHandler getHandler() {
        if (this.instance == null) {
            try {
                this.instance = (INavigatorNodeActionHandler)this.implType.createInstance(INavigatorNodeActionHandler.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.instance;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean appliesTo(@NotNull DBPObject object) {
        return object != null && NavigatorNodeActionDescriptor.isExpressionTrue((Expression)this.enablementExpression, (Object)object) && this.appliesTo(object, null);
    }

    public String toString() {
        return this.implType.getImplName();
    }
}

