/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourcePageDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;

public class DataSourceViewRegistry {
    private static DataSourceViewRegistry instance = null;
    private final List<DataSourceViewDescriptor> views = new ArrayList<DataSourceViewDescriptor>();
    private final List<DataSourceConfiguratorDescriptor> configurators = new ArrayList<DataSourceConfiguratorDescriptor>();

    public static synchronized DataSourceViewRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceViewRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataSourceViewRegistry(IExtensionRegistry registry) {
        for (IConfigurationElement viewElement : registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceView")) {
            if (!viewElement.getName().equals("view")) continue;
            this.views.add(new DataSourceViewDescriptor(viewElement));
        }
        for (IConfigurationElement cfgElement : registry.getConfigurationElementsFor("org.jkiss.dbeaver.ui.dataSourceConfigurator")) {
            if (!cfgElement.getName().equals("dataSourceConfigurator")) continue;
            this.configurators.add(new DataSourceConfiguratorDescriptor(cfgElement));
        }
    }

    public DataSourceViewDescriptor findView(DBPDataSourceProviderDescriptor provider, String targetID) {
        for (DBPDataSourceProviderDescriptor pd = provider; pd != null; pd = pd.getParentProvider()) {
            for (DataSourceViewDescriptor view : this.views) {
                if (!view.getDataSources().contains(pd.getId()) || !targetID.equals(view.getTargetID())) continue;
                return view;
            }
        }
        return null;
    }

    public List<DataSourceViewDescriptor> getViews(DBPDataSourceProviderDescriptor provider, String targetID) {
        ArrayList<DataSourceViewDescriptor> result = new ArrayList<DataSourceViewDescriptor>();
        for (DBPDataSourceProviderDescriptor pd = provider; pd != null; pd = pd.getParentProvider()) {
            for (DataSourceViewDescriptor view : this.views) {
                if (!view.getDataSources().contains(pd.getId()) || !targetID.equals(view.getTargetID())) continue;
                result.add(view);
            }
        }
        return result;
    }

    public List<DataSourceConfiguratorDescriptor> getConfigurators(DBPDataSourceContainer dataSourceContainer) {
        ArrayList<DataSourceConfiguratorDescriptor> result = new ArrayList<DataSourceConfiguratorDescriptor>();
        for (DataSourceConfiguratorDescriptor configuratorDesc : this.configurators) {
            if (!configuratorDesc.appliesTo(dataSourceContainer)) continue;
            result.add(configuratorDesc);
        }
        return result;
    }

    public List<DataSourcePageDescriptor> getRootDataSourcePages(DataSourceDescriptor dataSource) {
        ArrayList<DataSourcePageDescriptor> roots = new ArrayList<DataSourcePageDescriptor>();
        for (DataSourceConfiguratorDescriptor configurator : this.getConfigurators((DBPDataSourceContainer)dataSource)) {
            roots.addAll(configurator.getRootPages((DBPDataSourceContainer)dataSource));
        }
        return this.sortPages(roots);
    }

    public List<DataSourcePageDescriptor> getChildDataSourcePages(DBPDataSourceContainer dataSource, String parentId) {
        ArrayList<DataSourcePageDescriptor> children = new ArrayList<DataSourcePageDescriptor>();
        for (DataSourceConfiguratorDescriptor configurator : this.getConfigurators(dataSource)) {
            children.addAll(configurator.getChildPages(dataSource, parentId));
        }
        return this.sortPages(children);
    }

    private List<DataSourcePageDescriptor> sortPages(List<DataSourcePageDescriptor> pages) {
        pages.sort((o1, o2) -> {
            if (o1.getId().equals(o2.getAfterPageId())) {
                return -1;
            }
            if (o2.getId().equals(o1.getAfterPageId())) {
                return 1;
            }
            return 0;
        });
        return pages;
    }
}

