/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.app.DBPApplicationController;
import org.jkiss.dbeaver.model.app.DBPApplicationDesktop;
import org.jkiss.dbeaver.model.app.DBPGlobalEventManager;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.impl.app.BaseApplicationImpl;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DesktopNavigatorModel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMRegistry;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;
import org.jkiss.dbeaver.registry.BasePlatformImpl;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.GlobalEventManagerImpl;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.SecurityProviderUtils;
import org.jkiss.dbeaver.runtime.qm.QMLogFileWriter;
import org.jkiss.dbeaver.runtime.qm.QMRegistryImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class DesktopPlatform
extends BasePlatformImpl
implements DBPPlatformDesktop {
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.core";
    private static final String TEMP_PROJECT_NAME = ".dbeaver-temp";
    private static final String DBEAVER_CONFIG_FOLDER = "settings";
    private static final Log log = Log.getLog(DesktopPlatform.class);
    static DesktopPlatform instance;
    private static volatile boolean isClosing;
    private Path tempFolder;
    private DBPWorkspaceDesktop workspace;
    private QMRegistryImpl queryManager;
    private QMLogFileWriter qmLogWriter;
    private DBACertificateStorage certificateStorage;
    private volatile boolean workbenchStarted;

    public static boolean isStandalone() {
        return BaseApplicationImpl.getInstance().isStandalone();
    }

    public static boolean isClosing() {
        if (isClosing) {
            return true;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        return false;
    }

    static void setClosing(boolean closing) {
        isClosing = closing;
    }

    public DesktopPlatform() {
        instance = this;
    }

    protected void initialize() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Initialize desktop platform...");
        if (this.getPreferenceStore().getBoolean("security.jce.bc")) {
            SecurityProviderUtils.registerSecurityProvider();
        }
        this.certificateStorage = new DefaultCertificateStorage(RuntimeUtils.getPluginStateLocation((Plugin)DBeaverActivator.getInstance()).resolve("security"));
        this.getApplication().beforeWorkspaceInitialization();
        this.workspace = this.getApplication().createWorkspace((DBPPlatform)this);
        this.workspace.initializeProjects();
        QMUtils.initApplication((DBPPlatform)this);
        this.queryManager = new QMRegistryImpl();
        this.qmLogWriter = new QMLogFileWriter();
        this.queryManager.registerMetaListener((QMMetaListener)this.qmLogWriter);
        super.initialize();
        DBRFeatureRegistry.getInstance().startTracking();
        log.debug((Object)("Platform initialized (" + (System.currentTimeMillis() - startTime) + "ms)"));
    }

    protected DBNModel createNavigatorModel() {
        return new DesktopNavigatorModel((DBPPlatform)this, null);
    }

    public synchronized void dispose() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Shutdown desktop platform...");
        DesktopPlatform.setClosing(true);
        DBPApplicationDesktop application = this.getApplication();
        if (application instanceof DBPApplicationController) {
            DBPApplicationController ac = (DBPApplicationController)application;
            ac.setHeadlessMode(true);
        }
        DBRFeatureRegistry.getInstance().endTracking();
        super.dispose();
        if (this.workspace != null) {
            this.workspace.dispose();
            this.workspace = null;
        }
        if (this.qmLogWriter != null) {
            this.queryManager.unregisterMetaListener((QMMetaListener)this.qmLogWriter);
            this.qmLogWriter.dispose();
            this.qmLogWriter = null;
        }
        if (this.queryManager != null) {
            this.queryManager.dispose();
        }
        DataSourceProviderRegistry.dispose();
        if (DesktopPlatform.isStandalone() && this.workspace != null && !application.isExclusiveMode()) {
            try {
                this.workspace.save((DBRProgressMonitor)new LoggingProgressMonitor(log));
            }
            catch (DBException ex) {
                log.error((Object)"Can not save workspace", (Throwable)ex);
            }
        }
        if (this.tempFolder != null) {
            if (!ContentUtils.deleteFileRecursive((Path)this.tempFolder)) {
                log.warn((Object)("Can not delete temp folder '" + String.valueOf(this.tempFolder) + "'"));
            }
            this.tempFolder = null;
        }
        instance = null;
        System.gc();
        log.debug((Object)("Platform shutdown completed (" + (System.currentTimeMillis() - startTime) + "ms)"));
        new Thread(() -> {
            RuntimeUtils.pause((int)10000);
            System.out.println("App shutdown was halted. Force system shutdown!");
            System.exit(-2);
        }).start();
    }

    protected Plugin getProductPlugin() {
        return DBeaverActivator.getInstance();
    }

    @NotNull
    public DBPWorkspaceDesktop getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public DBPApplicationDesktop getApplication() {
        return (DBPApplicationDesktop)BaseApplicationImpl.getInstance();
    }

    @NotNull
    public QMRegistry getQueryManager() {
        return this.queryManager;
    }

    @NotNull
    public DBPGlobalEventManager getGlobalEventManager() {
        return GlobalEventManagerImpl.getInstance();
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return this.getApplication().getPreferenceStore();
    }

    @NotNull
    public DBACertificateStorage getCertificateStorage() {
        return this.certificateStorage;
    }

    @NotNull
    public DBPExternalFileManager getExternalFileManager() {
        return this.workspace;
    }

    public boolean isWorkbenchStarted() {
        return this.workbenchStarted || !this.getApplication().isStandalone();
    }

    public void setWorkbenchStarted(boolean started) {
        this.workbenchStarted = started;
    }

    @NotNull
    public Path getTempFolder(@NotNull DBRProgressMonitor monitor, @NotNull String name) {
        Path localTemp;
        block14: {
            if (this.tempFolder == null) {
                try {
                    String tempFolderPath = System.getProperty("dbeaver.io.tmpdir");
                    if (!CommonUtils.isEmpty((String)tempFolderPath)) {
                        File dbTempFolder = new File(tempFolderPath = GeneralUtils.replaceVariables((String)tempFolderPath, (IVariableResolver)new SystemVariablesResolver()));
                        if (!dbTempFolder.mkdirs()) {
                            throw new IOException("Can't create temp directory '" + dbTempFolder.getAbsolutePath() + "'");
                        }
                    } else {
                        tempFolderPath = System.getProperty("java.io.tmpdir");
                    }
                    monitor.subTask("Create temp folder '" + tempFolderPath + "'");
                    Path tmpFolder = Paths.get(tempFolderPath, new String[0]);
                    if (!Files.exists(tmpFolder, new LinkOption[0])) {
                        log.debug((Object)("Create global temp folder '" + String.valueOf(tmpFolder) + "'"));
                        Files.createDirectories(tmpFolder, new FileAttribute[0]);
                    }
                    this.tempFolder = Files.createTempDirectory(tmpFolder, TEMP_PROJECT_NAME, new FileAttribute[0]);
                }
                catch (IOException e) {
                    String sysTempFolder = System.getProperty("java.io.tmpdir");
                    if (CommonUtils.isEmpty((String)sysTempFolder)) break block14;
                    this.tempFolder = Path.of(sysTempFolder, new String[0]).resolve(TEMP_PROJECT_NAME);
                    if (Files.exists(this.tempFolder, new LinkOption[0])) break block14;
                    try {
                        Files.createDirectories(this.tempFolder, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        String sysUserFolder = System.getProperty("user.home");
                        if (CommonUtils.isEmpty((String)sysUserFolder)) break block14;
                        this.tempFolder = Path.of(sysUserFolder, new String[0]).resolve(TEMP_PROJECT_NAME);
                        if (Files.exists(this.tempFolder, new LinkOption[0])) break block14;
                        try {
                            Files.createDirectories(this.tempFolder, new FileAttribute[0]);
                        }
                        catch (IOException exc) {
                            this.tempFolder = Path.of(TEMP_PROJECT_NAME, new String[0]);
                        }
                    }
                }
            }
        }
        Path path = localTemp = name == null ? this.tempFolder : this.tempFolder.resolve(name);
        if (!Files.exists(localTemp, new LinkOption[0])) {
            try {
                Files.createDirectories(localTemp, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Can't create temp directory " + String.valueOf(localTemp)), (Throwable)e);
            }
        }
        return localTemp;
    }

    public boolean isShuttingDown() {
        return DesktopPlatform.isClosing();
    }

    static {
        isClosing = false;
    }
}

