/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import org.cugos.wkg.Geometry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.gis.handlers.WKGUtils;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.gis.GisTransformRequest;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.model.gis.SpatialDataProvider;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.gis.GeometryDataUtils;
import org.jkiss.dbeaver.ui.gis.IGeometryValueEditor;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.gis.internal.GISViewerActivator;
import org.jkiss.dbeaver.ui.gis.panel.DBDContentAdapter;
import org.jkiss.dbeaver.ui.gis.panel.GISBrowserImageUtils;
import org.jkiss.dbeaver.ui.gis.panel.GISBrowserViewerConstants;
import org.jkiss.dbeaver.ui.gis.panel.GISEditorUtils;
import org.jkiss.dbeaver.ui.gis.panel.SelectCRSAction;
import org.jkiss.dbeaver.ui.gis.panel.SelectTilesAction;
import org.jkiss.dbeaver.ui.gis.panel.actions.ToggleLabelsAction;
import org.jkiss.dbeaver.ui.gis.registry.GeometryViewerRegistry;
import org.jkiss.dbeaver.ui.gis.registry.LeafletTilesDescriptor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class GISLeafletViewer
implements IGeometryValueEditor,
DBPPreferenceListener {
    private static final Log log = Log.getLog(GISLeafletViewer.class);
    private static final String PREF_RECENT_SRID_LIST = "srid.list.recent";
    private static final String[] SUPPORTED_FORMATS = new String[]{"png", "gif", "bmp"};
    private static final String PROP_FLIP_COORDINATES = "gis.flipCoords";
    private static final String PROP_SRID = "gis.srid";
    private static final int UNDEFINED_SRID = -1;
    private volatile boolean browserCreating = false;
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(DBDContent.class, (Object)new DBDContentAdapter()).create();
    private final DBDAttributeBinding[] bindings;
    private final IResultSetPresentation presentation;
    private Browser browser;
    private DBGeometry[] lastValue;
    private int sourceSRID = -1;
    private int actualSourceSRID;
    private Path scriptFile;
    private final Composite statusBar;
    private final ToolBarManager toolBarManager;
    private int defaultSRID;
    private boolean toolsVisible = true;
    private boolean showLabels;
    private boolean flipCoordinates = false;
    private final Composite composite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GISLeafletViewer(Composite parent, @NotNull DBDAttributeBinding[] bindings, @Nullable SpatialDataProvider spatialDataProvider, final @Nullable IResultSetPresentation presentation) {
        DBVEntityAttribute vAttr;
        DBVEntity vEntity;
        DBDAttributeBinding binding;
        this.bindings = bindings;
        this.presentation = presentation;
        this.flipCoordinates = spatialDataProvider != null && spatialDataProvider.isFlipCoordinates();
        this.composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        CSSUtils.markConnectionTypeColor((Widget)this.composite);
        this.browserCreating = true;
        try {
            this.browser = new Browser(this.composite, 0);
        }
        catch (SWTError error) {
            log.warn((Object)"Internal web browser initialization failed", (Throwable)error);
            this.browser = null;
            if (error.code != 20) {
                for (Control control : this.composite.getChildren()) {
                    control.dispose();
                }
                throw error;
            }
            this.browser = new Browser(this.composite, 65536);
        }
        finally {
            this.browserCreating = false;
        }
        if (this.browser != null) {
            this.browser.setLayoutData((Object)new GridData(1808));
            new BrowserFunction(this, this.browser, "setClipboardContents"){

                public Object function(Object[] arguments) {
                    UIUtils.setClipboardContents((Display)Display.getCurrent(), (Transfer)TextTransfer.getInstance(), (Object)arguments[0]);
                    return null;
                }
            };
            if (presentation instanceof SpreadsheetPresentation) {
                new BrowserFunction(this, this.browser, "setPresentationSelection"){

                    public Object function(Object[] arguments) {
                        ArrayList<GridPos> selection = new ArrayList<GridPos>();
                        for (Object pos : (Object[])arguments[0]) {
                            String[] split = ((String)pos).split(":");
                            selection.add(new GridPos(CommonUtils.toInt((Object)split[0]), CommonUtils.toInt((Object)split[1])));
                        }
                        ((AbstractPresentation)presentation).setSelection((ISelection)new StructuredSelection(selection), false);
                        return null;
                    }
                };
            }
            this.browser.addDisposeListener(e -> {
                this.cleanupFiles();
                GISViewerActivator.getDefault().getPreferences().removePropertyChangeListener((DBPPreferenceListener)this);
            });
        }
        this.statusBar = UIUtils.createPlaceholder((Composite)this.composite, (int)1);
        this.statusBar.setLayoutData((Object)new GridData(768));
        CSSUtils.markConnectionTypeColor((Widget)this.statusBar);
        ToolBar bottomToolbar = new ToolBar(this.statusBar, 8519936);
        this.toolBarManager = new ToolBarManager(bottomToolbar);
        DBPPreferenceStore preferences = GISViewerActivator.getDefault().getPreferences();
        String recentSRIDString = preferences.getString(PREF_RECENT_SRID_LIST);
        if (!CommonUtils.isEmpty((String)recentSRIDString)) {
            for (String sridStr : recentSRIDString.split(",")) {
                int recentSRID = CommonUtils.toInt((Object)sridStr);
                if (recentSRID == 0 || recentSRID == GeometryDataUtils.getDefaultSRID() || recentSRID == 3857) continue;
                GISEditorUtils.addRecentSRID(recentSRID);
            }
        }
        if ((binding = bindings[0]).getEntityAttribute() != null && (vEntity = DBVUtils.getVirtualEntity((DBDAttributeBinding)binding, (boolean)false)) != null && (vAttr = vEntity.getVirtualAttribute(binding, false)) != null) {
            this.flipCoordinates = CommonUtils.getBoolean((Object)vAttr.getProperty(PROP_FLIP_COORDINATES), (boolean)this.flipCoordinates);
            this.sourceSRID = CommonUtils.toInt((Object)vAttr.getProperty(PROP_SRID), (int)this.sourceSRID);
        }
        this.showLabels = preferences.getBoolean("gis.view.showLabels");
        preferences.addPropertyChangeListener((DBPPreferenceListener)this);
    }

    @Override
    public Control getEditorControl() {
        return this.composite;
    }

    @Override
    public int getValueSRID() {
        return this.actualSourceSRID;
    }

    @Override
    public void setValueSRID(int srid) {
        if (srid == this.sourceSRID) {
            // empty if block
        }
        int oldSRID = this.sourceSRID;
        this.sourceSRID = srid;
        try {
            this.reloadGeometryData(this.lastValue, true, true);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Setting SRID", "Can't change source SRID to " + srid, (Throwable)e);
            this.sourceSRID = oldSRID;
        }
        if (srid != GeometryDataUtils.getDefaultSRID() && srid != 3857) {
            GISEditorUtils.addRecentSRID(srid);
        }
        GISEditorUtils.curRecentSRIDs();
        StringBuilder sridListStr = new StringBuilder();
        for (Integer sridInt : GISEditorUtils.getRecentSRIDs()) {
            if (sridListStr.length() > 0) {
                sridListStr.append(",");
            }
            sridListStr.append(sridInt);
        }
        GISViewerActivator.getDefault().getPreferences().setValue(PREF_RECENT_SRID_LIST, sridListStr.toString());
        this.saveAttributeSettings();
    }

    @Override
    public void refresh() {
        try {
            this.reloadGeometryData(this.lastValue, true, false);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Refresh", "Can't refresh value viewer", (Throwable)e);
        }
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        if ("gis.view.showLabels".equals(event.getProperty())) {
            return;
        }
        this.refresh();
    }

    public void setGeometryData(@Nullable DBGeometry[] values) throws DBException {
        this.reloadGeometryData(values, false, true);
    }

    public void reloadGeometryData(@Nullable DBGeometry[] values, boolean force, boolean recenter) throws DBException {
        if (!force && CommonUtils.equalObjects((Object)this.lastValue, (Object)values)) {
            return;
        }
        int maxObjects = GISViewerActivator.getDefault().getPreferences().getInt("gis.view.maxObjectsRender");
        if (maxObjects <= 0) {
            maxObjects = 10000;
        }
        if (values != null && values.length > maxObjects) {
            DBGeometry[] truncValues = new DBGeometry[maxObjects];
            System.arraycopy(values, 0, truncValues, 0, maxObjects);
            values = truncValues;
        }
        if (this.browser != null) {
            try {
                if (ArrayUtils.isEmpty((Object[])values)) {
                    this.browser.setUrl("about:blank");
                } else {
                    Bounds bounds = recenter ? null : Bounds.tryExtractFromBrowser(this.browser);
                    Path file = this.generateViewScript(values, bounds);
                    this.browser.setUrl(file.toFile().toURI().toURL().toString());
                }
            }
            catch (IOException e) {
                throw new DBException("Error generating viewer script", (Throwable)e);
            }
        }
        this.lastValue = values;
        this.populateToolbar();
    }

    private Path generateViewScript(DBGeometry[] values, @Nullable Bounds bounds) throws IOException {
        String template;
        if (this.scriptFile == null) {
            Path tempDir = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "gis-viewer-files");
            this.checkIncludesExistence(tempDir);
            this.scriptFile = Files.createTempFile(tempDir, "view", "gis.html", new FileAttribute[0]);
        }
        int attributeSrid = -1;
        if (this.bindings[0].getAttribute() instanceof GisAttribute) {
            try {
                attributeSrid = ((GisAttribute)this.bindings[0].getAttribute()).getAttributeGeometrySRID((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
        ArrayList<CallSite> geomValues = new ArrayList<CallSite>();
        ArrayList<String> geomTipValues = new ArrayList<String>();
        boolean showMap = false;
        for (int i = 0; i < values.length; ++i) {
            int srid;
            DBGeometry value = values[i];
            if (DBUtils.isNullValue((Object)value)) continue;
            if (this.flipCoordinates) {
                try {
                    value = value.flipCoordinates();
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
            try {
                value = value.force2D();
            }
            catch (DBException e) {
                log.error((Object)"Error forcing geometry to 2D", (Throwable)e);
            }
            Object targetValue = value.getRawValue();
            if (WKGUtils.isCurve((Object)targetValue)) {
                targetValue = WKGUtils.linearize((Geometry)((Geometry)targetValue));
            }
            if ((srid = this.sourceSRID) == -1 && value.getSRID() != 0) {
                srid = value.getSRID();
            }
            if (srid == -1) {
                srid = attributeSrid;
            }
            if (srid == -1) {
                srid = GeometryDataUtils.getDefaultSRID();
            }
            if (srid == 0) {
                showMap = false;
                this.actualSourceSRID = srid;
            } else if (srid == 4326) {
                showMap = true;
                this.actualSourceSRID = srid;
            } else {
                org.locationtech.jts.geom.Geometry geometry = GisTransformUtils.getJtsGeometry((Object)targetValue);
                if (geometry != null) {
                    try {
                        GisTransformRequest request = new GisTransformRequest(geometry, srid, 4326);
                        GisTransformUtils.transformGisData((GisTransformRequest)request);
                        targetValue = request.getTargetValue();
                        srid = request.getTargetSRID();
                        this.actualSourceSRID = request.getSourceSRID();
                        showMap = request.isShowOnMap();
                    }
                    catch (DBException e) {
                        log.debug((Object)"Error transforming CRS", (Throwable)e);
                        this.actualSourceSRID = srid;
                        showMap = false;
                    }
                } else {
                    this.actualSourceSRID = srid;
                }
            }
            if (targetValue == null) continue;
            geomValues.add((CallSite)((Object)("'" + String.valueOf(targetValue) + "'")));
            try {
                if (CommonUtils.isEmpty((Map)value.getProperties())) {
                    geomTipValues.add("null");
                    continue;
                }
                geomTipValues.add(gson.toJson((Object)value.getProperties()));
                continue;
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        this.defaultSRID = this.actualSourceSRID;
        String geomValuesString = String.join((CharSequence)",", geomValues);
        String geomTipValuesString = String.join((CharSequence)",", geomTipValues);
        String geomCRS = this.actualSourceSRID == 0 ? "Simple" : "EPSG3857";
        boolean isShowMap = showMap;
        InputStream fis = GISViewerActivator.getDefault().getResourceStream("web/view_template.html");
        if (fis == null) {
            throw new IOException("View template file not found (web/view_template.html)");
        }
        try (InputStreamReader isr = new InputStreamReader(fis);){
            template = IOUtils.readToString((Reader)isr);
        }
        IVariableResolver resolver = name -> switch (name) {
            case "geomValues" -> CommonUtils.escapeHtml((String)geomValuesString);
            case "geomTipValues" -> CommonUtils.escapeHtml((String)geomTipValuesString);
            case "geomSRID" -> String.valueOf(this.defaultSRID);
            case "showMap" -> String.valueOf(isShowMap);
            case "showTools" -> String.valueOf(this.toolsVisible);
            case "showLabels" -> String.valueOf(this.showLabels);
            case "geomCRS" -> geomCRS;
            case "geomBounds" -> CommonUtils.toString((Object)bounds, (String)"undefined");
            case "minZoomLevel" -> {
                DBPPreferenceStore preferences = GISViewerActivator.getDefault().getPreferences();
                yield String.valueOf(preferences.getInt("gis.view.minZoomLevel"));
            }
            case "defaultTiles" -> {
                LeafletTilesDescriptor descriptor = GeometryViewerRegistry.getInstance().getDefaultLeafletTiles();
                if (descriptor == null) {
                    yield null;
                }
                yield GeometryViewerRegistry.getInstance().getDefaultLeafletTiles().getLayersDefinition();
            }
            default -> null;
        };
        Files.writeString(this.scriptFile, (CharSequence)GeneralUtils.replaceVariables((String)template, (IVariableResolver)resolver), new OpenOption[0]);
        return this.scriptFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIncludesExistence(Path scriptDir) throws IOException {
        Path incFolder = scriptDir.resolve("inc");
        if (!Files.exists(incFolder, new LinkOption[0])) {
            Files.createDirectories(incFolder, new FileAttribute[0]);
            for (String fileName : GISBrowserViewerConstants.INC_FILES) {
                InputStream fis = GISViewerActivator.getDefault().getResourceStream("web/inc/" + fileName);
                if (fis == null) continue;
                try (OutputStream fos = Files.newOutputStream(incFolder.resolve(fileName), new OpenOption[0]);){
                    try {
                        IOUtils.copyStream((InputStream)fis, (OutputStream)fos);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error copying inc file " + fileName), (Throwable)e);
                    }
                    finally {
                        ContentUtils.close((Closeable)fis);
                    }
                }
            }
        }
    }

    private void cleanupFiles() {
        if (this.scriptFile != null) {
            try {
                Files.delete(this.scriptFile);
            }
            catch (IOException e) {
                log.debug((Object)("Can't delete temp script file '" + String.valueOf(this.scriptFile) + "'"), (Throwable)e);
            }
        }
    }

    public Composite getBrowserComposite() {
        return this.composite;
    }

    @Nullable
    public IResultSetPresentation getPresentation() {
        return this.presentation;
    }

    @Nullable
    public Browser getBrowser() {
        return this.browser;
    }

    public boolean isBrowserCreating() {
        return this.browserCreating;
    }

    public DBGeometry[] getCurrentValue() {
        return this.lastValue;
    }

    void populateToolbar() {
        if (this.browser == null) {
            return;
        }
        this.toolBarManager.removeAll();
        this.toolBarManager.add((IAction)new Action(GISMessages.panel_leaflet_viewer_tool_bar_action_text_open, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.BROWSER)){

            public void run() {
                ShellUtils.launchProgram((String)GISLeafletViewer.this.scriptFile.toAbsolutePath().toString());
            }
        });
        this.toolBarManager.add((IAction)new Action(GISMessages.panel_leaflet_viewer_tool_bar_action_text_copy_as, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PICTURE)){

            public void run() {
                ImageTransfer imageTransfer = ImageTransfer.getInstance();
                ImageData imageData = GISLeafletViewer.this.captureBrowserImage();
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{imageData}, new Transfer[]{imageTransfer});
            }
        });
        this.toolBarManager.add((IAction)new Action(GISMessages.panel_leaflet_viewer_tool_bar_action_text_save_as, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PICTURE_SAVE)){

            public void run() {
                Shell shell = GISLeafletViewer.this.browser.getShell();
                FileDialog saveDialog = new FileDialog(shell, 8192);
                String[] extensions = new String[SUPPORTED_FORMATS.length];
                String[] filterNames = new String[SUPPORTED_FORMATS.length];
                for (int i = 0; i < SUPPORTED_FORMATS.length; ++i) {
                    extensions[i] = "*." + SUPPORTED_FORMATS[i];
                    filterNames[i] = SUPPORTED_FORMATS[i].toUpperCase() + " (*." + SUPPORTED_FORMATS[i] + ")";
                }
                saveDialog.setFilterExtensions(extensions);
                saveDialog.setFilterNames(filterNames);
                String filePath = DialogUtils.openFileDialog((FileDialog)saveDialog);
                if (filePath == null) {
                    return;
                }
                int imageType = 0;
                String filePathLower = filePath.toLowerCase();
                if (filePathLower.endsWith(".png")) {
                    imageType = 5;
                } else if (filePathLower.endsWith(".gif")) {
                    imageType = 2;
                }
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[1];
                imageLoader.data[0] = GISLeafletViewer.this.captureBrowserImage();
                File outFile = new File(filePath);
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    imageLoader.save((OutputStream)fos, imageType);
                }
                catch (IOException e) {
                    DBWorkbench.getPlatformUI().showError("Image save error", "Error saving as picture", (Throwable)e);
                }
                ShellUtils.launchProgram((String)outFile.getAbsolutePath());
            }
        });
        this.toolBarManager.add((IAction)new Action(GISMessages.panel_leaflet_viewer_tool_bar_action_text_print, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PRINT)){

            public void run() {
                GC gc = new GC((Drawable)GISLeafletViewer.this.browser.getDisplay());
                try {
                    GISLeafletViewer.this.browser.execute("javascript:window.print();");
                }
                finally {
                    gc.dispose();
                }
            }
        });
        this.toolBarManager.add((IContributionItem)new Separator());
        SelectCRSAction crsSelectorAction = new SelectCRSAction(this);
        this.toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)crsSelectorAction, (boolean)true));
        SelectTilesAction tilesSelectorAction = new SelectTilesAction(this);
        this.toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)tilesSelectorAction, (boolean)true));
        this.toolBarManager.add((IAction)new Action(GISMessages.panel_leaflet_viewer_tool_bar_action_text_flip, 2){
            {
                this.setToolTipText(GISMessages.panel_leaflet_viewer_tool_bar_action_tool_tip_text_flip);
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.LINK_TO_EDITOR));
            }

            public boolean isChecked() {
                return GISLeafletViewer.this.flipCoordinates;
            }

            public void run() {
                GISLeafletViewer.this.flipCoordinates = !GISLeafletViewer.this.flipCoordinates;
                try {
                    GISLeafletViewer.this.reloadGeometryData(GISLeafletViewer.this.lastValue, true, true);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Render error", "Error rendering geometry", (Throwable)e);
                }
                GISLeafletViewer.this.saveAttributeSettings();
                GISLeafletViewer.this.populateToolbar();
            }
        });
        this.toolBarManager.add((IContributionItem)new Separator());
        this.toolBarManager.add((IAction)new Action(GISMessages.panel_leaflet_viewer_tool_bar_action_text_show_hide, 2){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PALETTE));
            }

            public boolean isChecked() {
                return GISLeafletViewer.this.toolsVisible;
            }

            public void run() {
                GISLeafletViewer.this.toolsVisible = !GISLeafletViewer.this.toolsVisible;
                GISLeafletViewer.this.updateControlsVisibility();
                GISLeafletViewer.this.populateToolbar();
            }
        });
        this.toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new ToggleLabelsAction(this), (boolean)true));
        this.toolBarManager.update(true);
    }

    public void updateToolbar() {
        try {
            this.statusBar.setRedraw(false);
            UIUtils.updateContributionItems((IContributionManager)this.toolBarManager);
            this.statusBar.layout(true, true);
        }
        finally {
            this.statusBar.setRedraw(true);
        }
    }

    private void saveAttributeSettings() {
        for (DBDAttributeBinding binding : this.bindings) {
            DBVEntity vEntity;
            DBVEntityAttribute vAttr;
            if (binding.getEntityAttribute() == null || (vAttr = (vEntity = DBVUtils.getVirtualEntity((DBDAttributeBinding)binding, (boolean)true)).getVirtualAttribute(binding, true)) == null) continue;
            vAttr.setProperty(PROP_FLIP_COORDINATES, (Object)String.valueOf(this.flipCoordinates));
            vAttr.setProperty(PROP_SRID, (Object)String.valueOf(this.getValueSRID()));
        }
        this.bindings[0].getDataSource().getContainer().persistConfiguration();
    }

    private void updateControlsVisibility() {
        if (this.browser == null) {
            return;
        }
        GC gc = new GC((Drawable)this.browser.getDisplay());
        try {
            this.browser.execute("javascript:showTools(" + this.toolsVisible + ");");
        }
        finally {
            gc.dispose();
        }
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean value) {
        if (this.showLabels == value) {
            return;
        }
        Browser browser = this.getBrowser();
        if (browser != null) {
            browser.execute("javascript:showLabels(" + value + ")");
        }
        this.showLabels = value;
        GISViewerActivator.getDefault().getPreferences().setValue("gis.view.showLabels", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData captureBrowserImage() {
        ImageData imageData;
        boolean toolsVisibility = this.toolsVisible;
        if (this.toolsVisible) {
            this.toolsVisible = false;
        }
        this.updateControlsVisibility();
        if (RuntimeUtils.isWindows()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            imageData = GISBrowserImageUtils.getControlScreenshotOnWindows((Control)this.browser);
        } else {
            Rectangle bounds = this.browser.getBounds();
            Image image = new Image((Device)Display.getDefault(), bounds.width, bounds.height);
            GC gc = new GC((Drawable)image);
            try {
                this.browser.print(gc);
            }
            finally {
                gc.dispose();
            }
            imageData = image.getImageData();
            image.dispose();
        }
        this.toolsVisible = toolsVisibility;
        this.updateControlsVisibility();
        return imageData;
    }

    private static class Bounds {
        private final double north;
        private final double east;
        private final double south;
        private final double west;

        private Bounds(double north, double east, double south, double west) {
            this.north = north;
            this.east = east;
            this.south = south;
            this.west = west;
        }

        @Nullable
        public static Bounds tryExtractFromBrowser(@NotNull Browser browser) {
            try {
                Object[] bounds = (Object[])browser.evaluate("if (typeof geoMap === 'undefined') {    return undefined;} else {    let b = geoMap.getBounds();    return [b.getNorth(), b.getEast(), b.getSouth(), b.getWest()];}");
                if (bounds == null) {
                    return null;
                }
                return new Bounds(CommonUtils.toDouble((Object)bounds[0]), CommonUtils.toDouble((Object)bounds[1]), CommonUtils.toDouble((Object)bounds[2]), CommonUtils.toDouble((Object)bounds[3]));
            }
            catch (Throwable e) {
                log.error((Object)"Error retrieving map bounds", e);
                return null;
            }
        }

        public String toString() {
            return String.format("L.latLngBounds(L.latLng(%f, %f), L.latLng(%f, %f))", this.north, this.east, this.south, this.west);
        }
    }
}

