/*
 * Decompiled with CFR 0.152.
 */
package app.f3d.F3D;

import app.f3d.F3D.Interactor;
import app.f3d.F3D.Options;
import app.f3d.F3D.Scene;
import app.f3d.F3D.Window;
import java.util.List;
import java.util.Map;

public class Engine
implements AutoCloseable {
    private long mNativeAddress;
    private Scene mScene;
    private Options mOptions;
    private Window mWindow;

    private Engine(long l) {
        this.mNativeAddress = l;
        this.mScene = new Scene(this.mNativeAddress);
        this.mOptions = new Options(this.mNativeAddress);
        this.mWindow = new Window(this.mNativeAddress);
    }

    public static Engine create(boolean bl) {
        return new Engine(Engine.nativeCreate(bl));
    }

    public static Engine create() {
        return Engine.create(false);
    }

    public static Engine createNone() {
        return new Engine(Engine.nativeCreateNone());
    }

    public static Engine createGLX(boolean bl) {
        return new Engine(Engine.nativeCreateGLX(bl));
    }

    public static Engine createGLX() {
        return Engine.createGLX(false);
    }

    public static Engine createWGL(boolean bl) {
        return new Engine(Engine.nativeCreateWGL(bl));
    }

    public static Engine createWGL() {
        return Engine.createWGL(false);
    }

    public static Engine createEGL() {
        return new Engine(Engine.nativeCreateEGL());
    }

    public static Engine createOSMesa() {
        return new Engine(Engine.nativeCreateOSMesa());
    }

    public static Engine createExternal(ContextFunction contextFunction) {
        return new Engine(Engine.nativeCreateExternal(contextFunction));
    }

    public static Engine createExternalGLX() {
        return new Engine(Engine.nativeCreateExternalGLX());
    }

    public static Engine createExternalWGL() {
        return new Engine(Engine.nativeCreateExternalWGL());
    }

    public static Engine createExternalCOCOA() {
        return new Engine(Engine.nativeCreateExternalCOCOA());
    }

    public static Engine createExternalEGL() {
        return new Engine(Engine.nativeCreateExternalEGL());
    }

    public static Engine createExternalOSMesa() {
        return new Engine(Engine.nativeCreateExternalOSMesa());
    }

    @Override
    public void close() {
        Engine.nativeDestroy(this.mNativeAddress);
    }

    public native void setCachePath(String var1);

    public native void setOptions(Options var1);

    public Options getOptions() {
        return this.mOptions;
    }

    public Scene getScene() {
        return this.mScene;
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public native Interactor getInteractor();

    public static native void loadPlugin(String var0);

    public static native void autoloadPlugins();

    public static native List<String> getPluginsList(String var0);

    public static native LibInfo getLibInfo();

    public static native List<ReaderInfo> getReadersInfo();

    public static native Map<String, Boolean> getRenderingBackendList();

    public static native void setReaderOption(String var0, String var1);

    public static native List<String> getAllReaderOptionNames();

    private static native long nativeCreate(boolean var0);

    private static native long nativeCreateNone();

    private static native long nativeCreateGLX(boolean var0);

    private static native long nativeCreateWGL(boolean var0);

    private static native long nativeCreateEGL();

    private static native long nativeCreateOSMesa();

    private static native long nativeCreateExternal(ContextFunction var0);

    private static native long nativeCreateExternalGLX();

    private static native long nativeCreateExternalWGL();

    private static native long nativeCreateExternalCOCOA();

    private static native long nativeCreateExternalEGL();

    private static native long nativeCreateExternalOSMesa();

    private static native void nativeDestroy(long var0);

    static {
        System.loadLibrary("f3d-java");
    }

    @FunctionalInterface
    public static interface ContextFunction {
        public long getProcAddress(String var1);
    }

    public static class ReaderInfo {
        public String name;
        public String description;
        public List<String> extensions;
        public List<String> mimeTypes;
        public String pluginName;
        public boolean hasSceneReader;
        public boolean hasGeometryReader;

        public ReaderInfo(String string, String string2, List<String> list, List<String> list2, String string3, boolean bl, boolean bl2) {
            this.name = string;
            this.description = string2;
            this.extensions = list;
            this.mimeTypes = list2;
            this.pluginName = string3;
            this.hasSceneReader = bl;
            this.hasGeometryReader = bl2;
        }
    }

    public static class LibInfo {
        public String version;
        public String versionFull;
        public String buildDate;
        public String buildSystem;
        public String compiler;
        public Map<String, Boolean> modules;
        public String vtkVersion;
        public List<String> copyrights;
        public String license;

        public LibInfo(String string, String string2, String string3, String string4, String string5, Map<String, Boolean> map, String string6, List<String> list, String string7) {
            this.version = string;
            this.versionFull = string2;
            this.buildDate = string3;
            this.buildSystem = string4;
            this.compiler = string5;
            this.modules = map;
            this.vtkVersion = string6;
            this.copyrights = list;
            this.license = string7;
        }
    }
}

