/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.kotlin.dsl.concurrent.ResurrectingThread;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0016R%\u0010\u0005\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gradle/kotlin/dsl/concurrent/EventLoop;", "T", "", "name", "", "loop", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getLoop", "()Lkotlin/jvm/functions/Function1;", "accept", "", "event", "(Ljava/lang/Object;)Z", "q", "Ljava/util/concurrent/ArrayBlockingQueue;", "consumer", "Lorg/gradle/kotlin/dsl/concurrent/ResurrectingThread;", "poll", "()Ljava/lang/Object;", "kotlin-dsl"})
public final class EventLoop<T> {
    @NotNull
    private final Function1<Function0<? extends T>, Unit> loop;
    @NotNull
    private final ArrayBlockingQueue<T> q;
    @NotNull
    private ResurrectingThread consumer;

    public EventLoop(@NotNull String name, @NotNull Function1<? super Function0<? extends T>, Unit> loop) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(loop, (String)"loop");
        this.loop = loop;
        this.q = new ArrayBlockingQueue(64);
        this.consumer = new ResurrectingThread(name, (Function0<Unit>)((Function0)() -> EventLoop.consumer$lambda$0(this)));
    }

    public /* synthetic */ EventLoop(String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Gradle Kotlin DSL Event Loop";
        }
        this(string, function1);
    }

    @NotNull
    public final Function1<Function0<? extends T>, Unit> getLoop() {
        return this.loop;
    }

    public final boolean accept(T event) {
        if (this.q.offer(event, 50L, TimeUnit.MILLISECONDS)) {
            this.consumer.poke();
            return true;
        }
        return false;
    }

    private final T poll() {
        return this.q.poll(5000L, TimeUnit.MILLISECONDS);
    }

    private static final Unit consumer$lambda$0(EventLoop this$0) {
        this$0.loop.invoke((Object)new Function0<T>(this$0){

            public final T invoke() {
                return (T)EventLoop.access$poll((EventLoop)this.receiver);
            }
        });
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$poll(EventLoop $this) {
        return $this.poll();
    }
}

