#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-pandoc-z-xml-light
version:              3.5
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.5-4B3Ns8HMGaAIcKM4tkAnfZ-xml-light
key:                  pandoc-3.5-4B3Ns8HMGaAIcKM4tkAnfZ-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  e29dfb9798398160a68d381eb8c175c2
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.5-4B3Ns8HMGaAIcKM4tkAnfZ-xml-light
depends:
    base-4.18.2.1 containers-0.6.7 text-2.0.2
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-7ee0415noOoF6jmR1KcA0M
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc
version:              3.5
visibility:           public
id:                   pandoc-3.5-ECevCsGe5Y93NXYWFCHLgj
key:                  pandoc-3.5-ECevCsGe5Y93NXYWFCHLgj
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  2b2184d982a00332415022d1b6fb9f8d
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.Djot Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.EndNote
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.ODT Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RIS
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.RTF
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Typst Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.Scripting Text.Pandoc.SelfContained Text.Pandoc.Shared
    Text.Pandoc.Slides Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.Transforms Text.Pandoc.Translations
    Text.Pandoc.Translations.Types Text.Pandoc.UTF8 Text.Pandoc.Version
    Text.Pandoc.Writers Text.Pandoc.Writers.ANSI
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.ChunkedHTML
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.CslJson Text.Pandoc.Writers.Djot
    Text.Pandoc.Writers.DocBook Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.DokuWiki Text.Pandoc.Writers.EPUB
    Text.Pandoc.Writers.FB2 Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.ICML
    Text.Pandoc.Writers.Ipynb Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.Jira Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.Man Text.Pandoc.Writers.Markdown
    Text.Pandoc.Writers.Math Text.Pandoc.Writers.MediaWiki
    Text.Pandoc.Writers.Ms Text.Pandoc.Writers.Muse
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.OOXML Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.Powerpoint Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.Shared
    Text.Pandoc.Writers.TEI Text.Pandoc.Writers.Texinfo
    Text.Pandoc.Writers.Textile Text.Pandoc.Writers.Typst
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Symbols Text.Pandoc.Readers.Docx.Fields
    Text.Pandoc.Readers.HTML.Parsing Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.Typst.Parsing
    Text.Pandoc.Readers.Typst.Math Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.OpenXML
    Text.Pandoc.Writers.Docx.StyleMap Text.Pandoc.Writers.Docx.Table
    Text.Pandoc.Writers.Docx.Types Text.Pandoc.Writers.GridTable
    Text.Pandoc.Writers.JATS.References Text.Pandoc.Writers.JATS.Table
    Text.Pandoc.Writers.JATS.Types Text.Pandoc.Writers.LaTeX.Caption
    Text.Pandoc.Writers.LaTeX.Notes Text.Pandoc.Writers.LaTeX.Table
    Text.Pandoc.Writers.LaTeX.Lang Text.Pandoc.Writers.LaTeX.Types
    Text.Pandoc.Writers.LaTeX.Citation Text.Pandoc.Writers.LaTeX.Util
    Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Char
    Text.Pandoc.TeX Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.5-ECevCsGe5Y93NXYWFCHLgj
depends:
    Glob-0.10.2-2ZMF3q0E9RcIvo0RuO2Ci6
    JuicyPixels-3.3.9-C4SJhQRdyCytYWlOE1BnC
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    aeson-pretty-0.8.10-LSDchJgtnQ46sIK4bUu3co array-0.5.6.0
    attoparsec-0.14.4-FIfeiNzOKYm3sEc1QPF51Z base-4.18.2.1
    base64-bytestring-1.2.1.0-6srVB7ZKmzD1HZV2AV5j9d binary-0.8.9.1
    blaze-html-0.9.2.0-BSUXMYxgqldK7Fv9A0AXBj
    blaze-markup-0.8.3.0-F9gHjrjtMfj4BTHQBYRdEr bytestring-0.11.5.3
    case-insensitive-1.2.1.0-HFTLAepm1u61gRs0sAANH
    citeproc-0.8.1.1-xWxd6oXL6k3B5FoFmy1zm
    commonmark-0.2.6.1-59i9aOrPh59B906LpDFv9f
    commonmark-extensions-0.2.5.6-BerzIrk9KuC8MGUl6MZ5sb
    commonmark-pandoc-0.2.2.3-IRNgPTVOfNhLALGoWU60HT containers-0.6.7
    crypton-1.0.4-DGMKyUhI3LiKWt7ay9qYrG
    crypton-connection-0.4.5-KoLRj3NeuIK8L0ThEjdZin
    crypton-x509-system-1.6.7-6adKUtVTl29GaBtztBqrbJ
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz deepseq-1.4.8.1
    directory-1.3.8.5 djot-0.1.2.3-EEw7mxTwbLO8ybbRNYcYWx
    doclayout-0.5-N09RIPsKhI2djXlHOrzS4
    doctemplates-0.11.0.1-A0yNC6vskCsnuNlcpxplZ
    emojis-0.1.4.1-L7mOnPsQOMB2xPGhke4egp exceptions-0.10.7
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    gridtables-0.1.1.0-5BfDtqa3exj1542tlzKfcM
    haddock-library-1.11.0-5wxOk0GEabB6c0GRH0l6Q
    http-client-0.7.19-4rucZD6prn1Bn7NkqCpiFR
    http-client-tls-0.3.6.4-LhFztqm7Yl955SnS7vNn0b
    http-types-0.12.4-Hj8jLUhN6rtnIgKEy5ynr
    ipynb-0.2-K0CtVX4O5Cr7wF8gSRohu5
    jira-wiki-markup-1.5.1-6kcOellStZ2E5TDtIO35uk
    mime-types-0.1.2.0-2lnuHjhOzQ4DFNhuFJ9ART mtl-2.3.1
    network-3.1.4.0-LsWsY6caX6uCNLTGwySDR3
    network-uri-2.6.4.2-3U0FvLc2coZ6tqjF5PGDly
    pandoc-3.5-4B3Ns8HMGaAIcKM4tkAnfZ-xml-light
    pandoc-types-1.23.1-AOoNyo1PJrkKwLhWFhFLpF parsec-3.1.16.1
    pretty-1.1.3.6 pretty-show-1.10-EXsS4VwIV5tJ56gbmVdfrR
    process-1.6.19.0 random-1.2.1.3-HzFGhfPSv5b3eeTVe0g48p
    safe-0.3.21-WYqCEMpsX24yfPdI1X0Hh
    scientific-0.3.8.0-CFYO4vxJ7Tde72prrjPHU
    skylighting-0.14.3-2QUCR90tlBBbTL4blHnSD
    skylighting-core-0.14.3-1wYSAVtl0dP8mcavLcDWyx
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 syb-0.7.3-HezvxMxFoxE4YYIFSuLToH
    tagsoup-0.14.8-4wbuepjIYFCCy5VT0j43hw
    temporary-1.3-7FXkQQKerYU7UfmRyKNwo9
    texmath-0.12.8.11-8HuyToMywje6cLyixgE9Ze text-2.0.2
    text-conversions-0.3.1.1-5H3Y0MSNQlB31DvfsG1hWz time-1.12.2
    tls-2.0.6-1CZKP97Y3KoB0UoivGsQdY typst-0.6-72Oob79pe41b8wcSXRYmf
    unicode-collation-0.1.3.6-HWWbtkPZLoIE7M41xgHSx
    unicode-transforms-0.4.0.1-9Um9DDtdyG0KCRhrtai7oD unix-2.8.4.0
    vector-0.13.2.0-KFVS0U8K6eML5O0P7tVbRi
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    yaml-0.11.11.2-BS6mG9zOsXWGQgGFfufno4
    zip-archive-0.4.3.2-1XeMNWl5bCBHGBNkq6CyGn
    zlib-0.7.0.0-AoTprguvpA33AfeZgt1J6J

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

