/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.slf4j.Logger;

public final class StreamStreamJoinUtil {
    private StreamStreamJoinUtil() {
    }

    public static <KIn, VIn, KOut, VOut> boolean skipRecord(Record<KIn, VIn> record, Logger logger, Sensor droppedRecordsSensor, ProcessorContext<KOut, VOut> context) {
        if (record.key() == null || record.value() == null) {
            if (context.recordMetadata().isPresent()) {
                RecordMetadata recordMetadata = context.recordMetadata().get();
                logger.warn("Skipping record due to null key or value. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
            } else {
                logger.warn("Skipping record due to null key or value. Topic, partition, and offset not known.");
            }
            droppedRecordsSensor.record();
            return true;
        }
        return false;
    }
}

