/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.serialization;

import java.io.PrintStream;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.BytesApiMessageSerde;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogSegmentMetadataSnapshot;
import org.apache.kafka.server.log.remote.metadata.storage.generated.MetadataRecordType;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataRecord;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataSnapshotRecord;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataUpdateRecord;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemotePartitionDeleteMetadataRecord;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataSnapshotTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataUpdateTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemotePartitionDeleteMetadataTransform;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;

public class RemoteLogMetadataSerde {
    private static final short REMOTE_LOG_SEGMENT_METADATA_API_KEY = new RemoteLogSegmentMetadataRecord().apiKey();
    private static final short REMOTE_LOG_SEGMENT_METADATA_UPDATE_API_KEY = new RemoteLogSegmentMetadataUpdateRecord().apiKey();
    private static final short REMOTE_PARTITION_DELETE_API_KEY = new RemotePartitionDeleteMetadataRecord().apiKey();
    private static final short REMOTE_LOG_SEGMENT_METADATA_SNAPSHOT_API_KEY = new RemoteLogSegmentMetadataSnapshotRecord().apiKey();
    private final BytesApiMessageSerde bytesApiMessageSerde = new BytesApiMessageSerde(){

        public ApiMessage apiMessageFor(short apiKey) {
            return RemoteLogMetadataSerde.this.newApiMessage(apiKey);
        }
    };
    private final RemoteLogSegmentMetadataTransform segmentTransform = new RemoteLogSegmentMetadataTransform();
    private final RemoteLogSegmentMetadataUpdateTransform segmentUpdateTransform = new RemoteLogSegmentMetadataUpdateTransform();
    private final RemotePartitionDeleteMetadataTransform partitionDeleteTransform = new RemotePartitionDeleteMetadataTransform();
    private final RemoteLogSegmentMetadataSnapshotTransform segmentSnapshotTransform = new RemoteLogSegmentMetadataSnapshotTransform();

    protected ApiMessage newApiMessage(short apiKey) {
        return MetadataRecordType.fromId(apiKey).newMetadataRecord();
    }

    public byte[] serialize(RemoteLogMetadata remoteLogMetadata) {
        ApiMessageAndVersion apiMessageAndVersion;
        if (remoteLogMetadata instanceof RemoteLogSegmentMetadata) {
            apiMessageAndVersion = this.segmentTransform.toApiMessageAndVersion((RemoteLogSegmentMetadata)remoteLogMetadata);
        } else if (remoteLogMetadata instanceof RemoteLogSegmentMetadataUpdate) {
            apiMessageAndVersion = this.segmentUpdateTransform.toApiMessageAndVersion((RemoteLogSegmentMetadataUpdate)remoteLogMetadata);
        } else if (remoteLogMetadata instanceof RemotePartitionDeleteMetadata) {
            apiMessageAndVersion = this.partitionDeleteTransform.toApiMessageAndVersion((RemotePartitionDeleteMetadata)remoteLogMetadata);
        } else if (remoteLogMetadata instanceof RemoteLogSegmentMetadataSnapshot) {
            apiMessageAndVersion = this.segmentSnapshotTransform.toApiMessageAndVersion((RemoteLogSegmentMetadataSnapshot)remoteLogMetadata);
        } else {
            throw new IllegalArgumentException("RemoteLogMetadataTransform for given RemoteStorageMetadata class: " + String.valueOf(remoteLogMetadata.getClass()) + " does not exist.");
        }
        return this.bytesApiMessageSerde.serialize(apiMessageAndVersion);
    }

    public RemoteLogMetadata deserialize(byte[] data) {
        ApiMessageAndVersion apiMessageAndVersion = this.bytesApiMessageSerde.deserialize(data);
        short apiKey = apiMessageAndVersion.message().apiKey();
        if (apiKey == REMOTE_LOG_SEGMENT_METADATA_API_KEY) {
            return this.segmentTransform.fromApiMessageAndVersion(apiMessageAndVersion);
        }
        if (apiKey == REMOTE_LOG_SEGMENT_METADATA_UPDATE_API_KEY) {
            return this.segmentUpdateTransform.fromApiMessageAndVersion(apiMessageAndVersion);
        }
        if (apiKey == REMOTE_PARTITION_DELETE_API_KEY) {
            return this.partitionDeleteTransform.fromApiMessageAndVersion(apiMessageAndVersion);
        }
        if (apiKey == REMOTE_LOG_SEGMENT_METADATA_SNAPSHOT_API_KEY) {
            return this.segmentSnapshotTransform.fromApiMessageAndVersion(apiMessageAndVersion);
        }
        throw new IllegalArgumentException("RemoteLogMetadataTransform for apikey: " + apiKey + " does not exist.");
    }

    public static class RemoteLogMetadataFormatter
    implements MessageFormatter {
        private final RemoteLogMetadataSerde remoteLogMetadataSerde = new RemoteLogMetadataSerde();

        public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
            output.printf("partition: %d, offset: %d, value: %s%n", consumerRecord.partition(), consumerRecord.offset(), this.remoteLogMetadataSerde.deserialize((byte[])consumerRecord.value()).toString());
        }
    }
}

