/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.keycloak.Config;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class MicroProfileConfigProvider
implements Config.ConfigProvider {
    public static final String NS_KEYCLOAK = "kc";
    public static final String NS_KEYCLOAK_PREFIX = "kc.";
    public static final String SPI_PREFIX = "kc.spi" + Configuration.OPTION_PART_SEPARATOR;
    public static final String NS_QUARKUS = "quarkus";
    public static final String NS_QUARKUS_PREFIX = "quarkus.";
    private final SmallRyeConfig config;

    public MicroProfileConfigProvider() {
        this(Configuration.getConfig());
    }

    public MicroProfileConfigProvider(SmallRyeConfig config) {
        this.config = config;
    }

    public String getProvider(String spi) {
        return this.scope(spi).get("provider");
    }

    public String getDefaultProvider(String spi) {
        return this.scope(spi).get("provider-default");
    }

    public Config.Scope scope(String ... scope) {
        return new MicroProfileScope(SPI_PREFIX, scope);
    }

    public class MicroProfileScope
    extends Config.AbstractScope {
        private final String prefix;
        private final String separatorPrefix;

        public MicroProfileScope(String prefix, String ... scopes) {
            StringBuilder prefixBuilder = new StringBuilder(prefix);
            for (String scope : scopes) {
                prefixBuilder.append(Configuration.toDashCase(scope)).append(Configuration.OPTION_PART_SEPARATOR + Configuration.OPTION_PART_SEPARATOR);
            }
            this.separatorPrefix = prefixBuilder.toString();
            this.prefix = this.separatorPrefix.replace(Configuration.OPTION_PART_SEPARATOR + Configuration.OPTION_PART_SEPARATOR, Configuration.OPTION_PART_SEPARATOR);
        }

        public String get(String key) {
            return this.get(key, null);
        }

        public Config.Scope scope(String ... scope) {
            return new MicroProfileScope(this.prefix, scope);
        }

        public Set<String> getPropertyNames() {
            return StreamSupport.stream(MicroProfileConfigProvider.this.config.getPropertyNames().spliterator(), false).filter(key -> key.startsWith(this.separatorPrefix)).collect(Collectors.toSet());
        }

        protected <T> T getValue(String key, Function<String, T> conversion, Class<T> clazz, T defaultValue) {
            if (MicroProfileConfigProvider.NS_KEYCLOAK_PREFIX.equals(this.separatorPrefix)) {
                return MicroProfileConfigProvider.this.config.getOptionalValue(this.separatorPrefix.concat(key), clazz).orElse(defaultValue);
            }
            String dashCase = Configuration.toDashCase(key);
            String name = this.separatorPrefix.concat(dashCase);
            String oldName = this.prefix.concat(dashCase);
            ConfigValue value = MicroProfileConfigProvider.this.config.getConfigValue(name);
            ConfigValue oldValue = MicroProfileConfigProvider.this.config.getConfigValue(oldName);
            if (value.getValue() == null || oldValue.getValue() != null && oldValue.getSourceOrdinal() > value.getSourceOrdinal()) {
                value = oldValue;
            }
            return (T)Optional.ofNullable(MicroProfileConfigProvider.this.config.convert(value.getValue(), clazz)).orElse(defaultValue);
        }

        public Config.Scope root() {
            return new MicroProfileScope(MicroProfileConfigProvider.NS_KEYCLOAK_PREFIX, new String[0]);
        }
    }
}

