/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.resync;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.translog.Translog;

public final class ResyncReplicationRequest
extends ReplicatedWriteRequest<ResyncReplicationRequest> {
    private final long trimAboveSeqNo;
    private final Translog.Operation[] operations;
    private final long maxSeenAutoIdTimestampOnPrimary;

    ResyncReplicationRequest(StreamInput in) throws IOException {
        super(in);
        this.trimAboveSeqNo = in.readZLong();
        this.maxSeenAutoIdTimestampOnPrimary = in.readZLong();
        this.operations = (Translog.Operation[])in.readArray(Translog.Operation::readOperation, Translog.Operation[]::new);
    }

    public ResyncReplicationRequest(ShardId shardId, long trimAboveSeqNo, long maxSeenAutoIdTimestampOnPrimary, Translog.Operation[] operations) {
        super(shardId);
        this.trimAboveSeqNo = trimAboveSeqNo;
        this.maxSeenAutoIdTimestampOnPrimary = maxSeenAutoIdTimestampOnPrimary;
        this.operations = operations;
    }

    public long getTrimAboveSeqNo() {
        return this.trimAboveSeqNo;
    }

    public long getMaxSeenAutoIdTimestampOnPrimary() {
        return this.maxSeenAutoIdTimestampOnPrimary;
    }

    public Translog.Operation[] getOperations() {
        return this.operations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeZLong(this.trimAboveSeqNo);
        out.writeZLong(this.maxSeenAutoIdTimestampOnPrimary);
        out.writeArray(Translog.Operation::writeOperation, (Object[])this.operations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResyncReplicationRequest that = (ResyncReplicationRequest)o;
        return this.trimAboveSeqNo == that.trimAboveSeqNo && this.maxSeenAutoIdTimestampOnPrimary == that.maxSeenAutoIdTimestampOnPrimary && Arrays.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Objects.hash(this.trimAboveSeqNo, this.maxSeenAutoIdTimestampOnPrimary, Arrays.hashCode(this.operations));
    }

    @Override
    public String toString() {
        return "TransportResyncReplicationAction.Request{shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", index='" + this.index + "', trimAboveSeqNo=" + this.trimAboveSeqNo + ", maxSeenAutoIdTimestampOnPrimary=" + this.maxSeenAutoIdTimestampOnPrimary + ", ops=" + this.operations.length + "}";
    }
}

