/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.preprocess;

import java.util.Map;
import org.opensearch.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

public class OpenAIEmbeddingPreProcessFunction
extends ConnectorPreProcessFunction {
    public OpenAIEmbeddingPreProcessFunction() {
        this.returnDirectlyForRemoteInferenceInput = true;
    }

    @Override
    public void validate(MLInput mlInput) {
        this.validateTextDocsInput(mlInput);
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        TextDocsInputDataSet inputData = (TextDocsInputDataSet)mlInput.getInputDataset();
        Map<String, Object> processedResult = Map.of("parameters", Map.of("input", inputData.getDocs()));
        return RemoteInferenceInputDataSet.builder().parameters(StringUtils.convertScriptStringToJsonString(processedResult)).build();
    }
}

