/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.HKDFKeyParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HKDFKeyGenerator {
    private HMac hMacHash;
    private int hashLen;

    public HKDFKeyGenerator(Digest digest) {
        this.hMacHash = new HMac(digest);
        this.hashLen = digest.getDigestSize();
    }

    public HKDFKeyGenerator(HMac hMac) {
        this.hMacHash = hMac;
        this.hashLen = hMac.getUnderlyingDigest().getDigestSize();
    }

    public KeyParameter generate(HKDFKeyParameters hKDFKeyParameters) {
        if (hKDFKeyParameters.skipExtract()) {
            return new KeyParameterImpl(hKDFKeyParameters.getIKM());
        }
        return this.extract(hKDFKeyParameters.getSalt(), hKDFKeyParameters.getIKM());
    }

    private KeyParameter extract(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            this.hMacHash.init(new KeyParameterImpl(new byte[this.hashLen]));
        } else {
            this.hMacHash.init(new KeyParameterImpl(byArray));
        }
        this.hMacHash.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[this.hashLen];
        this.hMacHash.doFinal(byArray3, 0);
        return new KeyParameterImpl(byArray3);
    }
}

