/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.GenericArrays;
import com.selectivem.collections.Hashing;
import com.selectivem.collections.ImmutableSetImpl;
import com.selectivem.collections.UnmodifiableMapImpl;
import com.selectivem.collections.UnmodifiableSetImpl;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

abstract class ImmutableMapImpl<K, V>
extends UnmodifiableMapImpl<K, V> {
    private static final ImmutableMapImpl<?, ?> EMPTY = new ImmutableMapImpl<Object, Object>(){

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return ImmutableSetImpl.empty();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Set<Object> keySet() {
            return ImmutableSetImpl.empty();
        }

        @Override
        public Collection<Object> values() {
            return ImmutableSetImpl.empty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        int getEstimatedByteSize() {
            return 0;
        }
    };

    ImmutableMapImpl() {
    }

    static <K, V> ImmutableMapImpl<K, V> empty() {
        return EMPTY;
    }

    static <K, V> ImmutableMapImpl<K, V> of(K k1, V v1) {
        return new SingleElementMap<K, V>(k1, v1);
    }

    static <K, V> ImmutableMapImpl<K, V> of(K k1, V v1, K k2, V v2) {
        return new TwoElementMap<K, V>(k1, v1, k2, v2);
    }

    static <K, V> ImmutableMapImpl<K, V> of(Map<K, V> map) {
        int size = map.size();
        if (map instanceof ImmutableMapImpl) {
            return (ImmutableMapImpl)map;
        }
        if (size == 0) {
            return ImmutableMapImpl.empty();
        }
        if (size == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return new SingleElementMap<K, V>(entry.getKey(), entry.getValue());
        }
        if (size == 2) {
            Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
            Map.Entry<K, V> entry1 = iter.next();
            Map.Entry<K, V> entry2 = iter.next();
            return new TwoElementMap<K, V>(entry1.getKey(), entry1.getValue(), entry2.getKey(), entry2.getValue());
        }
        int tableSize = Hashing.hashTableSize(size);
        if (tableSize != -1) {
            return new HashArrayBackedMap.Builder<K, V>(tableSize).with(map).build();
        }
        return new MapBackedMap<K, V>(new HashMap<K, V>(map));
    }

    abstract int getEstimatedByteSize();

    static class SingleElementMap<K, V>
    extends ImmutableMapImpl<K, V> {
        private final K key;
        private final V value;
        private Set<K> keySet;
        private Collection<V> values;
        private Set<Map.Entry<K, V>> entrySet;

        SingleElementMap(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return Objects.equals(this.value, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return Objects.equals(this.key, key);
        }

        @Override
        public V get(Object key) {
            if (Objects.equals(this.key, key)) {
                return this.value;
            }
            return null;
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = ImmutableSetImpl.of(this.key);
            }
            return this.keySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = ImmutableSetImpl.of(this.value);
            }
            return this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = ImmutableSetImpl.of(new AbstractMap.SimpleEntry<K, V>(this.key, this.value));
            }
            return this.entrySet;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map otherMap = (Map)o;
            if (otherMap.size() != 1) {
                return false;
            }
            Map.Entry entry = otherMap.entrySet().iterator().next();
            return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
        }

        @Override
        int getEstimatedByteSize() {
            return 48;
        }
    }

    static class TwoElementMap<K, V>
    extends ImmutableMapImpl<K, V> {
        private final K key1;
        private final V value1;
        private final K key2;
        private final V value2;
        private Set<K> keySet;
        private List<V> values;
        private Set<Map.Entry<K, V>> entrySet;

        TwoElementMap(K key1, V value1, K key2, V value2) {
            this.key1 = key1;
            this.value1 = value1;
            this.key2 = key2;
            this.value2 = value2;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return Objects.equals(this.value1, value) || Objects.equals(this.value2, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return Objects.equals(this.key1, key) || Objects.equals(this.key2, key);
        }

        @Override
        public V get(Object key) {
            if (Objects.equals(this.key1, key)) {
                return this.value1;
            }
            if (Objects.equals(this.key2, key)) {
                return this.value2;
            }
            return null;
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = ImmutableSetImpl.of(this.key1, this.key2);
            }
            return this.keySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableList(Arrays.asList(this.value1, this.value2));
            }
            return this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = ImmutableSetImpl.of(new AbstractMap.SimpleEntry<K, V>(this.key1, this.value1), new AbstractMap.SimpleEntry<K, V>(this.key2, this.value2));
            }
            return this.entrySet;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map otherMap = (Map)o;
            if (otherMap.size() != 2) {
                return false;
            }
            return Objects.equals(this.value1, otherMap.get(this.key1)) && Objects.equals(this.value2, otherMap.get(this.key2));
        }

        @Override
        int getEstimatedByteSize() {
            return 64;
        }
    }

    static class HashArrayBackedMap<K, V>
    extends ImmutableMapImpl<K, V> {
        final int tableSize;
        final int size;
        final short maxProbingDistance;
        private final K[] keyTable;
        private final V[] valueTable;
        private List<V> valuesCollection;

        HashArrayBackedMap(int tableSize, int size, short maxProbingDistance, K[] keyTable, V[] valueTable) {
            this.tableSize = tableSize;
            this.size = size;
            this.maxProbingDistance = maxProbingDistance;
            this.keyTable = keyTable;
            this.valueTable = valueTable;
            assert (size != 0);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.containsKey(key, this.hashPosition(key));
        }

        boolean containsKey(Object key, int position) {
            return this.checkTable(key, position) < 0;
        }

        @Override
        public V get(Object key) {
            int check = this.checkTable(key, this.hashPosition(key));
            if (check < 0) {
                int actualPosition = -check - 1;
                return this.valueTable[actualPosition];
            }
            return null;
        }

        @Override
        public Set<K> keySet() {
            return new UnmodifiableSetImpl<K>(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public boolean contains(Object o) {
                    return this.containsKey(o);
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        int current;
                        {
                            this.current = this.findNextKey(0);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.current != -1;
                        }

                        @Override
                        public K next() {
                            if (this.current == -1) {
                                throw new NoSuchElementException();
                            }
                            Object key = keyTable[this.current];
                            this.current = this.findNextKey(this.current + 1);
                            return key;
                        }
                    };
                }
            };
        }

        @Override
        public List<V> values() {
            List<Object> result = this.valuesCollection;
            if (result == null) {
                ArrayList<V> list = new ArrayList<V>(this.size);
                for (int i = 0; i < this.keyTable.length; ++i) {
                    if (this.keyTable[i] == null) continue;
                    list.add(this.valueTable[i]);
                }
                this.valuesCollection = result = Collections.unmodifiableList(list);
            }
            return result;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new UnmodifiableSetImpl<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public boolean contains(Object o) {
                    if (o instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)o;
                        Object presentValue = this.get(entry.getKey());
                        return presentValue != null && presentValue.equals(entry.getValue());
                    }
                    return false;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int current;
                        {
                            this.current = this.findNextKey(0);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.current != -1;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.current == -1) {
                                throw new NoSuchElementException();
                            }
                            Object key = keyTable[this.current];
                            Object value = valueTable[this.current];
                            this.current = this.findNextKey(this.current + 1);
                            return new AbstractMap.SimpleEntry<Object, Object>(key, value);
                        }
                    };
                }
            };
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            for (int i = 0; i < this.keyTable.length; ++i) {
                K key = this.keyTable[i];
                if (key == null) continue;
                action.accept(key, this.valueTable[i]);
            }
        }

        @Override
        int getEstimatedByteSize() {
            return 32 + this.keyTable.length * 8 * 2;
        }

        static int getEstimatedByteSize(int size) {
            return 32 + size * 8 * 2 * 2;
        }

        private int hashPosition(Object key) {
            return Hashing.hashPosition(this.tableSize, key);
        }

        private int checkTable(Object key, int hashPosition) {
            return Hashing.checkTable(this.keyTable, key, hashPosition, this.maxProbingDistance);
        }

        private int findNextKey(int start) {
            for (int i = start; i < this.keyTable.length; ++i) {
                if (this.keyTable[i] == null) continue;
                return i;
            }
            return -1;
        }

        static class Builder<K, V>
        extends InternalBuilder<K, V> {
            private K[] keyTable;
            private V[] valueTable;
            private int size = 0;
            private final int tableSize;
            private int probingOverhead;
            private short probingOverheadFactor = (short)3;
            private final short maxProbingDistance;
            private boolean valid = true;

            Builder(int tableSize) {
                this.tableSize = tableSize;
                this.maxProbingDistance = Hashing.maxProbingDistance(tableSize);
            }

            @Override
            InternalBuilder<K, V> with(K key, V value) {
                if (key == null) {
                    throw new IllegalArgumentException("Null keys are not supported");
                }
                return this.with(key, value, this.hashPosition(key));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private InternalBuilder<K, V> with(K key, V value, int pos) {
                if (!this.valid) {
                    throw new IllegalStateException("Builder instance is not active any more");
                }
                if (this.keyTable == null) {
                    this.keyTable = GenericArrays.create(this.tableSize + this.maxProbingDistance);
                    this.valueTable = GenericArrays.create(this.tableSize + this.maxProbingDistance);
                    this.keyTable[pos] = key;
                    this.valueTable[pos] = value;
                    ++this.size;
                    return this;
                }
                if (this.keyTable[pos] == null) {
                    this.keyTable[pos] = key;
                    this.valueTable[pos] = value;
                    ++this.size;
                    return this;
                }
                if (this.keyTable[pos].equals(key)) {
                    this.valueTable[pos] = value;
                    return this;
                }
                int check = Hashing.checkTable(this.keyTable, key, pos, this.maxProbingDistance);
                if (check < 0) {
                    int actualPos = -check - 1;
                    this.valueTable[actualPos] = value;
                    return this;
                }
                if (check == Integer.MAX_VALUE) {
                    try {
                        int newTableSize = Hashing.nextSize(this.tableSize);
                        if (newTableSize != -1) {
                            InternalBuilder internalBuilder = new Builder<K, V>(newTableSize).probingOverheadFactor(this.probingOverheadFactor).withNonNull(this.keyTable, this.valueTable).with(key, value);
                            return internalBuilder;
                        }
                        InternalBuilder<K, V> internalBuilder = new MapBackedMap.Builder<K, V>(this.size).withNonNull(this.keyTable, this.valueTable).with(key, value);
                        return internalBuilder;
                    }
                    finally {
                        this.valid = false;
                    }
                }
                this.keyTable[check] = key;
                this.valueTable[check] = value;
                ++this.size;
                this.probingOverhead += check - pos;
                if (this.size >= 12 && this.probingOverhead > this.size * this.probingOverheadFactor) {
                    try {
                        int newTableSize = Hashing.nextSize(this.tableSize);
                        if (newTableSize != -1) {
                            InternalBuilder internalBuilder = new Builder<K, V>(newTableSize).probingOverheadFactor(this.probingOverheadFactor).withNonNull(this.keyTable, this.valueTable);
                            return internalBuilder;
                        }
                        InternalBuilder<K, V> internalBuilder = new MapBackedMap.Builder<K, V>(this.size).withNonNull(this.keyTable, this.valueTable);
                        return internalBuilder;
                    }
                    finally {
                        this.valid = false;
                    }
                }
                return this;
            }

            InternalBuilder<K, V> with(Map<K, V> map) {
                InternalBuilder builder = this;
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    builder = ((InternalBuilder)builder).with(entry.getKey(), entry.getValue());
                }
                return builder;
            }

            @Override
            int size() {
                return this.size;
            }

            @Override
            boolean containsKey(Object key) {
                return this.get(key) != null;
            }

            @Override
            V get(Object key) {
                if (this.keyTable == null) {
                    return null;
                }
                int check = Hashing.checkTable(this.keyTable, key, this.hashPosition(key), this.maxProbingDistance);
                if (check < 0) {
                    int actualPos = -check - 1;
                    return this.valueTable[actualPos];
                }
                return null;
            }

            @Override
            int getEstimatedByteSize() {
                if (this.keyTable != null) {
                    return 32 + this.keyTable.length * 8 * 2;
                }
                return 32;
            }

            @Override
            Set<K> keySet() {
                return new UnmodifiableSetImpl<K>(){

                    @Override
                    public int size() {
                        return size;
                    }

                    @Override
                    public boolean contains(Object o) {
                        return this.containsKey(o);
                    }

                    @Override
                    public Iterator<K> iterator() {
                        return new Iterator<K>(){
                            int current;
                            {
                                this.current = this.findNextKey(0);
                            }

                            @Override
                            public boolean hasNext() {
                                return this.current != -1;
                            }

                            @Override
                            public K next() {
                                if (this.current == -1) {
                                    throw new NoSuchElementException();
                                }
                                Object key = keyTable[this.current];
                                this.current = this.findNextKey(this.current + 1);
                                return key;
                            }
                        };
                    }
                };
            }

            @Override
            ImmutableMapImpl<K, V> build() {
                if (this.size == 0) {
                    return ImmutableMapImpl.empty();
                }
                if (this.size == 1) {
                    int i = GenericArrays.indexOfNextNonNull(this.keyTable, 0);
                    return new SingleElementMap<K, V>(this.keyTable[i], this.valueTable[i]);
                }
                if (this.size == 2) {
                    int i1 = GenericArrays.indexOfNextNonNull(this.keyTable, 0);
                    K key1 = this.keyTable[i1];
                    V value1 = this.valueTable[i1];
                    int i2 = GenericArrays.indexOfNextNonNull(this.keyTable, i1 + 1);
                    K key2 = this.keyTable[i2];
                    V value2 = this.valueTable[i2];
                    return new TwoElementMap<K, V>(key1, value1, key2, value2);
                }
                this.valid = false;
                return new HashArrayBackedMap<K, V>(this.tableSize, this.size, this.maxProbingDistance, this.keyTable, this.valueTable);
            }

            @Override
            <V2> ImmutableMapImpl<K, V2> build(Function<V, V2> valueMappingFunction) {
                if (this.size == 0) {
                    return ImmutableMapImpl.empty();
                }
                if (this.size == 1) {
                    int i = GenericArrays.indexOfNextNonNull(this.keyTable, 0);
                    return new SingleElementMap<K, V2>(this.keyTable[i], valueMappingFunction.apply(this.valueTable[i]));
                }
                if (this.size == 2) {
                    int i1 = GenericArrays.indexOfNextNonNull(this.keyTable, 0);
                    K key1 = this.keyTable[i1];
                    V2 value1 = valueMappingFunction.apply(this.valueTable[i1]);
                    int i2 = GenericArrays.indexOfNextNonNull(this.keyTable, i1 + 1);
                    K key2 = this.keyTable[i2];
                    V2 value2 = valueMappingFunction.apply(this.valueTable[i2]);
                    return new TwoElementMap<K, V2>(key1, value1, key2, value2);
                }
                this.valid = false;
                return new HashArrayBackedMap<K, V2>(this.tableSize, this.size, this.maxProbingDistance, this.keyTable, GenericArrays.mapInPlace(this.valueTable, valueMappingFunction));
            }

            private int hashPosition(Object e) {
                return Hashing.hashPosition(this.tableSize, e);
            }

            private int findNextKey(int start) {
                if (this.keyTable == null) {
                    return -1;
                }
                for (int i = start; i < this.keyTable.length; ++i) {
                    if (this.keyTable[i] == null) continue;
                    return i;
                }
                return -1;
            }
        }
    }

    static abstract class InternalBuilder<K, V> {
        InternalBuilder() {
        }

        abstract InternalBuilder<K, V> with(K var1, V var2);

        InternalBuilder<K, V> withNonNull(K[] keyTable, V[] valueTable) {
            InternalBuilder<K, V> builder = this;
            for (int i = 0; i < keyTable.length; ++i) {
                K key = keyTable[i];
                if (key == null) continue;
                builder = builder.with(key, valueTable[i]);
            }
            return builder;
        }

        abstract boolean containsKey(Object var1);

        abstract V get(K var1);

        abstract ImmutableMapImpl<K, V> build();

        abstract <V2> ImmutableMapImpl<K, V2> build(Function<V, V2> var1);

        abstract int size();

        abstract int getEstimatedByteSize();

        abstract Set<K> keySet();

        InternalBuilder<K, V> probingOverheadFactor(short probingOverheadFactor) {
            return this;
        }

        static <K, V> InternalBuilder<K, V> create(int size) {
            int tableSize = Hashing.hashTableSize(size);
            if (tableSize != -1) {
                return new HashArrayBackedMap.Builder(tableSize);
            }
            return new MapBackedMap.Builder(size);
        }
    }

    static class MapBackedMap<K, V>
    extends ImmutableMapImpl<K, V> {
        private final Map<K, V> delegate;

        MapBackedMap(Map<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public V get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public Set<K> keySet() {
            return Collections.unmodifiableSet(this.delegate.keySet());
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(this.delegate.values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(this.delegate.entrySet());
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.delegate.forEach(action);
        }

        @Override
        int getEstimatedByteSize() {
            return (int)(40.0 + (double)(this.delegate.size() * 52) * 1.3);
        }

        static class Builder<K, V>
        extends InternalBuilder<K, V> {
            private final HashMap<K, V> delegate;

            Builder(int expectedCapacity) {
                this.delegate = new HashMap(expectedCapacity);
            }

            @Override
            Builder<K, V> with(K key, V value) {
                this.delegate.put(key, value);
                return this;
            }

            @Override
            int size() {
                return this.delegate.size();
            }

            @Override
            boolean containsKey(Object e) {
                return this.delegate.containsKey(e);
            }

            @Override
            V get(K k) {
                return this.delegate.get(k);
            }

            @Override
            int getEstimatedByteSize() {
                return (int)(40.0 + (double)(this.delegate.size() * 52) * 1.3);
            }

            @Override
            Set<K> keySet() {
                return this.delegate.keySet();
            }

            @Override
            ImmutableMapImpl<K, V> build() {
                return new MapBackedMap<K, V>(this.delegate);
            }

            @Override
            <V2> ImmutableMapImpl<K, V2> build(Function<V, V2> valueMappingFunction) {
                HashMap<K, V2> result = new HashMap<K, V2>(this.delegate.size());
                for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
                    result.put(entry.getKey(), valueMappingFunction.apply(entry.getValue()));
                }
                return new MapBackedMap(result);
            }
        }
    }
}

