/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.svg;

import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverShadowedG2d;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverRectangleSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;

public class DriverPathSvg
extends DriverShadowedG2d
implements UDriver<UPath, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPathSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UPath shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y, shape)) {
            return;
        }
        HColor color = param.getColor();
        HColor back = param.getBackcolor();
        if (color != null && back != null && color.equals(back)) {
            svg.setFillColor(color.toSvg(mapper));
            svg.setStrokeColor("");
            svg.setStrokeWidth(0.0, null);
        } else {
            DriverRectangleSvg.applyFillColor(svg, mapper, param);
            DriverRectangleSvg.applyStrokeColor(svg, mapper, param);
            svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        }
        svg.svgPath(x, y, shape, shape.getDeltaShadow());
    }
}

