/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.LabelManagementProcessor;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoop;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.labels.ILabelManager;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortSide;

public class SelfHyperLoopLabels {
    public int id = 0;
    private final List<LLabel> lLabels = new ArrayList<LLabel>();
    private final KVector size = new KVector();
    private final KVector position = new KVector();
    private final Direction layoutDirection;
    private final double labelLabelSpacing;
    private PortSide side;
    private Alignment alignment;
    private SelfLoopPort alignmentReferenceSLPort;

    public SelfHyperLoopLabels(SelfHyperLoop slLoop) {
        LNode lNode = slLoop.getSLHolder().getLNode();
        this.layoutDirection = lNode.getGraph().getProperty(LayeredOptions.DIRECTION);
        this.labelLabelSpacing = LGraphUtil.getIndividualOrInherited(lNode, LayeredOptions.SPACING_LABEL_LABEL);
    }

    public void addLLabels(Collection<LLabel> newLLabels) {
        for (LLabel newLLabel : newLLabels) {
            this.lLabels.add(newLLabel);
            this.updateSize(newLLabel);
        }
    }

    public List<LLabel> getLLabels() {
        return this.lLabels;
    }

    private void updateSize(LLabel newLLabel) {
        assert (this.lLabels.get(this.lLabels.size() - 1) == newLLabel);
        KVector newLLabelSize = newLLabel.getSize();
        if (this.layoutDirection.isHorizontal()) {
            this.size.x = Math.max(this.size.x, newLLabelSize.x);
            this.size.y += newLLabelSize.y;
            if (this.lLabels.size() > 1) {
                this.size.y += this.labelLabelSpacing;
            }
        } else {
            this.size.x += newLLabelSize.x;
            this.size.y = Math.max(this.size.y, newLLabelSize.y);
            if (this.lLabels.size() > 1) {
                this.size.x += this.labelLabelSpacing;
            }
        }
    }

    public void applyLabelManagement(ILabelManager labelManager, double targetWidth) {
        this.size.set(LabelManagementProcessor.doManageLabels(labelManager, this.lLabels, targetWidth, this.labelLabelSpacing, this.layoutDirection.isVertical()));
    }

    public void applyPlacement(KVector offset) {
        if (this.layoutDirection.isHorizontal()) {
            this.applyPlacementForHorizontalLayout(offset);
        } else {
            this.applyPlacementVerticalForVerticalLayout(offset);
        }
    }

    private void applyPlacementForHorizontalLayout(KVector offset) {
        double x = this.position.x;
        double y = this.position.y;
        for (LLabel lLabel : this.lLabels) {
            KVector labelPos = lLabel.getPosition();
            labelPos.x = this.alignment == Alignment.LEFT || this.side == PortSide.EAST ? x : (this.alignment == Alignment.RIGHT || this.side == PortSide.WEST ? x + this.size.x - lLabel.getSize().x : x + (this.size.x - lLabel.getSize().x) / 2.0);
            labelPos.y = y;
            labelPos.add(offset);
            y += lLabel.getSize().y + this.labelLabelSpacing;
        }
    }

    private void applyPlacementVerticalForVerticalLayout(KVector offset) {
        double x = this.position.x;
        double y = this.position.y;
        for (LLabel lLabel : this.lLabels) {
            KVector labelPos = lLabel.getPosition();
            labelPos.x = x;
            labelPos.y = this.side == PortSide.NORTH ? y + this.size.y - lLabel.getSize().y : y;
            labelPos.add(offset);
            x += lLabel.getSize().x + this.labelLabelSpacing;
        }
    }

    public KVector getSize() {
        return this.size;
    }

    public KVector getPosition() {
        return this.position;
    }

    public PortSide getSide() {
        return this.side;
    }

    public void setSide(PortSide side) {
        this.side = side;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public SelfLoopPort getAlignmentReferenceSLPort() {
        return this.alignmentReferenceSLPort;
    }

    public void setAlignmentReferenceSLPort(SelfLoopPort alignmentReferenceSLPort) {
        this.alignmentReferenceSLPort = alignmentReferenceSLPort;
    }

    public static enum Alignment {
        CENTER,
        LEFT,
        RIGHT,
        TOP;

    }
}

