# _IPropertyRunner
<span class="source-link">[[Source]](src/pony_check/property_helper.md#L-0-9)</span>

Interface for a PropertyRunner without the generic type parameter,
and only with the behaviours we are interested in.


```pony
interface tag _IPropertyRunner
```

## Public Behaviours

### expect_action
<span class="source-link">[[Source]](src/pony_check/property_helper.md#L-0-15)</span>


```pony
be expect_action(
  name: String val,
  round: (_Shrink val | _Run val))
```
#### Parameters

*   name: [String](builtin-String.md) val
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

---

### complete_action
<span class="source-link">[[Source]](src/pony_check/property_helper.md#L-0-17)</span>


```pony
be complete_action(
  name: String val,
  round: (_Shrink val | _Run val),
  ph: PropertyHelper val)
```
#### Parameters

*   name: [String](builtin-String.md) val
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)
*   ph: [PropertyHelper](pony_check-PropertyHelper.md) val

---

### fail_action
<span class="source-link">[[Source]](src/pony_check/property_helper.md#L-0-19)</span>


```pony
be fail_action(
  name: String val,
  round: (_Shrink val | _Run val),
  ph: PropertyHelper val)
```
#### Parameters

*   name: [String](builtin-String.md) val
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)
*   ph: [PropertyHelper](pony_check-PropertyHelper.md) val

---

### dispose_when_done
<span class="source-link">[[Source]](src/pony_check/property_helper.md#L-0-21)</span>


```pony
be dispose_when_done(
  disposable: DisposableActor tag,
  round: (_Shrink val | _Run val))
```
#### Parameters

*   disposable: [DisposableActor](builtin-DisposableActor.md) tag
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

---

### log
<span class="source-link">[[Source]](src/pony_check/property_helper.md#L-0-23)</span>


```pony
be log(
  msg: String val,
  verbose: Bool val = false)
```
#### Parameters

*   msg: [String](builtin-String.md) val
*   verbose: [Bool](builtin-Bool.md) val = false

---

