/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyLanguageFacadeKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J+\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\n\b\u0000\u0010\u0012*\u0004\u0018\u00010\u000e2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/psi/types/PyLiteralStringType;", "Lcom/jetbrains/python/psi/types/PyClassTypeImpl;", "cls", "Lcom/jetbrains/python/psi/PyClass;", "<init>", "(Lcom/jetbrains/python/psi/PyClass;)V", "getCls", "()Lcom/jetbrains/python/psi/PyClass;", "getName", "", "toString", "equals", "", "other", "", "hashCode", "", "acceptTypeVisitor", "T", "visitor", "Lcom/jetbrains/python/psi/types/PyTypeVisitor;", "(Lcom/jetbrains/python/psi/types/PyTypeVisitor;)Ljava/lang/Object;", "Companion", "intellij.python.psi.impl"})
public final class PyLiteralStringType
extends PyClassTypeImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PyClass cls;

    private PyLiteralStringType(PyClass cls) {
        super(cls, false);
        this.cls = cls;
    }

    @NotNull
    public final PyClass getCls() {
        return this.cls;
    }

    @Override
    @NotNull
    public String getName() {
        return "LiteralString";
    }

    @Override
    @NotNull
    public String toString() {
        return "PyLiteralStringType";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        Object object = other;
        PyLiteralStringType pyLiteralStringType = object instanceof PyLiteralStringType ? (PyLiteralStringType)((Object)object) : null;
        if (pyLiteralStringType == null) {
            return false;
        }
        PyLiteralStringType otherLiteralString = pyLiteralStringType;
        return Intrinsics.areEqual((Object)this.cls, (Object)otherLiteralString.cls);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.cls};
        return Objects.hash(objectArray);
    }

    @Nullable
    public <T> T acceptTypeVisitor(@NotNull PyTypeVisitor<T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        if (visitor instanceof PyTypeVisitorExt) {
            return ((PyTypeVisitorExt)visitor).visitPyLiteralStringType(this);
        }
        return (T)visitor.visitPyClassType((PyClassType)this);
    }

    public /* synthetic */ PyLiteralStringType(PyClass cls, DefaultConstructorMarker $constructor_marker) {
        this(cls);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/psi/types/PyLiteralStringType$Companion;", "", "<init>", "()V", "create", "Lcom/jetbrains/python/psi/types/PyClassType;", "anchor", "Lcom/intellij/psi/PsiElement;", "match", "", "expected", "Lcom/jetbrains/python/psi/types/PyLiteralStringType;", "actual", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PyClassType create(@NotNull PsiElement anchor) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            PyClassType strType = PyBuiltinCache.Companion.getInstance(anchor).getStrType();
            if (Registry.Companion.is("python.type.hints.literal.string") && strType != null && anchor instanceof PyElement) {
                PsiFile psiFile = anchor.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                if (PyLanguageFacadeKt.getEffectiveLanguageLevel((PsiFile)psiFile).isPy3K()) {
                    PyClass pyClass = strType.getPyClass();
                    Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
                    return new PyLiteralStringType(pyClass, null);
                }
            }
            return strType;
        }

        public final boolean match(@NotNull PyLiteralStringType expected, @NotNull PyClassType actual) {
            Intrinsics.checkNotNullParameter((Object)((Object)expected), (String)"expected");
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            return actual instanceof PyLiteralStringType || actual instanceof PyLiteralType && Intrinsics.areEqual((Object)expected.getPyClass(), (Object)((PyLiteralType)actual).getPyClass());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

