/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseCommaChange;
import ai.grazie.rules.ru.AgreementSet;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.ru.ComplexPrepositions;
import ai.grazie.rules.ru.IntroductoryConstructions;
import ai.grazie.rules.ru.Negation;
import ai.grazie.rules.ru.ParticleSeparation;
import ai.grazie.rules.ru.PrepositionForm;
import ai.grazie.rules.ru.PunctuationRules;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.List;

class GrammarRules {
    private static final NodePattern letUs = NodePattern.N.form("\u0434\u0430\u0432\u0430\u0439|\u0434\u0430\u0432\u0430\u0439\u0442\u0435");
    private static final String SHORT_PT_SINGLE_N = "\u0412 \u043a\u0440\u0430\u0442\u043a\u0438\u0445 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u0438\u044f\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043e\u0434\u0438\u043d\u0430\u0440\u043d\u043e\u0435 \u00ab\u043d\u00bb";
    private static final String COLLECTIVE_NUMERAL_MESSAGE = "\u0421\u043e\u0431\u0438\u0440\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0447\u0438\u0441\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0435 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u044e\u0442\u0441\u044f \u0441 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u0436\u0435\u043d\u0441\u043a\u043e\u0433\u043e \u0440\u043e\u0434\u0430";
    private static final String TJSJA_MESSAGE = "\u0415\u0441\u043b\u0438 \u0432\u044b \u043e\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0435 \u00ab\u0447\u0442\u043e \u0434\u0435\u043b\u0430\u0422\u042c\u00bb, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u00ab-\u0422\u042c\u0441\u044f\u00bb";
    private static final String TSJA_MESSAGE = "\u0415\u0441\u043b\u0438 \u0432\u044b \u043e\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0435 \u00ab\u0447\u0442\u043e \u0434\u0435\u043b\u0430\u0435\u0422\u00bb, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u00ab-\u0422\u0441\u044f\u00bb";
    private static final String MISSING_CLAUSE_CONJ_MESSAGE = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d \u0441\u043e\u044e\u0437 \u043c\u0435\u0436\u0434\u0443 \u043e\u0434\u043d\u043e\u0440\u043e\u0434\u043d\u044b\u043c\u0438 \u0433\u043b\u0430\u0433\u043e\u043b\u0430\u043c\u0438?";
    static final NodePattern finiteTsa = NodePattern.N.pos("VB:(Real|Past|Fut).*").form(".*\u0442\u0441\u044f");
    static final NodePattern aclAfterHead = NodePattern.N.withHeadRelation("acl").directlyAfterHead();

    GrammarRules() {
    }

    private static NodePattern missingClauseConjunction() {
        return RussianTreePatterns.finiteVerb.message(MISSING_CLAUSE_CONJ_MESSAGE).noLemma("\u0438\u0434\u0442\u0438|\u043f\u043e\u0439\u0442\u0438|\u043c\u043e\u0447\u044c").andNot(letUs).withDependent("conj|aux:pass", RussianTreePatterns.finiteVerb.andNot(RussianTreePatterns.infinitive).afterHead().noDependents("mark|cc|nsubj").noDependents("advmod", NodePattern.N.beforeHead().pos("CONJ")).noDependents("advcl|parataxis", NodePattern.N.pos("DPT:.*").beforeHead()).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obl").withPhraseStart(NodePattern.PUNCT))).withPhraseStart(NodePattern.not(NodePattern.PUNCT).includeIntoReport().directlyAfter(NodePattern.not(NodePattern.PUNCT).andNot(PunctuationRules.sentenceBoundary).andNot(RussianTreePatterns.wordInternalPunctuation).includeIntoReport()).correct(NodeCorrector.insertAfterPrevious(",")).correct(NodeCorrector.insertBefore("\u0438 "))).andNot(RussianTreePatterns.whPhrase)).noDependents("conj", NodePattern.not(RussianTreePatterns.finiteVerb));
    }

    private static NodePattern tsaConfusion() {
        NodePattern needed = NodePattern.N.lemma("\u043d\u0443\u0436\u043d\u043e|\u043d\u0430\u0434\u043e|\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e|\u0434\u043e\u043b\u0436\u043d\u044b\u0439|\u043d\u0435\u043b\u044c\u0437\u044f|\u043c\u043e\u0436\u043d\u043e");
        NodePattern possiblyIntroMaybe = NodePattern.N.form("\u043c\u043e\u0436\u0435\u0442").includeIntoReport().and((node, match) -> {
            PhraseCommaChange change = CommaLicense.forWord(node, CommaLicense.NeedCommas.around).addMissingCommas(PunctuationRules.commaOrOpening, PunctuationRules.commaOrClosing);
            return change == null ? null : match.withCorrector(change.correct());
        });
        return NodePattern.or(finiteTsa.andOr(NodePattern.N.withHead("xcomp", NodePattern.or(possiblyIntroMaybe, needed, NodePattern.N.pos("VB:.*").andNot(letUs))).andNot(NodePattern.N.directlyAfter(NodePattern.N.lemma("\u043b\u0435\u0436\u0430\u0442\u044c|\u0441\u0438\u0434\u0435\u0442\u044c|\u0441\u0442\u043e\u044f\u0442\u044c|\u0438\u0434\u0442\u0438"))), NodePattern.N.withHead("conj", possiblyIntroMaybe).noDependents("nsubj.*|csubj.*"), NodePattern.N.withHead("csubj", needed), NodePattern.N.withDependent("aux(:pass)?"), NodePattern.N.withDependent("advmod", needed), aclAfterHead, NodePattern.N.form(".+[\u0443\u0438]\u0442\u0441\u044f").pos(".*:PL:P3").noDependents("nsubj.*|csubj.*").withDependent("iobj", Case.D.posPattern)).and(CommonPatterns.replacementProduces("(.+)\u0442\u0441\u044f", "$1\u0442\u044c\u0441\u044f", "VB:INF:.*")).message(TJSJA_MESSAGE).correct(NodeCorrector.inflect("VB:.*", "VB:INF:.*")), NodePattern.N.pos("VB:INF:.*").form(".*\u0442\u044c\u0441\u044f").and(NodePattern.or(NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.or(Case.Nom.posPattern, Case.R.posPattern, NodePattern.N.pos("ADV"))).noDependents("cop").noHeadRelation("xcomp"), NodePattern.N.withHeadRelation("ccomp|root").withDependent("csubj"), NodePattern.N.withDependent("parataxis", IntroductoryConstructions.maybeLikeAdv).noHeadRelation("xcomp"), NodePattern.N.withHead("csubj", IntroductoryConstructions.maybeLikeAdv), NodePattern.N.form("\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u0441\u044f").withDependent("obl", NodePattern.N.pos("ADV")), NodePattern.N.withDependent("mark", NodePattern.N.form("\u043a\u0430\u043a")).withHeadRelation("parataxis"))).noDependents("aux.*").and(CommonPatterns.replacementProduces("(.+)\u0442\u044c\u0441\u044f", "$1\u0442\u0441\u044f", "VB:(Real|Fut):.*")).message(TSJA_MESSAGE).correct(NodeCorrector.regexReplace("(.*)\u0442\u044c\u0441\u044f", "$1\u0442\u0441\u044f"))).includeIntoReport();
    }

    private static NodePattern nnConfusion() {
        String singleN = "(.*[\u0430\u0435\u0438\u043e\u0443\u044d\u044e\u044f\u0451])\u043d([\u0430-\u043c\u043e-\u044f]{1,3})";
        String doubleN = "(.*[\u0430\u0435\u0438\u043e\u0443\u044d\u044e\u044f\u0451])\u043d\u043d([\u0430-\u043c\u043e-\u044f]{1,3})";
        String toDoubleN = "$1\u043d\u043d$2";
        String toSingleN = "$1\u043d$2";
        return NodePattern.or(NodePattern.N.pos("ADJ:.*").noPos("NN.*").form(singleN).andOr(NodePattern.N.withDependent("obl|iobj|flat.*|nmod"), NodePattern.N.withDependent("advmod", NodePattern.N.form("\u0432\u044b\u0448\u0435|\u043d\u0438\u0436\u0435"))).and(CommonPatterns.replacementProduces(singleN, toDoubleN, "PT:.*")).message("\u0412 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u0438\u044f\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u0432\u043e\u0439\u043d\u043e\u0435 \u00ab\u043d\u00bb").correct(NodeCorrector.regexReplace(singleN, toDoubleN)), NodePattern.N.form(doubleN).andOr(NodePattern.N.pos("PT:.*").andNot(NodePattern.N.lemma("\u043d\u0430\u0437\u0432\u0430\u0442\u044c")).noForm("(\u043f\u0435\u0440\u0435|\u043f\u043e\u0434\u043e?|\u043f\u0440\u0435\u0434[\u0438\u043e]?|\u043f\u0440\u043e|\u0440\u0430\u0437\u043e?|(\u0431\u0435|\u0432|\u0432\u043e|\u0438\u0437|\u043d\u0438|\u043e\u0431\u0435|\u0440\u0430|\u0440\u043e)[\u0437\u0441]|\u043f\u0440[\u0435\u0438]).*").noDependents("obl.*|iobj|flat.*").noDependents("advmod", NodePattern.not(NodePattern.N.form("\u0445\u043e\u0442\u044f"))).and(CommonPatterns.replacementProduces(doubleN, toSingleN, "ADJ:.*")).message("\u0412 \u043f\u0440\u0438\u043b\u0430\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043e\u0434\u0438\u043d\u0430\u0440\u043d\u043e\u0435 \u00ab\u043d\u00bb"), NodePattern.N.pos("ADJ:Short:.*").withDependent("nsubj(:pass)?").withHeadRelation("root|advcl|acl.*|ccomp").and(CommonPatterns.replacementProduces(doubleN, toSingleN, "PT_Short:.*")).message(SHORT_PT_SINGLE_N)).correct(NodeCorrector.regexReplace(doubleN, toSingleN)));
    }

    private static NodePattern collectiveNumeralSelection() {
        return NodePattern.N.withHead("nummod:gov", NodePattern.or(NodePattern.N.form("\u0432\u043e\u043b\u043a\u043e\u0432|\u043c\u0435\u0434\u0432\u0435\u0434\u0435\u0439|\u043a\u043e\u0442\u043e\u0432|\u043a\u0430\u0431\u0430\u043d\u043e\u0432").message("\u0421\u043e\u0431\u0438\u0440\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0447\u0438\u0441\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0435 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u044e\u0442\u0441\u044f \u0441 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f\u043c\u0438 \u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445 \u043e\u0441\u043e\u0431\u0435\u0439 \u0436\u0438\u0432\u043e\u0442\u043d\u044b\u0445"), NodePattern.N.pos("NN:.*:Fem:PL:R").markAs("FemHead").message(COLLECTIVE_NUMERAL_MESSAGE))).andOr(NodePattern.N.form("\u043f\u044f\u0442\u0435\u0440\u043e|\u0448\u0435\u0441\u0442\u0435\u0440\u043e|\u0441\u0435\u043c\u0435\u0440\u043e").correct(NodeCorrector.regexReplace("(.*)\u0435\u0440\u043e", "$1\u044c")), NodePattern.N.form("\u0434\u0432\u043e\u0435|\u0442\u0440\u043e\u0435|\u0447\u0435\u0442\u0432\u0435\u0440\u043e").includeIntoReport().and((num, match) -> {
            boolean fem = match.findMarkedNode("FemHead") != null;
            Node noun = num.head();
            String newNum = num.hasForm("\u0442\u0440\u043e\u0435") ? "\u0442\u0440\u0438" : (num.hasForm("\u0447\u0435\u0442\u0432\u0435\u0440\u043e") ? "\u0447\u0435\u0442\u044b\u0440\u0435" : (fem ? "\u0434\u0432\u0435" : "\u0434\u0432\u0430"));
            NodeCorrector changeNum = NodeCorrector.replace(num, newNum);
            NodeCorrector changeHead = fem ? NodeCorrector.inflect(noun, "NN.*", "NN:.*:Fem:PL:Nom") : NodeCorrector.inflect(noun, "NN:(.*):(.*):PL:R", "NN:$1:$2:Sin:R");
            return match.withCorrector(changeHead.join(changeNum));
        }));
    }

    static List<Rule> priorityRules() {
        return List.of(new Rule.PatternRule("Grammar.TSA_CONFUSION", "\u0412\u044b\u0431\u043e\u0440 -\u0442\u0441\u044f/-\u0442\u044c\u0441\u044f", "\u041e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u0433\u043b\u0430\u0433\u043e\u043b\u043e\u0432, \u043e\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u044e\u0449\u0438\u0445\u0441\u044f \u043d\u0430 -\u0442\u0441\u044f/-\u0442\u044c\u0441\u044f.", "http://tsya.ru", () -> GrammarRules.tsaConfusion(), new Example("\u042f \u0438 \u043d\u0435 \u0441\u043e\u0431\u0438\u0440\u0430\u043b\u0441\u044f <b>\u0436\u0435\u043d\u0438\u0442\u0441\u044f</b>!", "\u042f \u0438 \u043d\u0435 \u0441\u043e\u0431\u0438\u0440\u0430\u043b\u0441\u044f <b>\u0436\u0435\u043d\u0438\u0442\u044c\u0441\u044f</b>!")), new Rule.PatternRule("Grammar.PARTICLE_SEPARATION", "\u0421\u043b\u0438\u0442\u043d\u043e\u0435, \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e\u0435 \u0438\u043b\u0438 \u0434\u0435\u0444\u0438\u0441\u043d\u043e\u0435 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441\u043b\u043e\u0432", "\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e\u0442\u0441\u044f \u0447\u0430\u0441\u0442\u044b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u043c \u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0438 \u043f\u0440\u0438\u0441\u0442\u0430\u0432\u043e\u043a, \u043f\u0440\u0435\u0434\u043b\u043e\u0433\u043e\u0432 \u0438 \u0447\u0430\u0441\u0442\u0438\u0446.", "http://www.gramota.ru/class/coach/tbgramota/45_122", () -> ParticleSeparation.pattern(), new Example("\u0417\u0434\u0435\u0441\u044c \u0435\u0441\u0442\u044c <b>\u043a\u0442\u043e \u043d\u0438\u0431\u0443\u0434\u044c</b>?", "\u0417\u0434\u0435\u0441\u044c \u0435\u0441\u0442\u044c <b>\u043a\u0442\u043e-\u043d\u0438\u0431\u0443\u0434\u044c</b>?")).honorCrazyParses());
    }

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Grammar.NN_CONFUSION", "\u041f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 -\u043d-/-\u043d\u043d-", "\u041e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0438 -\u043d-/-\u043d\u043d- \u0432 \u043f\u0440\u0438\u043b\u0430\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0438 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u0438\u044f\u0445.", "https://obrazovaka.ru/russkiy-yazyk/n-i-nn-v-prilagatelnyh-i-prichastiyah", () -> GrammarRules.nnConfusion(), new Example("\u042d\u0442\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 <b>\u0441\u0432\u044f\u0437\u0430\u043d\u043d\u043e</b> \u0441 \u043d\u0435\u0431\u044b\u0432\u0430\u043b\u044b\u043c \u0441\u043f\u0440\u043e\u0441\u043e\u043c \u043d\u0430 \u0431\u0438\u043b\u0435\u0442\u044b", "\u042d\u0442\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 <b>\u0441\u0432\u044f\u0437\u0430\u043d\u043e</b> \u0441 \u043d\u0435\u0431\u044b\u0432\u0430\u043b\u044b\u043c \u0441\u043f\u0440\u043e\u0441\u043e\u043c \u043d\u0430 \u0431\u0438\u043b\u0435\u0442\u044b")), new Rule.PatternRule("Grammar.COLLECTIVE_NUMERAL_SELECTION", "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u0441\u043e\u0431\u0438\u0440\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0447\u0438\u0441\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445", "\u0421\u043e\u0431\u0438\u0440\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0447\u0438\u0441\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 (\u0434\u0432\u043e\u0435, \u0442\u0440\u043e\u0435 \u0438 \u0442.\u043f.) \u043d\u0435 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u044e\u0442\u0441\u044f \u0441 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u0436\u0435\u043d\u0441\u043a\u043e\u0433\u043e \u0440\u043e\u0434\u0430 \u0438\u043b\u0438 \u0441 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u043c\u0438 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f\u043c\u0438 \u0436\u0438\u0432\u043e\u0442\u043d\u044b\u0445.", "http://www.hi-edu.ru/e-books/xbook107/01/part-085.htm", () -> GrammarRules.collectiveNumeralSelection(), new Example("\u041a \u043d\u0430\u043c \u043f\u0440\u0438\u0448\u043b\u0438 <b>\u0448\u0435\u0441\u0442\u0435\u0440\u043e</b> \u043d\u0430\u0448\u0438\u0445 \u043b\u0443\u0447\u0448\u0438\u0445 \u043f\u043e\u0434\u0440\u0443\u0433", "\u041a \u043d\u0430\u043c \u043f\u0440\u0438\u0448\u043b\u0438 <b>\u0448\u0435\u0441\u0442\u044c</b> \u043d\u0430\u0448\u0438\u0445 \u043b\u0443\u0447\u0448\u0438\u0445 \u043f\u043e\u0434\u0440\u0443\u0433")), new Rule.PatternRule("Grammar.PREPOSITION_FORM_CHOICE", "\u0412\u044b\u0431\u043e\u0440 \u0444\u043e\u0440\u043c\u044b \u043f\u0440\u0435\u0434\u043b\u043e\u0433\u043e\u0432 (\u00ab\u043e\u00bb/\u00ab\u043e\u0431\u00bb/\u00ab\u043e\u0431\u043e\u00bb, \u00ab\u043a\u00bb/\u00ab\u043a\u043e\u00bb \u0438 \u0442.\u043f.)", "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u043e\u0440\u043c\u044b \u043f\u0440\u0435\u0434\u043b\u043e\u0433\u043e\u0432 \u0441 \u0431\u0435\u0433\u043b\u044b\u043c\u0438 \u0433\u043b\u0430\u0441\u043d\u044b\u043c\u0438 \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u043f\u043e\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u043b\u043e\u0432.", "http://new.gramota.ru/spravka/letters/69-ko-dnu", () -> PrepositionForm.pattern(), new Example("\u0441\u043f\u043e\u0442\u043a\u043d\u0443\u043b\u0441\u044f <b>\u043e </b>\u043e\u0441\u0442\u0440\u044b\u0439 \u043a\u0430\u043c\u0435\u043d\u044c", "\u0441\u043f\u043e\u0442\u043a\u043d\u0443\u043b\u0441\u044f <b>\u043e\u0431</b> \u043e\u0441\u0442\u0440\u044b\u0439 \u043a\u0430\u043c\u0435\u043d\u044c")).honorCrazyParses(), new Rule.PatternRule("Grammar.AGREEMENT", "\u0421\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u0435 \u0438 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", "\u041e\u0448\u0438\u0431\u043a\u0438 \u0432\u044b\u0431\u043e\u0440\u0430 \u0440\u043e\u0434\u0430, \u0447\u0438\u0441\u043b\u0430, \u043f\u0430\u0434\u0435\u0436\u0430 \u0438 \u043b\u0438\u0446\u0430 \u0440\u0430\u0437\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u0435\u0439 \u0440\u0435\u0447\u0438.\n<p>\n\u0421\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u0435 \u2014 \u0441\u0432\u044f\u0437\u044c, \u043f\u0440\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435 \u0441\u043b\u043e\u0432\u0430 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442 \u0433\u0440\u0430\u043c\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0444\u043e\u0440\u043c\u044b \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430.\n\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u043f\u0440\u0438\u043b\u0430\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u043e\u0433\u043b\u0430\u0441\u0443\u044e\u0442\u0441\u044f \u0441 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u043f\u043e \u0440\u043e\u0434\u0443, \u0447\u0438\u0441\u043b\u0443 \u0438 \u043f\u0430\u0434\u0435\u0436\u0443, \u0430 \u043f\u043e\u0434\u043b\u0435\u0436\u0430\u0449\u0435\u0435 \u0441\u043e \u0441\u043a\u0430\u0437\u0443\u0435\u043c\u044b\u043c \u2014 \u043f\u043e \u0440\u043e\u0434\u0443, \u0447\u0438\u0441\u043b\u0443 \u0438 \u043b\u0438\u0446\u0430.\n<p>\n\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u2014 \u0441\u0432\u044f\u0437\u044c, \u043f\u0440\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0435 \u0441\u043b\u043e\u0432\u043e \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u0435\u0442\u0441\u044f \u0432 \u043f\u0430\u0434\u0435\u0436\u0435, \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u043c\u043e\u043c \u0433\u043b\u0430\u0432\u043d\u044b\u043c \u0441\u043b\u043e\u0432\u043e\u043c.\n", "https://russkiiyazyk.ru/sintaksis/vidyi-slovosochetaniy.html", () -> AgreementSet.checksMakeSense.and((main, match) -> {
            AgreementSet set = AgreementSet.create(main);
            return set == null ? null : set.check(match);
        }), new Example("\u0421\u043e\u043b\u043d\u0446\u0435 <b>\u0432\u044b\u0448\u043b\u0430</b> \u0438\u0437-\u0437\u0430 \u0442\u0443\u0447", "\u0421\u043e\u043b\u043d\u0446\u0435 <b>\u0432\u044b\u0448\u043b\u043e</b> \u0438\u0437-\u0437\u0430 \u0442\u0443\u0447"), new Example("\u041e\u043d\u0430 \u0441\u0430\u043c\u0430\u044f \u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u0430\u044f <i>\u0432</i> <b>\u0410\u043c\u0435\u0440\u0438\u043a\u0438</b>.", "\u041e\u043d\u0430 \u0441\u0430\u043c\u0430\u044f \u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u0430\u044f <i>\u0432</i> <b>\u0410\u043c\u0435\u0440\u0438\u043a\u0435</b>.")).honorCrazyParses(), new Rule.PatternRule("Grammar.MISSING_CLAUSE_CONJUNCTION", "\u0413\u043b\u0430\u0433\u043e\u043b\u044b \u0431\u0435\u0437 \u0441\u043e\u044e\u0437\u0430", "\u041e\u0434\u043d\u043e\u0440\u043e\u0434\u043d\u044b\u0435 \u0433\u043b\u0430\u0433\u043e\u043b\u044b, \u043c\u0435\u0436\u0434\u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u043c\u0438, \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e, \u0437\u0430\u0431\u044b\u0442 \u0441\u043e\u044e\u0437 \u0438\u043b\u0438 \u0437\u0430\u043f\u044f\u0442\u0430\u044f.", "https://ru.wikipedia.org/wiki/\u041e\u0434\u043d\u043e\u0440\u043e\u0434\u043d\u044b\u0435_\u0447\u043b\u0435\u043d\u044b_\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f", () -> GrammarRules.missingClauseConjunction(), new Example("\u041e\u043d\u0430 <b>\u0441\u043f\u0438\u0442 \u0432\u0438\u0434\u0438\u0442</b> \u0441\u043e\u043d.", "\u041e\u043d\u0430 <b>\u0441\u043f\u0438\u0442, \u0432\u0438\u0434\u0438\u0442</b> \u0441\u043e\u043d.", "\u041e\u043d\u0430 <b>\u0441\u043f\u0438\u0442 \u0438 \u0432\u0438\u0434\u0438\u0442</b> \u0441\u043e\u043d.")), new Rule.PatternRule("Grammar.COMPLEX_PREPOSITIONS", "\u0421\u043b\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0433\u0438", "\u041f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0433\u043e\u0432, \u0441\u043e\u0441\u0442\u043e\u044f\u0449\u0438\u0445 \u0438\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u0441\u043b\u043e\u0432.", "https://protext.by/blog/velikij-i-moguchij/trudnyie-predlogi/", () -> ComplexPrepositions.pattern(), new Example("\u041e\u043d\u0438 <b>\u0432\u0442\u0435\u0447\u0435\u043d\u0438\u0438</b> \u0434\u0432\u0443\u0445 \u043d\u0435\u0434\u0435\u043b\u044c \u043f\u043e\u0441\u043c\u043e\u0442\u0440\u044f\u0442.", "\u041e\u043d\u0438 <b>\u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0435</b> \u0434\u0432\u0443\u0445 \u043d\u0435\u0434\u0435\u043b\u044c \u043f\u043e\u0441\u043c\u043e\u0442\u0440\u044f\u0442."), new Example("<b>\u0412 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435</b> \u043a\u043d\u0438\u0433\u0438 \u0441\u0442\u0430\u043b\u043e \u0435\u0449\u0451 \u0438\u043d\u0442\u0435\u0440\u0435\u0441\u043d\u0435\u0435.", "<b>\u0412 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0438</b> \u043a\u043d\u0438\u0433\u0438 \u0441\u0442\u0430\u043b\u043e \u0435\u0449\u0451 \u0438\u043d\u0442\u0435\u0440\u0435\u0441\u043d\u0435\u0435.")), new Rule.PatternRule("Grammar.NE_NI", "\u0412\u044b\u0431\u043e\u0440 \u00ab\u043d\u0435\u00bb \u0438\u043b\u0438 \u00ab\u043d\u0438\u00bb", "\u0427\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab\u043d\u0435\u00bb \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u044f, \u0430 \u0447\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab\u043d\u0438\u00bb \u2013 \u0434\u043b\u044f \u0443\u0441\u0438\u043b\u0435\u043d\u0438\u044f.", "https://therules.ru/vowels-13/", () -> Negation.neNi(), new Example("\u041b\u044e\u0431\u0438\u043c \u043c\u044b \u041b\u0435\u0440\u043c\u043e\u043d\u0442\u043e\u0432\u0430 <b>\u043d\u0438</b> \u0437\u0430 \u044d\u0442\u043e \u0441\u0442\u0438\u0445\u043e\u0442\u0432\u043e\u0440\u0435\u043d\u0438\u0435", "\u041b\u044e\u0431\u0438\u043c \u043c\u044b \u041b\u0435\u0440\u043c\u043e\u043d\u0442\u043e\u0432\u0430 <b>\u043d\u0435</b> \u0437\u0430 \u044d\u0442\u043e \u0441\u0442\u0438\u0445\u043e\u0442\u0432\u043e\u0440\u0435\u043d\u0438\u0435")), new Rule.PatternRule("Grammar.NE_SEPARATION", "\u0421\u043b\u0438\u0442\u043d\u043e\u0435 \u0438\u043b\u0438 \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e\u0435 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u00ab\u043d\u0435\u00bb", "\u0421 \u0433\u043b\u0430\u0433\u043e\u043b\u0430\u043c\u0438 \u0447\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab\u043d\u0435\u00bb \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u043e. \u0421 \u043e\u0441\u0442\u0430\u043b\u044c\u043d\u044b\u043c\u0438 \u0447\u0430\u0441\u0442\u044f\u043c\u0438 \u0440\u0435\u0447\u0438 \u2014 \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u043e, \u0435\u0441\u043b\u0438 \u0432\u044b\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u0435, \u0438 \u0441\u043b\u0438\u0442\u043d\u043e \u0434\u043b\u044f \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f.", "http://new.gramota.ru/biblio/readingroom/rules/138-def-19-24", () -> Negation.neSeparation(), new Example("\u0415\u0441\u043b\u0438 \u0432\u0434\u0440\u0443\u0433 <b>\u043d\u0435 \u0443\u0434\u043e\u0431\u043d\u043e</b>, \u0442\u043e \u0434\u0432\u0438\u0433\u0430\u0439\u0442\u0435", "\u0415\u0441\u043b\u0438 \u0432\u0434\u0440\u0443\u0433 <b>\u043d\u0435\u0443\u0434\u043e\u0431\u043d\u043e</b>, \u0442\u043e \u0434\u0432\u0438\u0433\u0430\u0439\u0442\u0435")).honorCrazyParses(), new Rule.PatternRule("Grammar.WORD_REPETITION", "\u041f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u0438\u0435 \u0441\u043b\u043e\u0432\u0430", "\u0414\u0432\u0430 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0445 \u0441\u043b\u043e\u0432\u0430 \u043f\u043e\u0434\u0440\u044f\u0434 \u0441\u043a\u043e\u0440\u0435\u0435 \u0432\u0441\u0435\u0433\u043e \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043e\u0448\u0438\u0431\u043a\u043e\u0439.", null, () -> CommonPatterns.repeatedWord((n1, n2) -> true).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyAfter(CommonPatterns.capitalizedMiddle)).andNot(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.form("-"))).message("\u0421\u043b\u0443\u0447\u0430\u0439\u043d\u043e\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u0438\u0435 \u00ab$_\u00bb?"), new Example("\u041f\u043e\u0432\u0442\u043e\u0440\u0451\u043d\u043d\u043e\u0435 <b>\u0441\u043b\u043e\u0432\u043e \u0441\u043b\u043e\u0432\u043e</b> \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0448\u0438\u0431\u043a\u043e\u0439", "\u041f\u043e\u0432\u0442\u043e\u0440\u0451\u043d\u043d\u043e\u0435 <b>\u0441\u043b\u043e\u0432\u043e</b> \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0448\u0438\u0431\u043a\u043e\u0439")));
    }
}

