# The PEP 484 type hints stub file for the krita module.
#
# Generated by SIP 6.15.1


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui
from PyQt6 import QtXml
from PyQt6 import QtWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class Shape(QtCore.QObject):

    def parentShape(self) -> 'Shape|None': ...
    def isSelected(self) -> bool: ...
    def deselect(self) -> None: ...
    def select(self) -> None: ...
    def toSvg(self, prependStyles: bool = ..., stripTextMode: bool = ...) -> str: ...
    def updateAbsolute(self, box: QtCore.QRectF) -> None: ...
    def update(self) -> None: ...
    def remove(self) -> bool: ...
    def absoluteTransformation(self) -> QtGui.QTransform: ...
    def setTransformation(self, matrix: QtGui.QTransform) -> None: ...
    def transformation(self) -> QtGui.QTransform: ...
    def setPosition(self, point: QtCore.QPointF) -> None: ...
    def position(self) -> QtCore.QPointF: ...
    def boundingBox(self) -> QtCore.QRectF: ...
    def setGeometryProtected(self, protect: bool) -> None: ...
    def geometryProtected(self) -> bool: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def selectable(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def visible(self) -> bool: ...
    def setZIndex(self, zindex: int) -> None: ...
    def zIndex(self) -> int: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...
    def type(self) -> str: ...


class GroupShape(Shape):

    def children(self) -> list[Shape]: ...


class Canvas(QtCore.QObject):

    def view(self) -> 'View|None': ...
    def levelOfDetailMode(self) -> bool: ...
    def setLevelOfDetailMode(self, enable: bool) -> None: ...
    def wrapAroundMode(self) -> bool: ...
    def setWrapAroundMode(self, enable: bool) -> None: ...
    def setMirror(self, value: bool) -> None: ...
    def mirror(self) -> bool: ...
    def setRotation(self, angle: float) -> None: ...
    def rotation(self) -> float: ...
    def resetRotation(self) -> None: ...
    def resetZoom(self) -> None: ...
    def pan(self, offset: QtCore.QPoint) -> None: ...
    def setPreferredCenter(self, imagePos: QtCore.QPointF) -> None: ...
    def preferredCenter(self) -> QtCore.QPointF: ...
    def setZoomLevel(self, value: float) -> None: ...
    def zoomLevel(self) -> float: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Channel(QtCore.QObject):

    def setPixelData(self, value: QtCore.QByteArray|bytes|bytearray|memoryview, rect: QtCore.QRect) -> None: ...
    def pixelData(self, rect: QtCore.QRect) -> QtCore.QByteArray: ...
    def bounds(self) -> QtCore.QRect: ...
    def channelSize(self) -> int: ...
    def position(self) -> int: ...
    def name(self) -> str: ...
    def setVisible(self, value: bool) -> None: ...
    def visible(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class DockWidgetFactoryBase(PyQt6.sip.wrapper):

    class DockPosition(enum.Enum):
        DockTornOff = ... # type: DockWidgetFactoryBase.DockPosition
        DockTop = ... # type: DockWidgetFactoryBase.DockPosition
        DockBottom = ... # type: DockWidgetFactoryBase.DockPosition
        DockRight = ... # type: DockWidgetFactoryBase.DockPosition
        DockLeft = ... # type: DockWidgetFactoryBase.DockPosition
        DockMinimized = ... # type: DockWidgetFactoryBase.DockPosition

    @typing.overload
    def __init__(self, _id: str|None, _dockPosition: 'DockWidgetFactoryBase.DockPosition') -> None: ...
    @typing.overload
    def __init__(self, a0: 'DockWidgetFactoryBase') -> None: ...

    def id(self) -> str: ...
    def createDockWidget(self) -> QtWidgets.QDockWidget|None: ...


class DockWidget(QtWidgets.QDockWidget):

    def __init__(self) -> None: ...

    def canvasChanged(self, canvas: Canvas|None) -> None: ...
    def canvas(self) -> Canvas|None: ...


class Document(QtCore.QObject):

    def setAudioTracks(self, files: collections.abc.Iterable[str|None]) -> bool: ...
    def audioTracks(self) -> list[str]: ...
    def setAudioLevel(self, level: float) -> None: ...
    def audioLevel(self) -> float: ...
    def setGuidesConfig(self, guidesConfig: 'GuidesConfig|None') -> None: ...
    def guidesConfig(self) -> 'GuidesConfig|None': ...
    def autosave(self) -> bool: ...
    def setAutosave(self, active: bool) -> None: ...
    def removeAnnotation(self, type: str|None) -> None: ...
    def setAnnotation(self, type: str|None, description: str|None, annotation: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def annotation(self, type: str|None) -> QtCore.QByteArray: ...
    def annotationDescription(self, type: str|None) -> str: ...
    def annotationTypes(self) -> list[str]: ...
    def setCurrentTime(self, time: int) -> None: ...
    def currentTime(self) -> int: ...
    def playBackEndTime(self) -> int: ...
    def playBackStartTime(self) -> int: ...
    def setPlayBackRange(self, start: int, stop: int) -> None: ...
    def animationLength(self) -> int: ...
    def fullClipRangeEndTime(self) -> int: ...
    def setFullClipRangeEndTime(self, endTime: int) -> None: ...
    def fullClipRangeStartTime(self) -> int: ...
    def setFullClipRangeStartTime(self, startTime: int) -> None: ...
    def setFramesPerSecond(self, fps: int) -> None: ...
    def framesPerSecond(self) -> int: ...
    def importAnimation(self, files: collections.abc.Iterable[str|None], firstFrame: int, step: int) -> bool: ...
    def bounds(self) -> QtCore.QRect: ...
    def setModified(self, modified: bool) -> None: ...
    def modified(self) -> bool: ...
    def setGuidesLocked(self, locked: bool) -> None: ...
    def setGuidesVisible(self, visible: bool) -> None: ...
    def setVerticalGuides(self, lines: collections.abc.Iterable[float]) -> None: ...
    def setHorizontalGuides(self, lines: collections.abc.Iterable[float]) -> None: ...
    def refreshProjection(self) -> None: ...
    def tryBarrierLock(self) -> bool: ...
    def waitForDone(self) -> None: ...
    def unlock(self) -> None: ...
    def lock(self) -> None: ...
    def thumbnail(self, w: int, h: int) -> QtGui.QImage: ...
    def projection(self, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> QtGui.QImage: ...
    def createColorizeMask(self, name: str|None) -> 'ColorizeMask|None': ...
    def createTransformMask(self, name: str|None) -> 'TransformMask|None': ...
    def createTransparencyMask(self, name: str|None) -> 'TransparencyMask|None': ...
    def createSelectionMask(self, name: str|None) -> 'SelectionMask|None': ...
    @typing.overload
    def createFilterMask(self, name: str|None, filter: 'Filter', selection: 'Selection') -> 'FilterMask|None': ...
    @typing.overload
    def createFilterMask(self, name: str|None, filter: 'Filter', selection_source: 'Node|None') -> 'FilterMask|None': ...
    def createFileLayer(self, name: str|None, fileName: str|None, scalingMethod: str|None, scalingFilter: str|None = ...) -> 'FileLayer|None': ...
    def createVectorLayer(self, name: str|None) -> 'VectorLayer|None': ...
    def createFillLayer(self, name: str|None, filterName: str|None, configuration: 'InfoObject', selection: 'Selection') -> 'FillLayer|None': ...
    def createFilterLayer(self, name: str|None, filter: 'Filter', selection: 'Selection') -> 'FilterLayer|None': ...
    def createCloneLayer(self, name: str|None, source: 'Node|None') -> 'CloneLayer|None': ...
    def createGroupLayer(self, name: str|None) -> 'GroupLayer|None': ...
    def createNode(self, name: str|None, nodeType: str|None) -> 'Node|None': ...
    def saveAs(self, filename: str|None) -> bool: ...
    def save(self) -> bool: ...
    def shearImage(self, angleX: float, angleY: float) -> None: ...
    def rotateImage(self, radians: float) -> None: ...
    def scaleImage(self, w: int, h: int, xres: int, yres: int, strategy: str|None) -> None: ...
    def resizeImage(self, x: int, y: int, w: int, h: int) -> None: ...
    def flatten(self) -> None: ...
    def exportImage(self, filename: str|None, exportConfiguration: 'InfoObject') -> bool: ...
    def crop(self, x: int, y: int, w: int, h: int) -> None: ...
    def close(self) -> bool: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def setYRes(self, yRes: float) -> None: ...
    def yRes(self) -> float: ...
    def setXRes(self, xRes: float) -> None: ...
    def xRes(self) -> float: ...
    def setYOffset(self, y: int) -> None: ...
    def yOffset(self) -> int: ...
    def setXOffset(self, x: int) -> None: ...
    def xOffset(self) -> int: ...
    def setWidth(self, value: int) -> None: ...
    def width(self) -> int: ...
    def setSelection(self, value: 'Selection|None') -> None: ...
    def selection(self) -> 'Selection|None': ...
    def rootNode(self) -> 'Node|None': ...
    def setResolution(self, value: int) -> None: ...
    def resolution(self) -> int: ...
    def setName(self, value: str|None) -> None: ...
    def name(self) -> str: ...
    def setHeight(self, value: int) -> None: ...
    def height(self) -> int: ...
    def setFileName(self, value: str|None) -> None: ...
    def fileName(self) -> str: ...
    def setDocumentInfo(self, document: str|None) -> None: ...
    def documentInfo(self) -> str: ...
    def setBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> bool: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setColorSpace(self, value: str|None, colorDepth: str|None, colorProfile: str|None) -> bool: ...
    def setColorProfile(self, colorProfile: str|None) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def colorDepth(self) -> str: ...
    def setBatchmode(self, value: bool) -> None: ...
    def batchmode(self) -> bool: ...
    def nodeByUniqueID(self, id: QtCore.QUuid) -> 'Node|None': ...
    def nodeByName(self, node: str|None) -> 'Node|None': ...
    def topLevelNodes(self) -> list['Node']: ...
    def setActiveNode(self, value: 'Node|None') -> None: ...
    def activeNode(self) -> 'Node|None': ...
    def clone(self) -> 'Document|None': ...
    def guidesLocked(self) -> bool: ...
    def guidesVisible(self) -> bool: ...
    def verticalGuides(self) -> list[float]: ...
    def horizontalGuides(self) -> list[float]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Filter(QtCore.QObject):

    def __init__(self) -> None: ...

    def startFilter(self, node: 'Node|None', x: int, y: int, w: int, h: int) -> bool: ...
    def apply(self, node: 'Node|None', x: int, y: int, w: int, h: int) -> None: ...
    def setConfiguration(self, value: 'InfoObject|None') -> None: ...
    def configuration(self) -> 'InfoObject|None': ...
    def setName(self, a0: str|None) -> None: ...
    def name(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class InfoObject(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def property(self, key: str|None) -> typing.Any: ...
    def setProperty(self, key: str|None, value: typing.Any) -> None: ...
    def setProperties(self, value: dict[str|None, typing.Any]) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Extension(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def createActions(self, window: 'Window|None') -> None: ...
    def setup(self) -> None: ...


class View(QtCore.QObject):

    def flakeToImageTransform(self) -> QtGui.QTransform: ...
    def flakeToCanvasTransform(self) -> QtGui.QTransform: ...
    def flakeToDocumentTransform(self) -> QtGui.QTransform: ...
    def selectedNodes(self) -> list['Node']: ...
    def showFloatingMessage(self, message: str|None, icon: QtGui.QIcon, timeout: int, priority: int) -> None: ...
    def setDisablePressure(self, value: bool) -> None: ...
    def disablePressure(self) -> bool: ...
    def setGlobalAlphaLock(self, value: bool) -> None: ...
    def globalAlphaLock(self) -> bool: ...
    def setEraserMode(self, value: bool) -> None: ...
    def eraserMode(self) -> bool: ...
    def setPatternSize(self, size: float) -> None: ...
    def patternSize(self) -> float: ...
    def setPaintingFlow(self, flow: float) -> None: ...
    def paintingFlow(self) -> float: ...
    def setBrushRotation(self, brushRotation: float) -> None: ...
    def brushRotation(self) -> float: ...
    def setBrushSize(self, brushSize: float) -> None: ...
    def brushSize(self) -> float: ...
    def setPaintingOpacity(self, opacity: float) -> None: ...
    def paintingOpacity(self) -> float: ...
    def setHDRGamma(self, gamma: float) -> None: ...
    def HDRGamma(self) -> float: ...
    def setHDRExposure(self, exposure: float) -> None: ...
    def HDRExposure(self) -> float: ...
    def setCurrentBlendingMode(self, blendingMode: str|None) -> None: ...
    def currentBlendingMode(self) -> str: ...
    def setCurrentGradient(self, resource: 'Resource|None') -> None: ...
    def currentGradient(self) -> 'Resource|None': ...
    def setCurrentPattern(self, resource: 'Resource|None') -> None: ...
    def currentPattern(self) -> 'Resource|None': ...
    def setCurrentBrushPreset(self, resource: 'Resource|None') -> None: ...
    def currentBrushPreset(self) -> 'Resource|None': ...
    def setBackGroundColor(self, color: 'ManagedColor|None') -> None: ...
    def backgroundColor(self) -> 'ManagedColor|None': ...
    def setForeGroundColor(self, color: 'ManagedColor|None') -> None: ...
    def foregroundColor(self) -> 'ManagedColor|None': ...
    def activateResource(self, resource: 'Resource|None') -> None: ...
    def canvas(self) -> Canvas|None: ...
    def setVisible(self) -> None: ...
    def visible(self) -> bool: ...
    def setDocument(self, document: Document|None) -> None: ...
    def document(self) -> Document|None: ...
    def window(self) -> 'Window|None': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Window(QtCore.QObject):

    activeViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    themeChanged: typing.ClassVar[QtCore.pyqtSignal]
    windowClosed: typing.ClassVar[QtCore.pyqtSignal]
    def createAction(self, id: str|None, text: str|None = ..., menuLocation: str|None = ...) -> QtGui.QAction|None: ...
    def close(self) -> None: ...
    def activate(self) -> None: ...
    def activeView(self) -> View|None: ...
    def showView(self, view: View|None) -> None: ...
    def addView(self, document: Document|None) -> View|None: ...
    def views(self) -> list[View]: ...
    def dockers(self) -> list[QtWidgets.QDockWidget]: ...
    def qwindow(self) -> QtWidgets.QMainWindow|None: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Krita(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    @staticmethod
    def getAppDataLocation() -> str: ...
    @staticmethod
    def krita_i18nc(context: str|None, text: str|None) -> str: ...
    @staticmethod
    def krita_i18n(text: str|None) -> str: ...
    @staticmethod
    def fromVariant(v: typing.Any) -> QtCore.QObject|None: ...
    @staticmethod
    def instance() -> 'Krita|None': ...
    def readSetting(self, group: str|None, name: str|None, defaultValue: str|None) -> str: ...
    def writeSetting(self, group: str|None, name: str|None, value: str|None) -> None: ...
    def addDockWidgetFactory(self, _factory: DockWidgetFactoryBase|None) -> None: ...
    def addExtension(self, _extension: Extension|None) -> None: ...
    def icon(self, iconName: str|None) -> QtGui.QIcon: ...
    def openWindow(self) -> Window|None: ...
    def openDocument(self, filename: str|None) -> Document|None: ...
    def extensions(self) -> list[Extension]: ...
    def createDocument(self, width: int, height: int, name: str|None, colorModel: str|None, colorDepth: str|None, profile: str|None, resolution: float) -> Document|None: ...
    def recentDocuments(self) -> list[str]: ...
    def resources(self, type: str|None) -> typing.Any: ...
    def windows(self) -> list[Window]: ...
    def activeWindow(self) -> Window|None: ...
    def views(self) -> list[View]: ...
    def version(self) -> str: ...
    def notifier(self) -> 'Notifier|None': ...
    def addProfile(self, profilePath: str|None) -> bool: ...
    def profiles(self, colorModel: str|None, ColorDepth: str|None) -> list[str]: ...
    def filterStrategies(self) -> list[str]: ...
    def colorDepths(self, colorModel: str|None) -> list[str]: ...
    def colorModels(self) -> list[str]: ...
    def filter(self, name: str|None) -> Filter|None: ...
    def filters(self) -> list[str]: ...
    def dockers(self) -> list[QtWidgets.QDockWidget]: ...
    def documents(self) -> list[Document]: ...
    def action(self, name: str|None) -> QtGui.QAction|None: ...
    def actions(self) -> list[QtGui.QAction]: ...
    def setBatchmode(self, value: bool) -> None: ...
    def batchmode(self) -> bool: ...
    def setActiveDocument(self, value: Document|None) -> None: ...
    def activeDocument(self) -> Document|None: ...


class Node(QtCore.QObject):

    def paintAbility(self) -> str: ...
    def paintPath(self, path: QtGui.QPainterPath, strokeStyle: str|None = ..., fillStyle: str|None = ...) -> None: ...
    def paintEllipse(self, rect: QtCore.QRectF, strokeStyle: str|None = ..., fillStyle: str|None = ...) -> None: ...
    def paintPolygon(self, points: collections.abc.Iterable[QtCore.QPointF], strokeStyle: str|None = ..., fillStyle: str|None = ...) -> None: ...
    def paintRectangle(self, rect: QtCore.QRectF, strokeStyle: str|None = ..., fillStyle: str|None = ...) -> None: ...
    def paintLine(self, pointOne: QtCore.QPoint, pointTwo: QtCore.QPoint, pressureOne: float = ..., pressureTwo: float = ..., strokeStyle: str|None = ...) -> None: ...
    def uniqueId(self) -> QtCore.QUuid: ...
    def index(self) -> int: ...
    def setLayerStyleFromAsl(self, asl: str|None) -> bool: ...
    def layerStyleToAsl(self) -> str: ...
    def thumbnail(self, w: int, h: int) -> QtGui.QImage: ...
    def shearNode(self, angleX: float, angleY: float) -> None: ...
    def cropNode(self, x: int, y: int, w: int, h: int) -> None: ...
    def rotateNode(self, radians: float) -> None: ...
    def scaleNode(self, origin: QtCore.QPointF, width: int, height: int, strategy: str|None) -> None: ...
    def mergeDown(self) -> 'Node|None': ...
    def save(self, filename: str|None, xRes: float, yRes: float, exportConfiguration: InfoObject, exportRect: QtCore.QRect = ...) -> None: ...
    def duplicate(self) -> 'Node|None': ...
    def remove(self) -> bool: ...
    def position(self) -> QtCore.QPoint: ...
    def move(self, x: int, y: int) -> None: ...
    def bounds(self) -> QtCore.QRect: ...
    def setPixelData(self, value: QtCore.QByteArray|bytes|bytearray|memoryview, x: int, y: int, w: int, h: int) -> bool: ...
    def projectionPixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def pixelDataAtTime(self, x: int, y: int, w: int, h: int, time: int) -> QtCore.QByteArray: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def setVisible(self, value: bool) -> None: ...
    def hasKeyframeAtTime(self, frameNumber: int) -> bool: ...
    def visible(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> str: ...
    def parentNode(self) -> 'Node|None': ...
    def setOpacity(self, value: int) -> None: ...
    def opacity(self) -> int: ...
    def setName(self, value: str|None) -> None: ...
    def name(self) -> str: ...
    def hasExtents(self) -> bool: ...
    def setLocked(self, value: bool) -> None: ...
    def locked(self) -> bool: ...
    def setInheritAlpha(self, value: bool) -> None: ...
    def inheritAlpha(self) -> bool: ...
    def setColorSpace(self, colorModel: str|None, colorDepth: str|None, colorProfile: str|None) -> bool: ...
    def setColorProfile(self, colorProfile: str|None) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def setColorLabel(self, value: int) -> None: ...
    def colorLabel(self) -> int: ...
    def collapsed(self) -> bool: ...
    def setCollapsed(self, collapsed: bool) -> None: ...
    def enableAnimation(self) -> None: ...
    def animated(self) -> bool: ...
    def colorDepth(self) -> str: ...
    def setChildNodes(self, nodes: collections.abc.Iterable['Node']) -> None: ...
    def removeChildNode(self, child: 'Node|None') -> bool: ...
    def addChildNode(self, child: 'Node|None', above: 'Node|None') -> bool: ...
    def findChildNodes(self, name: str|None = ..., recursive: bool = ..., partialMatch: bool = ..., type: str|None = ..., colorLabelIndex: int = ...) -> list['Node']: ...
    def childNodes(self) -> list['Node']: ...
    def channels(self) -> list[Channel]: ...
    def setBlendingMode(self, value: str|None) -> None: ...
    def blendingMode(self) -> str: ...
    def setAlphaLocked(self, value: bool) -> None: ...
    def alphaLocked(self) -> bool: ...
    def clone(self) -> 'Node|None': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class GroupLayer(Node):

    def passThroughMode(self) -> bool: ...
    def setPassThroughMode(self, passthrough: bool) -> None: ...
    def type(self) -> str: ...


class CloneLayer(Node):

    def setSourceNode(self, node: Node|None) -> None: ...
    def sourceNode(self) -> Node|None: ...
    def type(self) -> str: ...


class FilterLayer(Node):

    def filter(self) -> Filter|None: ...
    def setFilter(self, filter: Filter) -> None: ...
    def type(self) -> str: ...


class FileLayer(Node):

    def path(self) -> str: ...
    def scalingFilter(self) -> str: ...
    def scalingMethod(self) -> str: ...
    def resetCache(self) -> None: ...
    def setProperties(self, FileName: str|None, ScalingMethod: str|None, scalingFilter: str|None) -> None: ...
    def type(self) -> str: ...


class FillLayer(Node):

    def filterConfig(self) -> InfoObject|None: ...
    def generatorName(self) -> str: ...
    def setGenerator(self, filterName: str|None, filterConfig: InfoObject|None) -> bool: ...
    def type(self) -> str: ...


class VectorLayer(Node):

    def setAntialiased(self, antialiased: bool) -> None: ...
    def isAntialiased(self) -> bool: ...
    def createGroupShape(self, name: str|None, shapes: collections.abc.Iterable[Shape]) -> Shape|None: ...
    def shapesInRect(self, rect: QtCore.QRectF, omitHiddenShapes: bool = ..., containedMode: bool = ...) -> list[Shape]: ...
    def shapeAtPosition(self, point: QtCore.QPointF) -> Shape|None: ...
    def addShapesFromSvg(self, svg: str|None) -> list[Shape]: ...
    def toSvg(self) -> str: ...
    def shapes(self) -> list[Shape]: ...
    def type(self) -> str: ...


class FilterMask(Node):

    def filter(self) -> Filter|None: ...
    def setFilter(self, filter: Filter) -> None: ...
    def type(self) -> str: ...


class SelectionMask(Node):

    def setSelection(self, selection: 'Selection|None') -> None: ...
    def selection(self) -> 'Selection|None': ...
    def type(self) -> str: ...


class TransparencyMask(Node):

    def setSelection(self, selection: 'Selection|None') -> None: ...
    def selection(self) -> 'Selection|None': ...
    def type(self) -> str: ...


class TransformMask(Node):

    def fromXML(self, xml: str|None) -> bool: ...
    def toXML(self) -> str: ...
    def finalAffineTransform(self) -> QtGui.QTransform: ...
    def type(self) -> str: ...


class ColorizeMask(Node):

    def setEditKeyStrokes(self, enabled: bool) -> None: ...
    def editKeyStrokes(self) -> bool: ...
    def setShowOutput(self, enabled: bool) -> None: ...
    def showOutput(self) -> bool: ...
    def resetCache(self) -> None: ...
    def updateMask(self, force: bool = ...) -> None: ...
    def limitToDeviceBounds(self) -> bool: ...
    def setLimitToDeviceBounds(self, value: bool) -> None: ...
    def cleanUpAmount(self) -> float: ...
    def setCleanUpAmount(self, value: float) -> None: ...
    def edgeDetectionSize(self) -> float: ...
    def setEdgeDetectionSize(self, value: float) -> None: ...
    def useEdgeDetection(self) -> bool: ...
    def setUseEdgeDetection(self, value: bool) -> None: ...
    def setKeyStrokePixelData(self, value: QtCore.QByteArray|bytes|bytearray|memoryview, color: 'ManagedColor|None', x: int, y: int, w: int, h: int) -> bool: ...
    def keyStrokePixelData(self, color: 'ManagedColor|None', x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def transparencyIndex(self) -> int: ...
    def removeKeyStroke(self, color: 'ManagedColor|None') -> None: ...
    def initializeKeyStrokeColors(self, colors: collections.abc.Iterable['ManagedColor'], transparentIndex: int = ...) -> None: ...
    def keyStrokesColors(self) -> list['ManagedColor']: ...
    def type(self) -> str: ...


class Notifier(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    configurationChanged: typing.ClassVar[QtCore.pyqtSignal]
    windowCreated: typing.ClassVar[QtCore.pyqtSignal]
    windowIsBeingCreated: typing.ClassVar[QtCore.pyqtSignal]
    viewClosed: typing.ClassVar[QtCore.pyqtSignal]
    viewCreated: typing.ClassVar[QtCore.pyqtSignal]
    imageClosed: typing.ClassVar[QtCore.pyqtSignal]
    imageSaved: typing.ClassVar[QtCore.pyqtSignal]
    imageCreated: typing.ClassVar[QtCore.pyqtSignal]
    applicationClosing: typing.ClassVar[QtCore.pyqtSignal]
    def setActive(self, value: bool) -> None: ...
    def active(self) -> bool: ...


class Resource(QtCore.QObject):

    def setImage(self, image: QtGui.QImage) -> None: ...
    def image(self) -> QtGui.QImage: ...
    def filename(self) -> str: ...
    def setName(self, value: str|None) -> None: ...
    def name(self) -> str: ...
    def type(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Selection(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def setPixelData(self, value: QtCore.QByteArray|bytes|bytearray|memoryview, x: int, y: int, w: int, h: int) -> None: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def symmetricdifference(self, selection: 'Selection|None') -> None: ...
    def intersect(self, selection: 'Selection|None') -> None: ...
    def subtract(self, selection: 'Selection|None') -> None: ...
    def add(self, selection: 'Selection|None') -> None: ...
    def replace(self, selection: 'Selection|None') -> None: ...
    def selectAll(self, node: Node|None, value: int) -> None: ...
    def select(self, x: int, y: int, w: int, h: int, value: int) -> None: ...
    def resize(self, w: int, h: int) -> None: ...
    def invert(self) -> None: ...
    def smooth(self) -> None: ...
    def shrink(self, xRadius: int, yRadius: int, edgeLock: bool) -> None: ...
    def grow(self, xradius: int, yradius: int) -> None: ...
    def feather(self, radius: int) -> None: ...
    def border(self, xRadius: int, yRadius: int) -> None: ...
    def dilate(self) -> None: ...
    def erode(self) -> None: ...
    def paste(self, destination: Node|None, x: int, y: int) -> None: ...
    def cut(self, node: Node|None) -> None: ...
    def copy(self, node: Node|None) -> None: ...
    def contract(self, value: int) -> None: ...
    def clear(self) -> None: ...
    def move(self, x: int, y: int) -> None: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def duplicate(self) -> 'Selection|None': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Preset(QtCore.QObject):

    def __init__(self, resource: Resource|None) -> None: ...

    def fromXML(self, xml: str|None) -> None: ...
    def toXML(self) -> str: ...


class PresetChooser(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    presetClicked: typing.ClassVar[QtCore.pyqtSignal]
    presetSelected: typing.ClassVar[QtCore.pyqtSignal]
    def currentPreset(self) -> Resource|None: ...
    def setCurrentPreset(self, resource: Resource|None) -> None: ...


class Scratchpad(QtWidgets.QWidget):

    def __init__(self, view: View|None, defaultColor: QtGui.QColor|QtCore.Qt.GlobalColor|int, parent: QtWidgets.QWidget|None = ...) -> None: ...

    viewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    contentChanged: typing.ClassVar[QtCore.pyqtSignal]
    scaleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def copyScratchpadImageData(self) -> QtGui.QImage: ...
    def fillPattern(self, transform: QtGui.QTransform = ...) -> None: ...
    def fillDocument(self, fullContent: bool = ...) -> None: ...
    def fillLayer(self, fullContent: bool = ...) -> None: ...
    def fillGradient(self, gradientVectorStart: QtCore.QPoint = ..., gradientVectorEnd: QtCore.QPoint = ..., gradientShape: str|None = ..., gradientRepeat: str|None = ..., reverseGradient: bool = ..., dither: bool = ...) -> None: ...
    def fillTransparent(self) -> None: ...
    def fillForeground(self) -> None: ...
    def fillBackground(self) -> None: ...
    def fillDefault(self) -> None: ...
    def contentBounds(self) -> QtCore.QRect: ...
    def viewportBounds(self) -> QtCore.QRect: ...
    def panCenter(self) -> None: ...
    def panTo(self, x: int, y: int) -> None: ...
    def scale(self) -> float: ...
    def scaleReset(self) -> None: ...
    def scaleToFit(self) -> None: ...
    def setScale(self, scale: float) -> None: ...
    def loadScratchpadImage(self, image: QtGui.QImage) -> None: ...
    def setFillColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setMode(self, modeName: str|None) -> None: ...
    def setCanvasZoomLink(self, value: bool) -> None: ...
    def canvasZoomLink(self) -> bool: ...
    def linkCanvasZoom(self, value: bool) -> None: ...
    def setModeManually(self, value: bool) -> None: ...
    def clear(self) -> None: ...


class Palette(QtCore.QObject):

    def __init__(self, resource: Resource|None) -> None: ...

    def save(self) -> bool: ...
    def moveGroup(self, groupName: str|None, groupNameInsertBefore: str|None) -> None: ...
    def renameGroup(self, oldGroupName: str|None, newGroupName: str|None) -> None: ...
    def changeGroupName(self, oldGroupName: str|None, newGroupName: str|None) -> None: ...
    def removeEntryFromGroup(self, index: int, groupName: str|None) -> None: ...
    def removeEntry(self, index: int) -> None: ...
    def addEntry(self, entry: 'Swatch', groupName: str|None) -> None: ...
    def entryByIndexFromGroup(self, index: int, groupName: str|None) -> 'Swatch|None': ...
    def colorSetEntryFromGroup(self, index: int, groupName: str|None) -> 'Swatch|None': ...
    def entryByIndex(self, index: int) -> 'Swatch|None': ...
    def colorSetEntryByIndex(self, index: int) -> 'Swatch|None': ...
    def slotCountGroup(self, name: str|None) -> int: ...
    def slotCount(self) -> int: ...
    def colorsCountGroup(self, name: str|None) -> int: ...
    def colorsCountTotal(self) -> int: ...
    def removeGroup(self, name: str|None, keepColors: bool) -> None: ...
    def addGroup(self, name: str|None) -> None: ...
    def groupNames(self) -> list[str]: ...
    def setComment(self, comment: str|None) -> None: ...
    def comment(self) -> str: ...
    def setRowCountGroup(self, rows: int, name: str|None) -> None: ...
    def rowCountGroup(self, name: str|None) -> int: ...
    def rowCount(self) -> int: ...
    def setColumnCount(self, columns: int) -> None: ...
    def columnCount(self) -> int: ...
    def numberOfEntries(self) -> int: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class PaletteView(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    entrySelectedBackGround: typing.ClassVar[QtCore.pyqtSignal]
    entrySelectedForeGround: typing.ClassVar[QtCore.pyqtSignal]
    def trySelectClosestColor(self, color: 'ManagedColor|None') -> None: ...
    def removeSelectedEntryWithDialog(self) -> bool: ...
    def addGroupWithDialog(self) -> bool: ...
    def addEntryWithDialog(self, color: 'ManagedColor|None') -> bool: ...
    def setPalette(self, palette: Palette|None) -> None: ...


class ManagedColor(QtCore.QObject):

    def __init__(self, colorModel: str|None, colorDepth: str|None, colorProfile: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    def __ne__(self, other: object): ...
    def toQString(self) -> str: ...
    def fromXML(self, xml: str|None) -> None: ...
    def toXML(self) -> str: ...
    def setComponents(self, values: collections.abc.Iterable[float]) -> None: ...
    def componentsOrdered(self) -> list[float]: ...
    def components(self) -> list[float]: ...
    def setColorSpace(self, colorModel: str|None, colorDepth: str|None, colorProfile: str|None) -> bool: ...
    def setColorProfile(self, colorProfile: str|None) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def colorDepth(self) -> str: ...
    @staticmethod
    def fromQColor(qcolor: QtGui.QColor|QtCore.Qt.GlobalColor|int, canvas: Canvas|None = ...) -> 'ManagedColor|None': ...
    def colorForCanvas(self, canvas: Canvas|None) -> QtGui.QColor: ...
    def __eq__(self, other: object): ...


class Swatch(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def isValid(self) -> bool: ...
    def setSpotColor(self, spotColor: bool) -> None: ...
    def spotColor(self) -> bool: ...
    def setColor(self, color: ManagedColor|None) -> None: ...
    def color(self) -> ManagedColor|None: ...
    def setId(self, id: str|None) -> None: ...
    def id(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class KisCubicCurvePoint(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'KisCubicCurvePoint') -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, setAsCorner: bool = ...) -> None: ...

    def __ne__(self, other: object): ...
    def setAsCorner(self, newIsSetAsCorner: bool) -> None: ...
    def setPosition(self, newPosition: QtCore.QPointF) -> None: ...
    def setY(self, newY: float) -> None: ...
    def setX(self, newX: float) -> None: ...
    def isSetAsCorner(self) -> bool: ...
    def position(self) -> QtCore.QPointF: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def __eq__(self, other: object): ...


class KisCubicCurve(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, points: collections.abc.Iterable[QtCore.QPointF]) -> None: ...
    @typing.overload
    def __init__(self, points: collections.abc.Iterable[KisCubicCurvePoint]) -> None: ...
    @typing.overload
    def __init__(self, curveString: str|None) -> None: ...
    @typing.overload
    def __init__(self, curve: 'KisCubicCurve') -> None: ...

    def fromString(self, a0: str|None) -> None: ...
    def toString(self) -> str: ...
    def floatTransfer(self, size: int = ...) -> list[float]: ...
    def uint16Transfer(self, size: int = ...) -> list[int]: ...
    @staticmethod
    def interpolateLinear(normalizedValue: float, transfer: collections.abc.Iterable[float]) -> float: ...
    def name(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def isConstant(self, x: float) -> bool: ...
    def isIdentity(self) -> bool: ...
    def removePoint(self, idx: int) -> None: ...
    @typing.overload
    def addPoint(self, point: KisCubicCurvePoint) -> int: ...
    @typing.overload
    def addPoint(self, position: QtCore.QPointF, setAsCorner: bool) -> int: ...
    @typing.overload
    def addPoint(self, point: QtCore.QPointF) -> int: ...
    def setPointAsCorner(self, idx: int, setAsCorner: bool) -> None: ...
    def setPointPosition(self, idx: int, position: QtCore.QPointF) -> None: ...
    @typing.overload
    def setPoint(self, idx: int, point: KisCubicCurvePoint) -> None: ...
    @typing.overload
    def setPoint(self, idx: int, position: QtCore.QPointF, setAsCorner: bool) -> None: ...
    @typing.overload
    def setPoint(self, idx: int, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def setPoints(self, points: collections.abc.Iterable[QtCore.QPointF]) -> None: ...
    @typing.overload
    def setPoints(self, points: collections.abc.Iterable[KisCubicCurvePoint]) -> None: ...
    def curvePoints(self) -> list[KisCubicCurvePoint]: ...
    def points(self) -> list[QtCore.QPointF]: ...
    def value(self, x: float) -> float: ...


class AngleSelector(QtCore.QObject):

    def __init__(self) -> None: ...

    angleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def flip(self, orientations: QtCore.Qt.Orientation) -> None: ...
    @typing.overload
    @staticmethod
    def flipAngle(angle: float, orientations: QtCore.Qt.Orientation) -> float: ...
    @typing.overload
    @staticmethod
    def flipAngle(angle: float, minimum: float, maximum: float, a3: QtCore.Qt.Orientation) -> typing.Tuple[float, bool]: ...
    @typing.overload
    @staticmethod
    def closestCoterminalAngleInRange(angle: float, minimum: float, maximum: float) -> typing.Tuple[float, bool]: ...
    @typing.overload
    def closestCoterminalAngleInRange(self, angle: float) -> typing.Tuple[float, bool]: ...
    def useFlatSpinBox(self, newUseFlatSpinBox: bool) -> None: ...
    def setIncreasingDirection(self, newIncreasingDirection: str|None) -> None: ...
    def setWidgetsHeight(self, newHeight: int) -> None: ...
    def setFlipOptionsMode(self, newMode: str|None) -> None: ...
    def setWrapping(self, newWrapping: bool) -> None: ...
    def setPrefix(self, newPrefix: str|None) -> None: ...
    def setRange(self, newMinimum: float, newMaximum: float) -> None: ...
    def setMinimum(self, newMinimum: float) -> None: ...
    def setMaximum(self, newMaximum: float) -> None: ...
    def setDecimals(self, newNumberOfDecimals: int) -> None: ...
    def setResetAngle(self, newResetAngle: float) -> None: ...
    def setSnapAngle(self, newSnapAngle: float) -> None: ...
    def isUsingFlatSpinBox(self) -> bool: ...
    def increasingDirection(self) -> str: ...
    def widgetsHeight(self) -> int: ...
    def flipOptionsMode(self) -> str: ...
    def wrapping(self) -> bool: ...
    def prefix(self) -> str: ...
    def minimum(self) -> float: ...
    def maximum(self) -> float: ...
    def decimals(self) -> int: ...
    def resetAngle(self) -> float: ...
    def snapAngle(self) -> float: ...
    def angle(self) -> float: ...
    def reset(self) -> None: ...
    def setAngle(self, newAngle: float) -> None: ...
    def widget(self) -> QtWidgets.QWidget|None: ...


class IntParseSpinBox(QtCore.QObject):

    def __init__(self) -> None: ...

    noMoreParsingError: typing.ClassVar[QtCore.pyqtSignal]
    errorWhileParsing: typing.ClassVar[QtCore.pyqtSignal]
    def veryCleanText(self) -> str: ...
    def isLastValid(self) -> bool: ...
    def setValue(self, value: int, overwriteExpression: bool = ...) -> None: ...
    def stepBy(self, steps: int) -> None: ...
    def widget(self) -> QtWidgets.QSpinBox|None: ...


class DoubleParseSpinBox(QtCore.QObject):

    def __init__(self) -> None: ...

    noMoreParsingError: typing.ClassVar[QtCore.pyqtSignal]
    errorWhileParsing: typing.ClassVar[QtCore.pyqtSignal]
    def veryCleanText(self) -> str: ...
    def isLastValid(self) -> bool: ...
    def setValue(self, value: float, overwriteExpression: bool = ...) -> None: ...
    def stepBy(self, steps: int) -> None: ...
    def widget(self) -> QtWidgets.QDoubleSpinBox|None: ...


class SliderSpinBox(QtCore.QObject):

    def __init__(self) -> None: ...

    draggingFinished: typing.ClassVar[QtCore.pyqtSignal]
    def setSoftMaximum(self, newSoftMaximum: int) -> None: ...
    def setSoftMinimum(self, newSoftMinimum: int) -> None: ...
    def setSoftRange(self, newSoftMinimum: int, newSoftMaximum: int) -> None: ...
    def setFastSliderStep(self, newFastSliderStep: int) -> None: ...
    def setBlockUpdateSignalOnDrag(self, newBlockUpdateSignalOnDrag: bool) -> None: ...
    def setExponentRatio(self, newExponentRatio: float) -> None: ...
    def setMaximum(self, newMaximum: int, computeNewFastSliderStep: bool = ...) -> None: ...
    def setMinimum(self, newMinimum: int, computeNewFastSliderStep: bool = ...) -> None: ...
    def setRange(self, newMinimum: int, newMaximum: int, computeNewFastSliderStep: bool = ...) -> None: ...
    def setValue(self, newValue: int) -> None: ...
    def isDragging(self) -> bool: ...
    def softMaximum(self) -> int: ...
    def softMinimum(self) -> int: ...
    def fastSliderStep(self) -> int: ...
    def widget(self) -> QtWidgets.QWidget|None: ...


class DoubleSliderSpinBox(QtCore.QObject):

    def __init__(self) -> None: ...

    draggingFinished: typing.ClassVar[QtCore.pyqtSignal]
    def setSoftMaximum(self, newSoftMaximum: float) -> None: ...
    def setSoftMinimum(self, newSoftMinimum: float) -> None: ...
    def setSoftRange(self, newSoftMinimum: float, newSoftMaximum: float) -> None: ...
    def setFastSliderStep(self, newFastSliderStep: float) -> None: ...
    def setBlockUpdateSignalOnDrag(self, newBlockUpdateSignalOnDrag: bool) -> None: ...
    def setExponentRatio(self, newExponentRatio: float) -> None: ...
    def setMaximum(self, newMaximum: float, computeNewFastSliderStep: bool = ...) -> None: ...
    def setMinimum(self, newMinimum: float, computeNewFastSliderStep: bool = ...) -> None: ...
    def setRange(self, newMinimum: float, newMaximum: float, newNumberOfDecimals: int = ..., computeNewFastSliderStep: bool = ...) -> None: ...
    def setValue(self, newValue: float) -> None: ...
    def isDragging(self) -> bool: ...
    def softMaximum(self) -> float: ...
    def softMinimum(self) -> float: ...
    def fastSliderStep(self) -> float: ...
    def widget(self) -> QtWidgets.QWidget|None: ...


class GuidesConfig(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def setSnap(self, value: bool) -> None: ...
    def snap(self) -> bool: ...
    def setLocked(self, value: bool) -> None: ...
    def locked(self) -> bool: ...
    def setVisible(self, value: bool) -> None: ...
    def visible(self) -> bool: ...
    def removeAllGuides(self) -> None: ...
    def toXml(self) -> str: ...
    def fromXml(self, xmlContent: str|None) -> bool: ...
    def setVerticalGuides(self, lines: collections.abc.Iterable[float]) -> None: ...
    def verticalGuides(self) -> list[float]: ...
    def setHorizontalGuides(self, lines: collections.abc.Iterable[float]) -> None: ...
    def horizontalGuides(self) -> list[float]: ...
    def hasSamePositionAs(self, guideConfig: 'GuidesConfig') -> bool: ...
    def hasGuides(self) -> bool: ...
    def setLineType(self, lineType: str|None) -> None: ...
    def lineType(self) -> str: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class GridConfig(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def toXml(self) -> str: ...
    def fromXml(self, xmlContent: str|None) -> bool: ...
    def setColorVertical(self, colorVertical: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def colorVertical(self) -> QtGui.QColor: ...
    def setColorSubdivision(self, colorSubdivision: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def colorSubdivision(self) -> QtGui.QColor: ...
    def setColorMain(self, colorMain: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def colorMain(self) -> QtGui.QColor: ...
    def setLineTypeVertical(self, lineType: str|None) -> None: ...
    def lineTypeVertical(self) -> str: ...
    def setLineTypeSubdivision(self, lineType: str|None) -> None: ...
    def lineTypeSubdivision(self) -> str: ...
    def setLineTypeMain(self, lineType: str|None) -> None: ...
    def lineTypeMain(self) -> str: ...
    def setAngleAspectLocked(self, angleAspectLocked: bool) -> None: ...
    def angleAspectLocked(self) -> bool: ...
    def setSpacingAspectLocked(self, spacingAspectLocked: bool) -> None: ...
    def spacingAspectLocked(self) -> bool: ...
    def setOffsetAspectLocked(self, offsetAspectLocked: bool) -> None: ...
    def offsetAspectLocked(self) -> bool: ...
    def setType(self, gridType: str|None) -> None: ...
    def type(self) -> str: ...
    def setCellSize(self, cellSize: int) -> None: ...
    def cellSize(self) -> int: ...
    def setCellSpacing(self, cellSpacing: int) -> None: ...
    def cellSpacing(self) -> int: ...
    def setAngleRightActive(self, active: bool) -> None: ...
    def angleRightActive(self) -> bool: ...
    def setAngleLeftActive(self, active: bool) -> None: ...
    def angleLeftActive(self) -> bool: ...
    def setAngleRight(self, angleRight: float) -> None: ...
    def angleRight(self) -> float: ...
    def setAngleLeft(self, angleLeft: float) -> None: ...
    def angleLeft(self) -> float: ...
    def setSubdivision(self, subdivision: int) -> None: ...
    def subdivision(self) -> int: ...
    def setSpacingActiveVertical(self, active: bool) -> None: ...
    def spacingActiveVertical(self) -> bool: ...
    def setSpacingActiveHorizontal(self, active: bool) -> None: ...
    def spacingActiveHorizontal(self) -> bool: ...
    def setSpacing(self, spacing: QtCore.QPoint) -> None: ...
    def spacing(self) -> QtCore.QPoint: ...
    def setOffset(self, offset: QtCore.QPoint) -> None: ...
    def offset(self) -> QtCore.QPoint: ...
    def setSnap(self, snap: bool) -> None: ...
    def snap(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def visible(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class FileDialog(QtWidgets.QDialog):

    class DialogType(enum.Enum):
        OpenFile = ... # type: FileDialog.DialogType
        OpenFiles = ... # type: FileDialog.DialogType
        OpenDirectory = ... # type: FileDialog.DialogType
        ImportFile = ... # type: FileDialog.DialogType
        ImportFiles = ... # type: FileDialog.DialogType
        ImportDirectory = ... # type: FileDialog.DialogType
        SaveFile = ... # type: FileDialog.DialogType

    def __init__(self, parent: QtWidgets.QWidget|None = ..., type: 'FileDialog.DialogType' = ..., dialogName: str|None = ...) -> None: ...

    def onFilterSelected(self, filter: str|None) -> None: ...
    def selectedMimeType(self) -> str: ...
    def selectedNameFilter(self) -> str: ...
    def filename(self) -> str: ...
    def filenames(self) -> list[str]: ...
    def selectNameFilter(self, filter: str|None) -> None: ...
    def setNameFilter(self, filter: str|None) -> None: ...
    def setMimeTypeFilters(self, mimeTypeList: collections.abc.Iterable[str|None], defaultMimeType: str|None) -> None: ...
    def setImageFilters(self) -> None: ...
    def setDirectoryUrl(self, defaultUri: QtCore.QUrl) -> None: ...
    def setDefaultDir(self, defaultDir: str|None, force: bool) -> None: ...
    def setCaption(self, caption: str|None) -> None: ...
    @staticmethod
    def getSaveFileName(parent: QtWidgets.QWidget|None = ..., caption: str|None = ..., directory: str|None = ..., filter: str|None = ..., selectedFilter: str|None = ..., dialogName: str|None = ...) -> str: ...
    @staticmethod
    def getExistingDirectory(parent: QtWidgets.QWidget|None = ..., caption: str|None = ..., directory: str|None = ..., dialogName: str|None = ...) -> str: ...
    @staticmethod
    def getOpenFileNames(parent: QtWidgets.QWidget|None = ..., caption: str|None = ..., directory: str|None = ..., filter: str|None = ..., selectedFilter: str|None = ..., dialogName: str|None = ...) -> list[str]: ...
    @staticmethod
    def getOpenFileName(parent: QtWidgets.QWidget|None = ..., caption: str|None = ..., directory: str|None = ..., filter: str|None = ..., selectedFilter: str|None = ..., dialogName: str|None = ...) -> str: ...


from typing import Type


class DockWidgetFactory(DockWidgetFactoryBase):

    def __init__(self, _id: str, _dockPosition: DockWidgetFactoryBase.DockPosition, _klass: Type[DockWidget]): ...


def qDebug(text: str): ...

