﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elasticmapreduce/EMR_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EMR {
namespace Model {

/**
 * <p>Configuration of the script to run during a bootstrap action.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ScriptBootstrapActionConfig">AWS
 * API Reference</a></p>
 */
class ScriptBootstrapActionConfig {
 public:
  AWS_EMR_API ScriptBootstrapActionConfig() = default;
  AWS_EMR_API ScriptBootstrapActionConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_EMR_API ScriptBootstrapActionConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_EMR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Location in Amazon S3 of the script to run during a bootstrap action.</p>
   */
  inline const Aws::String& GetPath() const { return m_path; }
  inline bool PathHasBeenSet() const { return m_pathHasBeenSet; }
  template <typename PathT = Aws::String>
  void SetPath(PathT&& value) {
    m_pathHasBeenSet = true;
    m_path = std::forward<PathT>(value);
  }
  template <typename PathT = Aws::String>
  ScriptBootstrapActionConfig& WithPath(PathT&& value) {
    SetPath(std::forward<PathT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of command line arguments to pass to the bootstrap action script.</p>
   */
  inline const Aws::Vector<Aws::String>& GetArgs() const { return m_args; }
  inline bool ArgsHasBeenSet() const { return m_argsHasBeenSet; }
  template <typename ArgsT = Aws::Vector<Aws::String>>
  void SetArgs(ArgsT&& value) {
    m_argsHasBeenSet = true;
    m_args = std::forward<ArgsT>(value);
  }
  template <typename ArgsT = Aws::Vector<Aws::String>>
  ScriptBootstrapActionConfig& WithArgs(ArgsT&& value) {
    SetArgs(std::forward<ArgsT>(value));
    return *this;
  }
  template <typename ArgsT = Aws::String>
  ScriptBootstrapActionConfig& AddArgs(ArgsT&& value) {
    m_argsHasBeenSet = true;
    m_args.emplace_back(std::forward<ArgsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_path;
  bool m_pathHasBeenSet = false;

  Aws::Vector<Aws::String> m_args;
  bool m_argsHasBeenSet = false;
};

}  // namespace Model
}  // namespace EMR
}  // namespace Aws
