﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/events/CloudWatchEvents_EXPORTS.h>
#include <aws/events/model/ConnectionApiKeyAuthResponseParameters.h>
#include <aws/events/model/ConnectionBasicAuthResponseParameters.h>
#include <aws/events/model/ConnectionHttpParameters.h>
#include <aws/events/model/ConnectionOAuthResponseParameters.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudWatchEvents {
namespace Model {

/**
 * <p>Contains the authorization parameters to use for the
 * connection.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ConnectionAuthResponseParameters">AWS
 * API Reference</a></p>
 */
class ConnectionAuthResponseParameters {
 public:
  AWS_CLOUDWATCHEVENTS_API ConnectionAuthResponseParameters() = default;
  AWS_CLOUDWATCHEVENTS_API ConnectionAuthResponseParameters(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHEVENTS_API ConnectionAuthResponseParameters& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHEVENTS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The authorization parameters for Basic authorization.</p>
   */
  inline const ConnectionBasicAuthResponseParameters& GetBasicAuthParameters() const { return m_basicAuthParameters; }
  inline bool BasicAuthParametersHasBeenSet() const { return m_basicAuthParametersHasBeenSet; }
  template <typename BasicAuthParametersT = ConnectionBasicAuthResponseParameters>
  void SetBasicAuthParameters(BasicAuthParametersT&& value) {
    m_basicAuthParametersHasBeenSet = true;
    m_basicAuthParameters = std::forward<BasicAuthParametersT>(value);
  }
  template <typename BasicAuthParametersT = ConnectionBasicAuthResponseParameters>
  ConnectionAuthResponseParameters& WithBasicAuthParameters(BasicAuthParametersT&& value) {
    SetBasicAuthParameters(std::forward<BasicAuthParametersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The OAuth parameters to use for authorization.</p>
   */
  inline const ConnectionOAuthResponseParameters& GetOAuthParameters() const { return m_oAuthParameters; }
  inline bool OAuthParametersHasBeenSet() const { return m_oAuthParametersHasBeenSet; }
  template <typename OAuthParametersT = ConnectionOAuthResponseParameters>
  void SetOAuthParameters(OAuthParametersT&& value) {
    m_oAuthParametersHasBeenSet = true;
    m_oAuthParameters = std::forward<OAuthParametersT>(value);
  }
  template <typename OAuthParametersT = ConnectionOAuthResponseParameters>
  ConnectionAuthResponseParameters& WithOAuthParameters(OAuthParametersT&& value) {
    SetOAuthParameters(std::forward<OAuthParametersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The API Key parameters to use for authorization.</p>
   */
  inline const ConnectionApiKeyAuthResponseParameters& GetApiKeyAuthParameters() const { return m_apiKeyAuthParameters; }
  inline bool ApiKeyAuthParametersHasBeenSet() const { return m_apiKeyAuthParametersHasBeenSet; }
  template <typename ApiKeyAuthParametersT = ConnectionApiKeyAuthResponseParameters>
  void SetApiKeyAuthParameters(ApiKeyAuthParametersT&& value) {
    m_apiKeyAuthParametersHasBeenSet = true;
    m_apiKeyAuthParameters = std::forward<ApiKeyAuthParametersT>(value);
  }
  template <typename ApiKeyAuthParametersT = ConnectionApiKeyAuthResponseParameters>
  ConnectionAuthResponseParameters& WithApiKeyAuthParameters(ApiKeyAuthParametersT&& value) {
    SetApiKeyAuthParameters(std::forward<ApiKeyAuthParametersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Additional parameters for the connection that are passed through with every
   * invocation to the HTTP endpoint.</p>
   */
  inline const ConnectionHttpParameters& GetInvocationHttpParameters() const { return m_invocationHttpParameters; }
  inline bool InvocationHttpParametersHasBeenSet() const { return m_invocationHttpParametersHasBeenSet; }
  template <typename InvocationHttpParametersT = ConnectionHttpParameters>
  void SetInvocationHttpParameters(InvocationHttpParametersT&& value) {
    m_invocationHttpParametersHasBeenSet = true;
    m_invocationHttpParameters = std::forward<InvocationHttpParametersT>(value);
  }
  template <typename InvocationHttpParametersT = ConnectionHttpParameters>
  ConnectionAuthResponseParameters& WithInvocationHttpParameters(InvocationHttpParametersT&& value) {
    SetInvocationHttpParameters(std::forward<InvocationHttpParametersT>(value));
    return *this;
  }
  ///@}
 private:
  ConnectionBasicAuthResponseParameters m_basicAuthParameters;
  bool m_basicAuthParametersHasBeenSet = false;

  ConnectionOAuthResponseParameters m_oAuthParameters;
  bool m_oAuthParametersHasBeenSet = false;

  ConnectionApiKeyAuthResponseParameters m_apiKeyAuthParameters;
  bool m_apiKeyAuthParametersHasBeenSet = false;

  ConnectionHttpParameters m_invocationHttpParameters;
  bool m_invocationHttpParametersHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudWatchEvents
}  // namespace Aws
