﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediapackage-vod/MediaPackageVod_EXPORTS.h>
#include <aws/mediapackage-vod/model/SpekeKeyProvider.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaPackageVod {
namespace Model {

/**
 * A CMAF encryption configuration.<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CmafEncryption">AWS
 * API Reference</a></p>
 */
class CmafEncryption {
 public:
  AWS_MEDIAPACKAGEVOD_API CmafEncryption() = default;
  AWS_MEDIAPACKAGEVOD_API CmafEncryption(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIAPACKAGEVOD_API CmafEncryption& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIAPACKAGEVOD_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * An optional 128-bit, 16-byte hex value represented by a 32-character string,
   * used in conjunction with the key for encrypting blocks. If you don't specify a
   * value, then MediaPackage creates the constant initialization vector (IV).
   */
  inline const Aws::String& GetConstantInitializationVector() const { return m_constantInitializationVector; }
  inline bool ConstantInitializationVectorHasBeenSet() const { return m_constantInitializationVectorHasBeenSet; }
  template <typename ConstantInitializationVectorT = Aws::String>
  void SetConstantInitializationVector(ConstantInitializationVectorT&& value) {
    m_constantInitializationVectorHasBeenSet = true;
    m_constantInitializationVector = std::forward<ConstantInitializationVectorT>(value);
  }
  template <typename ConstantInitializationVectorT = Aws::String>
  CmafEncryption& WithConstantInitializationVector(ConstantInitializationVectorT&& value) {
    SetConstantInitializationVector(std::forward<ConstantInitializationVectorT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const SpekeKeyProvider& GetSpekeKeyProvider() const { return m_spekeKeyProvider; }
  inline bool SpekeKeyProviderHasBeenSet() const { return m_spekeKeyProviderHasBeenSet; }
  template <typename SpekeKeyProviderT = SpekeKeyProvider>
  void SetSpekeKeyProvider(SpekeKeyProviderT&& value) {
    m_spekeKeyProviderHasBeenSet = true;
    m_spekeKeyProvider = std::forward<SpekeKeyProviderT>(value);
  }
  template <typename SpekeKeyProviderT = SpekeKeyProvider>
  CmafEncryption& WithSpekeKeyProvider(SpekeKeyProviderT&& value) {
    SetSpekeKeyProvider(std::forward<SpekeKeyProviderT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_constantInitializationVector;
  bool m_constantInitializationVectorHasBeenSet = false;

  SpekeKeyProvider m_spekeKeyProvider;
  bool m_spekeKeyProviderHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaPackageVod
}  // namespace Aws
