﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ivs-realtime/IvsrealtimeRequest.h>
#include <aws/ivs-realtime/Ivsrealtime_EXPORTS.h>
#include <aws/ivs-realtime/model/AutoParticipantRecordingConfiguration.h>

#include <utility>

namespace Aws {
namespace ivsrealtime {
namespace Model {

/**
 */
class UpdateStageRequest : public IvsrealtimeRequest {
 public:
  AWS_IVSREALTIME_API UpdateStageRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateStage"; }

  AWS_IVSREALTIME_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>ARN of the stage to be updated.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  UpdateStageRequest& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Name of the stage to be updated.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateStageRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Configuration object for individual participant recording, to attach to the
   * stage. Note that this cannot be updated while recording is active.</p>
   */
  inline const AutoParticipantRecordingConfiguration& GetAutoParticipantRecordingConfiguration() const {
    return m_autoParticipantRecordingConfiguration;
  }
  inline bool AutoParticipantRecordingConfigurationHasBeenSet() const { return m_autoParticipantRecordingConfigurationHasBeenSet; }
  template <typename AutoParticipantRecordingConfigurationT = AutoParticipantRecordingConfiguration>
  void SetAutoParticipantRecordingConfiguration(AutoParticipantRecordingConfigurationT&& value) {
    m_autoParticipantRecordingConfigurationHasBeenSet = true;
    m_autoParticipantRecordingConfiguration = std::forward<AutoParticipantRecordingConfigurationT>(value);
  }
  template <typename AutoParticipantRecordingConfigurationT = AutoParticipantRecordingConfiguration>
  UpdateStageRequest& WithAutoParticipantRecordingConfiguration(AutoParticipantRecordingConfigurationT&& value) {
    SetAutoParticipantRecordingConfiguration(std::forward<AutoParticipantRecordingConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_name;

  AutoParticipantRecordingConfiguration m_autoParticipantRecordingConfiguration;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_autoParticipantRecordingConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace ivsrealtime
}  // namespace Aws
