﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/Tag.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
/**
 * <p>Describes a key pair.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/KeyPair">AWS API
 * Reference</a></p>
 */
class CreateKeyPairResponse {
 public:
  AWS_EC2_API CreateKeyPairResponse() = default;
  AWS_EC2_API CreateKeyPairResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API CreateKeyPairResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The ID of the key pair.</p>
   */
  inline const Aws::String& GetKeyPairId() const { return m_keyPairId; }
  template <typename KeyPairIdT = Aws::String>
  void SetKeyPairId(KeyPairIdT&& value) {
    m_keyPairIdHasBeenSet = true;
    m_keyPairId = std::forward<KeyPairIdT>(value);
  }
  template <typename KeyPairIdT = Aws::String>
  CreateKeyPairResponse& WithKeyPairId(KeyPairIdT&& value) {
    SetKeyPairId(std::forward<KeyPairIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Any tags applied to the key pair.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  CreateKeyPairResponse& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  CreateKeyPairResponse& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the key pair.</p>
   */
  inline const Aws::String& GetKeyName() const { return m_keyName; }
  template <typename KeyNameT = Aws::String>
  void SetKeyName(KeyNameT&& value) {
    m_keyNameHasBeenSet = true;
    m_keyName = std::forward<KeyNameT>(value);
  }
  template <typename KeyNameT = Aws::String>
  CreateKeyPairResponse& WithKeyName(KeyNameT&& value) {
    SetKeyName(std::forward<KeyNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <ul> <li> <p>For RSA key pairs, the key fingerprint is the SHA-1 digest of the
   * DER encoded private key.</p> </li> <li> <p>For ED25519 key pairs, the key
   * fingerprint is the base64-encoded SHA-256 digest, which is the default for
   * OpenSSH, starting with OpenSSH 6.8.</p> </li> </ul>
   */
  inline const Aws::String& GetKeyFingerprint() const { return m_keyFingerprint; }
  template <typename KeyFingerprintT = Aws::String>
  void SetKeyFingerprint(KeyFingerprintT&& value) {
    m_keyFingerprintHasBeenSet = true;
    m_keyFingerprint = std::forward<KeyFingerprintT>(value);
  }
  template <typename KeyFingerprintT = Aws::String>
  CreateKeyPairResponse& WithKeyFingerprint(KeyFingerprintT&& value) {
    SetKeyFingerprint(std::forward<KeyFingerprintT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An unencrypted PEM encoded RSA or ED25519 private key.</p>
   */
  inline const Aws::String& GetKeyMaterial() const { return m_keyMaterial; }
  template <typename KeyMaterialT = Aws::String>
  void SetKeyMaterial(KeyMaterialT&& value) {
    m_keyMaterialHasBeenSet = true;
    m_keyMaterial = std::forward<KeyMaterialT>(value);
  }
  template <typename KeyMaterialT = Aws::String>
  CreateKeyPairResponse& WithKeyMaterial(KeyMaterialT&& value) {
    SetKeyMaterial(std::forward<KeyMaterialT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  CreateKeyPairResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_keyPairId;

  Aws::Vector<Tag> m_tags;

  Aws::String m_keyName;

  Aws::String m_keyFingerprint;

  Aws::String m_keyMaterial;

  ResponseMetadata m_responseMetadata;
  bool m_keyPairIdHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_keyNameHasBeenSet = false;
  bool m_keyFingerprintHasBeenSet = false;
  bool m_keyMaterialHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
