/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class KingbaseUtils {
    private static final Log log = Log.getLog(KingbaseUtils.class);

    public static String getObjectComment(DBRProgressMonitor monitor, GenericStructContainer container, String schema, String object) throws DBException {
        String string;
        block8: {
            JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load Kingbase description");
            try {
                string = JDBCUtils.queryString((Connection)session, (String)"select description from sys_catalog.sys_description\njoin sys_catalog.sys_class on sys_description.objoid = sys_class.oid\njoin sys_catalog.sys_namespace on sys_class.relnamespace = sys_namespace.oid\nwhere sys_class.relname = ? and sys_namespace.nspname=?", (Object[])new Object[]{object, schema});
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.debug((Object)e);
                    return null;
                }
            }
            session.close();
        }
        return string;
    }

    public static boolean isKBObject(Object object) {
        if (object == null) {
            return false;
        }
        String className = object.getClass().getName();
        return className.equals("com.kingbase8.util.KBobject");
    }

    public static Object extractKBObjectValue(Object kbObject) {
        if (kbObject == null) {
            return null;
        }
        if (!KingbaseUtils.isKBObject(kbObject)) {
            return kbObject;
        }
        try {
            return kbObject.getClass().getMethod("getValue", new Class[0]).invoke(kbObject, new Object[0]);
        }
        catch (Exception e) {
            log.debug((Object)("Can't extract value from " + kbObject.getClass().getName()), (Throwable)e);
            return null;
        }
    }

    public static long[] getIdVector(Object kbObject) {
        Object kbVector = KingbaseUtils.extractKBObjectValue(kbObject);
        if (kbVector == null) {
            return null;
        }
        if (kbVector instanceof String) {
            String vector = (String)kbVector;
            if (vector.isEmpty()) {
                return null;
            }
            String[] strings = vector.split(" ");
            long[] ids = new long[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                ids[i] = CommonUtils.toLong((Object)strings[i]);
            }
            return ids;
        }
        if (kbVector instanceof long[]) {
            return (long[])kbVector;
        }
        if (kbVector instanceof Long[]) {
            Long[] objVector = (Long[])kbVector;
            long[] result = new long[objVector.length];
            for (int i = 0; i < objVector.length; ++i) {
                result[i] = objVector[i];
            }
            return result;
        }
        if (kbVector instanceof Number) {
            return new long[]{((Number)kbVector).longValue()};
        }
        if (kbVector instanceof java.sql.Array) {
            try {
                Object array = ((java.sql.Array)kbVector).getArray();
                if (array == null) {
                    return null;
                }
                int length = Array.getLength(array);
                long[] result = new long[length];
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(array, i);
                    if (item instanceof Number) {
                        result[i] = ((Number)item).longValue();
                        continue;
                    }
                    if (item == null) continue;
                    throw new IllegalArgumentException("Bad array item type: " + item.getClass().getName());
                }
                return result;
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Error reading array value: " + String.valueOf(kbVector));
            }
        }
        throw new IllegalArgumentException("Unsupported vector type: " + kbVector.getClass().getName());
    }

    public static int[] getIntVector(Object kbObject) {
        Object kbVector = KingbaseUtils.extractKBObjectValue(kbObject);
        if (kbVector == null) {
            return null;
        }
        if (kbVector instanceof String) {
            String vector = (String)kbVector;
            if (vector.isEmpty()) {
                return null;
            }
            String[] strings = vector.split(" ");
            int[] ids = new int[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                ids[i] = CommonUtils.toInt((Object)strings[i]);
            }
            return ids;
        }
        if (kbVector instanceof int[]) {
            int[] intVector = (int[])kbVector;
            return intVector;
        }
        if (kbVector instanceof Integer[]) {
            Integer[] objVector = (Integer[])kbVector;
            int[] result = new int[objVector.length];
            for (int i = 0; i < objVector.length; ++i) {
                result[i] = objVector[i];
            }
            return result;
        }
        if (kbVector instanceof Number) {
            Number number = (Number)kbVector;
            return new int[]{number.intValue()};
        }
        if (kbVector instanceof java.sql.Array) {
            java.sql.Array kbArray = (java.sql.Array)kbVector;
            try {
                Object array = kbArray.getArray();
                if (array == null) {
                    return null;
                }
                int length = Array.getLength(array);
                int[] result = new int[length];
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(array, i);
                    if (item instanceof Number) {
                        result[i] = ((Number)item).intValue();
                        continue;
                    }
                    if (item == null) continue;
                    throw new IllegalArgumentException("Bad array item type: " + item.getClass().getName());
                }
                return result;
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Error reading array value: " + String.valueOf(kbVector));
            }
        }
        throw new IllegalArgumentException("Unsupported vector type: " + kbVector.getClass().getName());
    }

    public static String getQueryForSystemColumnChecking(@NotNull String tableName, @NotNull String columnName) {
        if (tableName.contains("pg_")) {
            tableName.replaceAll("pg_", "sys_");
        }
        return "SELECT " + columnName + " FROM sys_catalog." + tableName + " WHERE 1<>1 LIMIT 1";
    }

    public static boolean isMetaObjectExists(@NotNull JDBCSession session, @NotNull String tableName, @NotNull String columnName) {
        try {
            JDBCUtils.queryString((Connection)session, (String)KingbaseUtils.getQueryForSystemColumnChecking(tableName, columnName), (Object[])new Object[0]);
            return true;
        }
        catch (SQLException e) {
            log.debug((Object)("Error reading system information from the " + tableName + " table: " + e.getMessage()));
            return false;
        }
    }
}

