/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableInheritance;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePolicy;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstrainable;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.cache.SimpleObjectCache;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTable
extends PostgreTableReal
implements PostgreTableContainer,
DBDPseudoAttributeContainer,
DBSEntityConstrainable {
    private static final Log log = Log.getLog(PostgreTable.class);
    private final SimpleObjectCache<PostgreTable, PostgreTableForeignKey> foreignKeys = new SimpleObjectCache();
    private final PolicyCache policyCache = new PolicyCache();
    private boolean hasOids;
    private long tablespaceId;
    private List<PostgreTableInheritance> superTables;
    private List<PostgreTableInheritance> subTables;
    private boolean hasSubClasses;
    private boolean hasPartitions;
    private boolean hasRowLevelSecurity;
    private String partitionKey;
    private String partitionRange;
    private long depObjectId;
    private long depObjectAttrNumber;

    public PostgreTable(PostgreTableContainer container) {
        super(container);
    }

    public PostgreTable(PostgreTableContainer container, ResultSet dbResult) {
        super(container, dbResult);
        if (((PostgreDataSource)this.getDataSource()).getServerType().supportsHasOidsColumn()) {
            this.hasOids = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relhasoids");
        }
        this.tablespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"reltablespace");
        this.hasSubClasses = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relhassubclass");
        this.partitionKey = ((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(10, 0) ? JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_key") : null;
        this.hasPartitions = this.partitionKey != null;
        this.hasRowLevelSecurity = ((PostgreDataSource)this.getDataSource()).getServerType().supportsRowLevelSecurity() && JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relrowsecurity");
    }

    public PostgreTable(DBRProgressMonitor monitor, PostgreTableContainer container, PostgreTable source, boolean persisted) throws DBException {
        super(monitor, container, source, persisted);
        this.hasOids = source.hasOids;
        this.tablespaceId = container == source.getContainer() ? source.tablespaceId : 0L;
        this.partitionKey = source.partitionKey;
        PostgreSchema.IndexCache indexCache = this.getSchema().getIndexCache();
        if (indexCache != null) {
            for (PostgreIndex srcIndex : CommonUtils.safeCollection(source.getIndexes(monitor))) {
                if (srcIndex.isPrimaryKeyIndex()) continue;
                PostgreIndex constr = new PostgreIndex(monitor, this, srcIndex);
                indexCache.cacheObject(constr);
            }
        }
    }

    public SimpleObjectCache<PostgreTable, PostgreTableForeignKey> getForeignKeyCache() {
        return this.foreignKeys;
    }

    public boolean isTablespaceSpecified() {
        return this.tablespaceId != 0L;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=PostgreTableBase.TablespaceListProvider.class)
    public PostgreTablespace getTablespace(DBRProgressMonitor monitor) throws DBException {
        if (this.tablespaceId == 0L) {
            return this.getDatabase().getDefaultTablespace(monitor);
        }
        return (PostgreTablespace)PostgreUtils.getObjectById(monitor, this.getDatabase().tablespaceCache, this.getDatabase(), this.tablespaceId);
    }

    public void setTablespace(PostgreTablespace tablespace) {
        this.tablespaceId = tablespace.getObjectId();
    }

    public boolean isView() {
        return false;
    }

    @Property(editable=true, updatable=true, order=40, visibleIf=PostgreColumnHasOidsValidator.class)
    public boolean isHasOids() {
        return this.hasOids;
    }

    public void setHasOids(boolean hasOids) {
        this.hasOids = hasOids;
    }

    @Property(viewable=true, updatable=true, order=41, visibleIf=PostgreColumnHasRowLevelSecurity.class)
    public boolean isHasRowLevelSecurity() {
        return this.hasRowLevelSecurity;
    }

    public void setHasRowLevelSecurity(boolean hasRowLevelSecurity) {
        this.hasRowLevelSecurity = hasRowLevelSecurity;
    }

    @Property(viewable=true, order=42)
    public boolean hasPartitions() {
        return this.hasPartitions;
    }

    @Property(viewable=true, editable=true, updatable=true, order=43)
    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    @Override
    protected void fetchStatistics(JDBCResultSet dbResult) throws DBException, SQLException {
        super.fetchStatistics(dbResult);
        if (this.diskSpace != null && this.diskSpace == 0L && this.hasSubClasses) {
            this.getPartitions(dbResult.getSession().getProgressMonitor());
        }
    }

    @Override
    public long getStatObjectSize() {
        if (this.diskSpace != null && this.subTables != null) {
            long partSizeSum = this.diskSpace;
            for (PostgreTableInheritance ti : this.subTables) {
                PostgreTableBase partTable = (PostgreTableBase)ti.getParentObject();
                if (!partTable.isPartition() || !(partTable instanceof PostgreTableReal)) continue;
                partSizeSum += ((PostgreTableReal)partTable).getStatObjectSize();
            }
            return partSizeSum;
        }
        return super.getStatObjectSize();
    }

    public Collection<PostgreIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportsIndexes()) {
            return Collections.emptyList();
        }
        return this.getSchema().getIndexes(monitor, this);
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)this, options, (boolean)false);
    }

    private boolean hasOidPseudoAttribute() {
        return this.hasOids && ((PostgreDataSource)this.getDataSource()).getServerType().supportsOids();
    }

    public DBDPseudoAttribute[] getPseudoAttributes() {
        if (this.hasOidPseudoAttribute()) {
            return new DBDPseudoAttribute[]{PostgreConstants.PSEUDO_ATTR_OID};
        }
        return null;
    }

    public DBDPseudoAttribute[] getAllPseudoAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return DBDPseudoAttribute.EMPTY_ARRAY;
    }

    @Override
    @Association
    public synchronized Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableInheritance> superTables = this.getSuperInheritance(monitor);
        Collection<PostgreTableForeignKey> foreignKeys = this.getForeignKeys(monitor);
        if (CommonUtils.isEmpty(superTables)) {
            return foreignKeys;
        }
        if (CommonUtils.isEmpty(foreignKeys)) {
            return superTables;
        }
        ArrayList<PostgreTableConstraintBase> agg = new ArrayList<PostgreTableConstraintBase>(superTables.size() + foreignKeys.size());
        agg.addAll(superTables);
        agg.addAll(foreignKeys);
        return agg;
    }

    @Override
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (monitor == null || monitor.isForceCacheUsage()) {
            return null;
        }
        ArrayList<PostgreTableForeignKey> refs = new ArrayList<PostgreTableForeignKey>(CommonUtils.safeList(this.getSubInheritance(monitor)));
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read referencing schemas");){
            try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DISTINCT connamespace FROM pg_catalog.pg_constraint WHERE confrelid=?");){
                dbStat.setLong(1, this.getObjectId());
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (int)1);
                        PostgreSchema schema = ((PostgreTableContainer)this.getContainer()).getDatabase().getSchema(monitor, schemaId);
                        if (schema == null) continue;
                        List allForeignKeys = schema.getConstraintCache().getTypedObjects(monitor, schema, PostgreTableForeignKey.class);
                        for (PostgreTableForeignKey constraint : allForeignKeys) {
                            if (constraint.getAssociatedEntity() != this) continue;
                            refs.add(constraint);
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, this.getDataSource());
            }
        }
        return refs;
    }

    @Association
    public Collection<PostgreTableForeignKey> getForeignKeys(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().getConstraintCache().getTypedObjects(monitor, this.getSchema(), this, PostgreTableForeignKey.class);
    }

    @Property(viewable=false, optional=true, order=30)
    @Nullable
    public List<PostgreTableBase> getSuperTables(DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableInheritance> si = this.getSuperInheritance(monitor);
        if (CommonUtils.isEmpty(si)) {
            return null;
        }
        ArrayList<PostgreTableBase> result = new ArrayList<PostgreTableBase>(si.size());
        for (int i1 = 0; i1 < si.size(); ++i1) {
            result.add(si.get(i1).getAssociatedEntity());
        }
        return result;
    }

    @Property(viewable=false, optional=true, order=31)
    @Nullable
    public List<PostgreTableBase> getSubTables(DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableInheritance> si = this.getSubInheritance(monitor);
        if (CommonUtils.isEmpty(si)) {
            return null;
        }
        ArrayList<PostgreTableBase> result = new ArrayList<PostgreTableBase>(si.size());
        for (PostgreTableInheritance aSi : si) {
            PostgreTableBase table = (PostgreTableBase)aSi.getParentObject();
            if (table.isPartition()) continue;
            result.add(table);
        }
        return result;
    }

    @Nullable
    public List<PostgreTableInheritance> getSuperInheritance(DBRProgressMonitor monitor) throws DBException {
        if (this.superTables == null && ((PostgreDataSource)this.getDataSource()).getServerType().supportsInheritance() && this.isPersisted() && monitor != null) {
            if (monitor.isForceCacheUsage()) {
                return Collections.emptyList();
            }
            this.superTables = this.initSuperTables(monitor);
        }
        return this.superTables == null || this.superTables.isEmpty() ? null : this.superTables;
    }

    void addSuperTableInheritance(PostgreTableBase superTable, int seqNum) {
        PostgreTableInheritance inheritance = new PostgreTableInheritance((PostgreTableBase)this, superTable, seqNum, true);
        if (this.superTables == null) {
            this.superTables = new ArrayList<PostgreTableInheritance>();
        }
        this.superTables.add(inheritance);
    }

    void nullifyEmptySuperTableInheritance() {
        if (this.superTables == null) {
            this.superTables = new ArrayList<PostgreTableInheritance>();
        }
    }

    void resetSuperInheritance() {
        this.superTables = null;
    }

    private List<PostgreTableInheritance> initSuperTables(DBRProgressMonitor monitor) throws DBException {
        ArrayList<PostgreTableInheritance> inheritanceList = new ArrayList<PostgreTableInheritance>();
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table inheritance info");){
            ArrayList<PostgreTableInheritance> arrayList;
            block24: {
                JDBCPreparedStatement dbStat = session.prepareStatement("SELECT i.*,c.relnamespace FROM pg_catalog.pg_inherits i,pg_catalog.pg_class c WHERE i.inhrelid=? AND c.oid=i.inhparent ORDER BY i.inhseqno");
                try {
                    dbStat.setLong(1, this.getObjectId());
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            long parentSchemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                            long parentTableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"inhparent");
                            PostgreSchema schema = this.getDatabase().getSchema(monitor, parentSchemaId);
                            if (schema == null) {
                                log.warn((Object)("Can't find parent table's schema '" + parentSchemaId + "'"));
                                continue;
                            }
                            PostgreTableBase parentTable = schema.getTable(monitor, parentTableId);
                            if (parentTable == null) {
                                log.warn((Object)("Can't find parent table '" + parentTableId + "' in '" + schema.getName() + "'"));
                                continue;
                            }
                            inheritanceList.add(new PostgreTableInheritance((PostgreTableBase)this, parentTable, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"inhseqno"), true));
                        }
                    }
                    arrayList = inheritanceList;
                    if (dbStat == null) break block24;
                }
                catch (Throwable throwable) {
                    try {
                        if (dbStat != null) {
                            try {
                                dbStat.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                    }
                }
                dbStat.close();
            }
            return arrayList;
        }
    }

    @Nullable
    public String getPartitionRange(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionRange == null && ((PostgreDataSource)this.getDataSource()).getServerType().supportsInheritance()) {
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table partition range");){
                try (JDBCPreparedStatement dbStat = session.prepareStatement("select pg_get_expr(c.relpartbound, c.oid, true) as partition_range from \"pg_catalog\".pg_class c where relname = ? and relnamespace = ?;");){
                    dbStat.setString(1, this.getName());
                    dbStat.setLong(2, this.getSchema().oid);
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        dbResult.next();
                        this.partitionRange = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_range");
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
            }
        }
        return this.partitionRange;
    }

    public boolean hasSubClasses() {
        return this.hasSubClasses;
    }

    @Nullable
    public List<PostgreTableInheritance> getSubInheritance(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.isPersisted() && this.subTables == null && this.hasSubClasses && ((PostgreDataSource)this.getDataSource()).getServerType().supportsInheritance()) {
            ArrayList<PostgreTableInheritance> tables = new ArrayList<PostgreTableInheritance>();
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table inheritance info");){
                String sql = "SELECT i.*,c.relnamespace FROM pg_catalog.pg_inherits i,pg_catalog.pg_class c WHERE i.inhparent=? AND c.oid=i.inhrelid";
                try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                    dbStat.setLong(1, this.getObjectId());
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            long subSchemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                            long subTableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"inhrelid");
                            PostgreSchema schema = this.getDatabase().getSchema(monitor, subSchemaId);
                            if (schema == null) {
                                log.warn((Object)("Can't find sub-table's schema '" + subSchemaId + "'"));
                                continue;
                            }
                            PostgreTableBase subTable = schema.getTable(monitor, subTableId);
                            if (subTable == null) {
                                log.warn((Object)("Can't find sub-table '" + subTableId + "' in '" + schema.getName() + "'"));
                                continue;
                            }
                            tables.add(new PostgreTableInheritance(subTable, this, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"inhseqno"), true));
                        }
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
            }
            DBUtils.orderObjects(tables);
            this.subTables = tables;
        }
        return this.subTables == null || this.subTables.isEmpty() ? null : this.subTables;
    }

    @Nullable
    @Association
    public List<PostgreTableBase> getPartitions(DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableInheritance> si = this.getSubInheritance(monitor);
        if (CommonUtils.isEmpty(si)) {
            return null;
        }
        return si.stream().map(AbstractTableConstraint::getParentObject).filter(PostgreTableBase::isPartition).collect(Collectors.toList());
    }

    @NotNull
    @Association
    public List<PostgreTablePolicy> getPolicies(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.policyCache.getAllObjects(monitor, this);
    }

    @Nullable
    public PostgreTablePolicy getPolicy(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (PostgreTablePolicy)this.policyCache.getObject(monitor, this, name);
    }

    @NotNull
    public PolicyCache getPolicyCache() {
        return this.policyCache;
    }

    @Override
    public boolean supportsObjectDefinitionOption(@NotNull String option) {
        if (this.hasPartitions && "ddl.includePartitions".equals(option)) {
            return true;
        }
        return super.supportsObjectDefinitionOption(option);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.superTables = null;
        this.subTables = null;
        this.policyCache.clearCache();
        return super.refreshObject(monitor);
    }

    @NotNull
    public List<DBSEntityConstraintInfo> getSupportedConstraints() {
        return List.of(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.PRIMARY_KEY, PostgreTableConstraint.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.UNIQUE_KEY, PostgreTableConstraint.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.INDEX, PostgreIndex.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.CHECK, PostgreTableConstraint.class));
    }

    public static class PolicyCache
    extends JDBCObjectCache<PostgreTable, PostgreTablePolicy> {
        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreTable table) throws SQLException {
            JDBCPreparedStatement stmt = session.prepareStatement("select * from pg_catalog.pg_policies where schemaname=? and tablename=?");
            stmt.setString(1, table.getSchema().getName());
            stmt.setString(2, table.getName());
            return stmt;
        }

        @Nullable
        protected PostgreTablePolicy fetchObject(@NotNull JDBCSession session, @NotNull PostgreTable table, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new PostgreTablePolicy(session.getProgressMonitor(), table, (ResultSet)resultSet);
        }
    }

    public static class PostgreColumnHasRowLevelSecurity
    implements IPropertyValueValidator<PostgreTable, Object> {
        public boolean isValidValue(@NotNull PostgreTable object, @Nullable Object value) throws IllegalArgumentException {
            return ((PostgreDataSource)object.getDataSource()).getServerType().supportsRowLevelSecurity();
        }
    }

    public static class PostgreColumnHasOidsValidator
    implements IPropertyValueValidator<PostgreTable, Object> {
        public boolean isValidValue(@NotNull PostgreTable object, @Nullable Object value) throws IllegalArgumentException {
            return ((PostgreDataSource)object.getDataSource()).getServerType().supportsHasOidsColumn();
        }
    }
}

