/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.utils.CommonUtils;

public abstract class DataSourceJob
extends AbstractJob
implements DBPDataSourceTask {
    private final DBCExecutionContext executionContext;

    protected DataSourceJob(String name, @NotNull DBCExecutionContext executionContext) {
        super(CommonUtils.truncateString((String)name, (int)1000));
        this.executionContext = executionContext;
        final DBPDataSourceContainer dataSourceContainer = executionContext.getDataSource().getContainer();
        this.setUser(true);
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(this){
            final /* synthetic */ DataSourceJob this$0;
            {
                this.this$0 = this$0;
            }

            public void aboutToRun(IJobChangeEvent event) {
                dataSourceContainer.acquire(this.this$0);
            }

            public void done(IJobChangeEvent event) {
                dataSourceContainer.release(this.this$0);
            }
        });
    }

    @NotNull
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.executionContext.getDataSource().getContainer();
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public boolean belongsTo(Object family) {
        return this.executionContext == family || family == DBPDataSource.class;
    }

    @Override
    public boolean isActiveTask() {
        return this.getState() == 4;
    }
}

